package util;

import play.db.jpa.Model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * Created by Leonidas on 09/04/14.
 */
public class JSONModel {
    public Long id;
    public String className;
    public String text;
    public String url;

    public JSONModel(Model model) {
        this.id = model.id;
        this.className = model.getClass().getName();
        this.text=model.toString();
        try {
            Method getUrl = model.getClass().getDeclaredMethod("getUrl",null);
            this.url = (String) getUrl.invoke(model);
        } catch (NoSuchMethodException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static List<JSONModel> getFromModels(Collection<Model> models) {
        List<JSONModel> result = new ArrayList<JSONModel>();
        for(Model model:models){
            result.add(new JSONModel(model));
        }
        return result;
    }



}
