package models.contacts;

import models.*;
import models.projects.Project;
import org.joda.time.DateTime;
import play.data.validation.Required;
import play.db.jpa.JPA;
import play.mvc.Router;

import javax.persistence.*;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by dom on 7/12/2018.
 */
@Entity
public class Person extends  Contact implements Event  {

    @Required
    @Searchable
    public String firstName;
    @Required
    @Searchable
    public String lastName;
    public String position;
    public PersonType personType;

    @ManyToMany
    public List<Document> sharedDocuments = new ArrayList<>();

    @OneToMany
    public List<Share> shares = new ArrayList<>();

    @ManyToOne
    public Customer customer; //a person may be an employee of a customer

    @ManyToMany(mappedBy = "userSet")
    public Set<Project> projects = new HashSet<>();

    @ManyToMany(mappedBy = "userSet")
    public Set<Task> taskSet = new HashSet<>();

    @Override
    public DateTime getStartDate() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.getFullName();
    }

    @Override
    public String getCalendarContent() {
        return null;
    }

    @Override
    public String getUrl() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        return Router.getFullUrl("Contacts.addAssociate", map);
    }

    @Override
    public String getUploadedBy() {
        return null;
    }

    @Override
    public JSONEvent getEvent() {
        return null;
    }


    public enum PersonType {
        CONTACT,
        ASSOCIATE
    }

    public Person()
    {

    }

    public Person(String firstname, String lastname, String position, Integer personType)
    {
        super();
        this.firstName = firstname;
        this.lastName = lastname;
        this.position = position;
        this.personType = PersonType.values()[personType];
    }

    public String getFullName(){
        return (this.firstName==null?"":this.firstName)+(this.lastName==null?"":(" "+this.lastName));
    }

    public boolean hasTasks()
    {
        List<Task> tasks = Task.findAll();
        for(Task t : tasks)
        {
            for(AppUser u: t.userSet)
            {
                if(u.id==this.id)
                {
                    return true;
                }
            }
        }
        return false;
    }
    public long getNumberOfActiveTasks()
    {
        return  this.taskSet.stream().filter(t -> t.status.equals("0")).count();
    }

    @Override
    public String toString() {
        return getFullName();
    }

    public List<Task> getActiveTasks()
    {
        List<Task> tasks = null;
        AppUser user = AppUser.findById(this.id);
        if(user != null)
        {
            if(user.roleInfo.roleName.equals("viewer"))
            {
                List<Task> tmplist = new ArrayList<Task>();
                tmplist.addAll(this.taskSet);
                tasks = tmplist.stream().filter(t -> t.getClass().getSimpleName().equals("Task")).collect(Collectors.toList());
                tasks = tasks.stream().filter(t -> t.status.equals("0")).collect(Collectors.toList());
            }
            else {
                tasks = Task.find("select t from Task t where t.company=:comp and t.status='0' and dtype='Task' and  :value MEMBER OF t.userSet")
                        .setParameter("comp", user.company)
                        .setParameter("value", user).fetch();
            }
        }

        return tasks;
    }




}
