package models.chat;

import models.AppUser;
import models.Document;
import models.Event;
import models.contacts.Contact;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import play.db.jpa.Model;
import play.mvc.Router;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by dom on 4/12/2018.
 */
@Entity
public class Message extends Model implements Event {

    @ManyToOne
    public AppUser msgSender;

    @ManyToMany
    public List<AppUser> recipients = new ArrayList<>();

    @OneToOne
    public Message msgReference; //if the message is a reply to another message

    public String msgContent;

    @ManyToOne
    public Document document;

    @OneToMany(mappedBy = "message", cascade = CascadeType.ALL)
    public List<Document> attachedDoc;

    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime sendDate;


    public Message()
    {

    }

    @Override
    public DateTime getStartDate() {
        return sendDate;
    }

    @Override
    public String getTitle() {
        return document.getTitle();
    }

    @Override
    public String getCalendarContent() {
        return msgContent;
    }

    @Override
    public String getUrl() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.document.project.id);
        return Router.getFullUrl("Projects.addProject", map);
    }

    @Override
    public String getUploadedBy() {
        return msgSender.getFullName();
    }

    @Override
    public JSONEvent getEvent() {
        JSONEvent event = new JSONEvent(getStartDate().toDate(), getTitle(), getCalendarContent(), "#49742c", this.getUrl(), this.getUploadedBy(), this.getClass());
        return event;
    }
}
