package models;

import models.contacts.Person;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.Logger;
import play.db.jpa.Model;
import play.mvc.Router;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import java.util.*;

/**
 * Created by dom on 28/12/2018.
 */
@Entity
public class Reminder extends Model implements Event {

    @ManyToOne
    public Task task;

    @ManyToMany(mappedBy = "reminders")
    public Set<AppUser> userSet = new TreeSet<>();

    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime reminderDate;

    public String reminderText;

    public Means mean;

    @Override
    public DateTime getStartDate() {
        return reminderDate;
    }

    @Override
    public String getTitle() {
        return task.getTitle();
    }

    @Override
    public String getCalendarContent() {
        Map map = new HashMap<String, Object>();
        Map map2 = new HashMap<String, Object>();
        String content = "";
        for(AppUser u : this.userSet)
        {
            content += "<a class='user yellow'  href='Router.reverse(\"Contacts.addAssociate\", map).url'>" + u.getFullName()+ "</a> - ";
        }

        return "Ειδοποίηση τους : "+content;

    }

    @Override
    public String getUrl() {
        return null;
    }

    @Override
    public String getUploadedBy() {
        return null;
    }

    @Override
    public JSONEvent getEvent() {
        JSONEvent event = new JSONEvent(getStartDate().toDate(), "Ειδοποίηση: " + getTitle(), getCalendarContent(), "#dc3545", this.getUrl(), this.getUploadedBy(), this.getClass());
        return event;
    }


    public enum Means {
        EMAIL,
        SMS,
        BOTH,
        NONE
    }

    public Reminder(){

    }


    public String getReminderDateString()
    {
        if (this.reminderDate == null) {
            return "";
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm");
        return fmt.print(reminderDate);
    }

    public String getRecipientsString() {
        if(this.userSet.isEmpty())
            return "";

        String result ="";
        for(AppUser usr : this.userSet)
        {
            result +=usr.getFullName()+" / ";
        }

        return  result.substring(0, result.length()-2);
    }



}
