/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1.room.participant;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.room.participant.SubscribedTrack;

public class SubscribedTrackUpdater
extends Updater<SubscribedTrack> {
    private final String pathRoomSid;
    private final String pathSubscriberSid;
    private String track;
    private String publisher;
    private SubscribedTrack.Kind kind;
    private SubscribedTrack.Status status;

    public SubscribedTrackUpdater(String pathRoomSid, String pathSubscriberSid) {
        this.pathRoomSid = pathRoomSid;
        this.pathSubscriberSid = pathSubscriberSid;
    }

    public SubscribedTrackUpdater setTrack(String track) {
        this.track = track;
        return this;
    }

    public SubscribedTrackUpdater setPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public SubscribedTrackUpdater setKind(SubscribedTrack.Kind kind) {
        this.kind = kind;
        return this;
    }

    public SubscribedTrackUpdater setStatus(SubscribedTrack.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public SubscribedTrack update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VIDEO.toString(), "/v1/Rooms/" + this.pathRoomSid + "/Participants/" + this.pathSubscriberSid + "/SubscribedTracks", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SubscribedTrack update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return SubscribedTrack.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.track != null) {
            request.addPostParam("Track", this.track.toString());
        }
        if (this.publisher != null) {
            request.addPostParam("Publisher", this.publisher.toString());
        }
        if (this.kind != null) {
            request.addPostParam("Kind", this.kind.toString());
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

