/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.WorkspaceCreator;
import com.twilio.rest.taskrouter.v1.WorkspaceDeleter;
import com.twilio.rest.taskrouter.v1.WorkspaceFetcher;
import com.twilio.rest.taskrouter.v1.WorkspaceReader;
import com.twilio.rest.taskrouter.v1.WorkspaceUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Workspace
extends Resource {
    private static final long serialVersionUID = 173419493907327L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String defaultActivityName;
    private final String defaultActivitySid;
    private final URI eventCallbackUrl;
    private final String eventsFilter;
    private final String friendlyName;
    private final Boolean multiTaskEnabled;
    private final String sid;
    private final String timeoutActivityName;
    private final String timeoutActivitySid;
    private final QueueOrder prioritizeQueueOrder;
    private final URI url;
    private final Map<String, String> links;

    public static WorkspaceFetcher fetcher(String pathSid) {
        return new WorkspaceFetcher(pathSid);
    }

    public static WorkspaceUpdater updater(String pathSid) {
        return new WorkspaceUpdater(pathSid);
    }

    public static WorkspaceReader reader() {
        return new WorkspaceReader();
    }

    public static WorkspaceCreator creator(String friendlyName) {
        return new WorkspaceCreator(friendlyName);
    }

    public static WorkspaceDeleter deleter(String pathSid) {
        return new WorkspaceDeleter(pathSid);
    }

    public static Workspace fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Workspace.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Workspace fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Workspace.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Workspace(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="default_activity_name") String defaultActivityName, @JsonProperty(value="default_activity_sid") String defaultActivitySid, @JsonProperty(value="event_callback_url") URI eventCallbackUrl, @JsonProperty(value="events_filter") String eventsFilter, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="multi_task_enabled") Boolean multiTaskEnabled, @JsonProperty(value="sid") String sid, @JsonProperty(value="timeout_activity_name") String timeoutActivityName, @JsonProperty(value="timeout_activity_sid") String timeoutActivitySid, @JsonProperty(value="prioritize_queue_order") QueueOrder prioritizeQueueOrder, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.defaultActivityName = defaultActivityName;
        this.defaultActivitySid = defaultActivitySid;
        this.eventCallbackUrl = eventCallbackUrl;
        this.eventsFilter = eventsFilter;
        this.friendlyName = friendlyName;
        this.multiTaskEnabled = multiTaskEnabled;
        this.sid = sid;
        this.timeoutActivityName = timeoutActivityName;
        this.timeoutActivitySid = timeoutActivitySid;
        this.prioritizeQueueOrder = prioritizeQueueOrder;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDefaultActivityName() {
        return this.defaultActivityName;
    }

    public final String getDefaultActivitySid() {
        return this.defaultActivitySid;
    }

    public final URI getEventCallbackUrl() {
        return this.eventCallbackUrl;
    }

    public final String getEventsFilter() {
        return this.eventsFilter;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Boolean getMultiTaskEnabled() {
        return this.multiTaskEnabled;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTimeoutActivityName() {
        return this.timeoutActivityName;
    }

    public final String getTimeoutActivitySid() {
        return this.timeoutActivitySid;
    }

    public final QueueOrder getPrioritizeQueueOrder() {
        return this.prioritizeQueueOrder;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace other = (Workspace)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.defaultActivityName, other.defaultActivityName) && Objects.equals(this.defaultActivitySid, other.defaultActivitySid) && Objects.equals(this.eventCallbackUrl, other.eventCallbackUrl) && Objects.equals(this.eventsFilter, other.eventsFilter) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.multiTaskEnabled, other.multiTaskEnabled) && Objects.equals(this.sid, other.sid) && Objects.equals(this.timeoutActivityName, other.timeoutActivityName) && Objects.equals(this.timeoutActivitySid, other.timeoutActivitySid) && Objects.equals((Object)this.prioritizeQueueOrder, (Object)other.prioritizeQueueOrder) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.dateCreated, this.dateUpdated, this.defaultActivityName, this.defaultActivitySid, this.eventCallbackUrl, this.eventsFilter, this.friendlyName, this.multiTaskEnabled, this.sid, this.timeoutActivityName, this.timeoutActivitySid, this.prioritizeQueueOrder, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("defaultActivityName", this.defaultActivityName).add("defaultActivitySid", this.defaultActivitySid).add("eventCallbackUrl", this.eventCallbackUrl).add("eventsFilter", this.eventsFilter).add("friendlyName", this.friendlyName).add("multiTaskEnabled", this.multiTaskEnabled).add("sid", this.sid).add("timeoutActivityName", this.timeoutActivityName).add("timeoutActivitySid", this.timeoutActivitySid).add("prioritizeQueueOrder", (Object)this.prioritizeQueueOrder).add("url", this.url).add("links", this.links).toString();
    }

    public static enum QueueOrder {
        FIFO("FIFO"),
        LIFO("LIFO");

        private final String value;

        private QueueOrder(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static QueueOrder forValue(String value) {
            return (QueueOrder)Promoter.enumFromString((String)value, (Enum[])QueueOrder.values());
        }
    }
}

