/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service.session;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.proxy.v1.service.session.ParticipantCreator;
import com.twilio.rest.proxy.v1.service.session.ParticipantDeleter;
import com.twilio.rest.proxy.v1.service.session.ParticipantFetcher;
import com.twilio.rest.proxy.v1.service.session.ParticipantReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Participant
extends Resource {
    private static final long serialVersionUID = 233073623535354L;
    private final String sid;
    private final String sessionSid;
    private final String serviceSid;
    private final String accountSid;
    private final String friendlyName;
    private final String identifier;
    private final String proxyIdentifier;
    private final String proxyIdentifierSid;
    private final DateTime dateDeleted;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static ParticipantFetcher fetcher(String pathServiceSid, String pathSessionSid, String pathSid) {
        return new ParticipantFetcher(pathServiceSid, pathSessionSid, pathSid);
    }

    public static ParticipantReader reader(String pathServiceSid, String pathSessionSid) {
        return new ParticipantReader(pathServiceSid, pathSessionSid);
    }

    public static ParticipantCreator creator(String pathServiceSid, String pathSessionSid, String identifier) {
        return new ParticipantCreator(pathServiceSid, pathSessionSid, identifier);
    }

    public static ParticipantDeleter deleter(String pathServiceSid, String pathSessionSid, String pathSid) {
        return new ParticipantDeleter(pathServiceSid, pathSessionSid, pathSid);
    }

    public static Participant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Participant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Participant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Participant(@JsonProperty(value="sid") String sid, @JsonProperty(value="session_sid") String sessionSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="identifier") String identifier, @JsonProperty(value="proxy_identifier") String proxyIdentifier, @JsonProperty(value="proxy_identifier_sid") String proxyIdentifierSid, @JsonProperty(value="date_deleted") String dateDeleted, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.sessionSid = sessionSid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.identifier = identifier;
        this.proxyIdentifier = proxyIdentifier;
        this.proxyIdentifierSid = proxyIdentifierSid;
        this.dateDeleted = DateConverter.iso8601DateTimeFromString(dateDeleted);
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getSessionSid() {
        return this.sessionSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public final String getProxyIdentifier() {
        return this.proxyIdentifier;
    }

    public final String getProxyIdentifierSid() {
        return this.proxyIdentifierSid;
    }

    public final DateTime getDateDeleted() {
        return this.dateDeleted;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Participant other = (Participant)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.sessionSid, other.sessionSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.proxyIdentifier, other.proxyIdentifier) && Objects.equals(this.proxyIdentifierSid, other.proxyIdentifierSid) && Objects.equals(this.dateDeleted, other.dateDeleted) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.sessionSid, this.serviceSid, this.accountSid, this.friendlyName, this.identifier, this.proxyIdentifier, this.proxyIdentifierSid, this.dateDeleted, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("sessionSid", this.sessionSid).add("serviceSid", this.serviceSid).add("accountSid", this.accountSid).add("friendlyName", this.friendlyName).add("identifier", this.identifier).add("proxyIdentifier", this.proxyIdentifier).add("proxyIdentifierSid", this.proxyIdentifierSid).add("dateDeleted", this.dateDeleted).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("url", this.url).add("links", this.links).toString();
    }
}

