/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.serializer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.RDDBlockId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.apache.spark.util.io.ChunkedByteBufferOutputStream;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c!B\u0001\u0003\u0001\u0011Q!!E*fe&\fG.\u001b>fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\u0005\u0001Y\u0001C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0003\u0005\u0013\u0001\t\u0005\t\u0015!\u0003\u0015\u0003E!WMZ1vYR\u001cVM]5bY&TXM]\u0002\u0001!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0006TKJL\u0017\r\\5{KJD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0005G>tg\r\u0005\u0002\u001c95\tA!\u0003\u0002\u001e\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005iQM\\2ssB$\u0018n\u001c8LKf\u00042\u0001D\u0011$\u0013\t\u0011SB\u0001\u0004PaRLwN\u001c\t\u0004\u0019\u00112\u0013BA\u0013\u000e\u0005\u0015\t%O]1z!\taq%\u0003\u0002)\u001b\t!!)\u001f;f\u0011\u0015Q\u0003\u0001\"\u0001,\u0003\u0019a\u0014N\\5u}Q!A&\f\u00180!\t)\u0002\u0001C\u0003\u0013S\u0001\u0007A\u0003C\u0003\u001aS\u0001\u0007!\u0004C\u0003 S\u0001\u0007\u0001\u0005C\u0003+\u0001\u0011\u0005\u0011\u0007F\u0002-eMBQA\u0005\u0019A\u0002QAQ!\u0007\u0019A\u0002iAa!\u000e\u0001!\u0002\u00131\u0014AD6ss>\u001cVM]5bY&TXM\u001d\t\u0003+]J!\u0001\u000f\u0002\u0003\u001d-\u0013\u0018p\\*fe&\fG.\u001b>fe\")!\b\u0001C\u0001w\u0005)2/\u001a;EK\u001a\fW\u000f\u001c;DY\u0006\u001c8\u000fT8bI\u0016\u0014HC\u0001\u001f@!\taQ(\u0003\u0002?\u001b\t!QK\\5u\u0011\u0015\u0001\u0015\b1\u0001B\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015\u0001\u00027b]\u001eT\u0011AR\u0001\u0005U\u00064\u0018-\u0003\u0002I\u0007\nY1\t\\1tg2{\u0017\rZ3s\u0011\u0019Q\u0005\u0001)A\u0005\u0017\u0006q1\u000f\u001e:j]\u001e\u001cE.Y:t)\u0006<\u0007c\u0001'P#6\tQJ\u0003\u0002O\u001b\u00059!/\u001a4mK\u000e$\u0018B\u0001)N\u0005!\u0019E.Y:t)\u0006<\u0007C\u0001*Z\u001d\t\u0019v\u000b\u0005\u0002U\u001b5\tQK\u0003\u0002W'\u00051AH]8pizJ!\u0001W\u0007\u0002\rA\u0013X\rZ3g\u0013\tQ6L\u0001\u0004TiJLgn\u001a\u0006\u000316Aa!\u0018\u0001!\u0002\u0013q\u0016a\t9sS6LG/\u001b<f\u0003:$\u0007K]5nSRLg/Z!se\u0006L8\t\\1tgR\u000bwm\u001d\t\u0004%~\u000b\u0017B\u00011\\\u0005\r\u0019V\r\u001e\u0019\u0003E\u0016\u00042\u0001T(d!\t!W\r\u0004\u0001\u0005\u0013\u0019d\u0016\u0011!A\u0001\u0006\u00039'aA0%cE\u0011\u0001n\u001b\t\u0003\u0019%L!A[\u0007\u0003\u000f9{G\u000f[5oOB\u0011A\u0002\\\u0005\u0003[6\u00111!\u00118z\u0011\u0019y\u0007\u0001)A\u0005a\u0006\t2m\\7qe\u0016\u001c8O\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u00051\t\u0018B\u0001:\u000e\u0005\u001d\u0011un\u001c7fC:Da\u0001\u001e\u0001!\u0002\u0013\u0001\u0018aD2p[B\u0014Xm]:TQV4g\r\\3\t\rY\u0004\u0001\u0015!\u0003q\u00031\u0019w.\u001c9sKN\u001c(\u000b\u001a3t\u0011\u0019A\b\u0001)A\u0005a\u0006!2m\\7qe\u0016\u001c8o\u00155vM\u001adWm\u00159jY2D\u0001B\u001f\u0001\t\u0006\u0004%Ia_\u0001\u0011G>l\u0007O]3tg&|gnQ8eK\u000e,\u0012\u0001 \t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}$\u0011AA5p\u0013\r\t\u0019A \u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000eDq!a\u0002\u0001\t\u0003\tI!A\tf]\u000e\u0014\u0018\u0010\u001d;j_:,e.\u00192mK\u0012,\u0012\u0001\u001d\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003)\u0019\u0017M\\+tK.\u0013\u0018p\u001c\u000b\u0004a\u0006E\u0001\u0002CA\n\u0003\u0017\u0001\r!!\u0006\u0002\u0005\r$\b\u0007BA\f\u00037\u0001B\u0001T(\u0002\u001aA\u0019A-a\u0007\u0005\u0017\u0005u\u0011\u0011CA\u0001\u0002\u0003\u0015\ta\u001a\u0002\u0004?\u0012\u001a\u0004bBA\u0011\u0001\u0011\u0005\u00111E\u0001\u000eO\u0016$8+\u001a:jC2L'0\u001a:\u0015\u000bQ\t)#!\r\t\u0011\u0005M\u0011q\u0004a\u0001\u0003O\u0001D!!\u000b\u0002.A!AjTA\u0016!\r!\u0017Q\u0006\u0003\f\u0003_\t)#!A\u0001\u0002\u000b\u0005qMA\u0002`IQBq!a\r\u0002 \u0001\u0007\u0001/\u0001\u0005bkR|\u0007+[2l\u0011\u001d\t\t\u0003\u0001C\u0001\u0003o!R\u0001FA\u001d\u0003\u000fB\u0001\"a\u000f\u00026\u0001\u0007\u0011QH\u0001\fW\u0016L8\t\\1tgR\u000bw\r\r\u0003\u0002@\u0005\r\u0003\u0003\u0002'P\u0003\u0003\u00022\u0001ZA\"\t-\t)%!\u000f\u0002\u0002\u0003\u0005)\u0011A4\u0003\u0007}#S\u0007\u0003\u0005\u0002J\u0005U\u0002\u0019AA&\u000351\u0018\r\\;f\u00072\f7o\u001d+bOB\"\u0011QJA)!\u0011au*a\u0014\u0011\u0007\u0011\f\t\u0006B\u0006\u0002T\u0005\u001d\u0013\u0011!A\u0001\u0006\u00039'aA0%m!9\u0011q\u000b\u0001\u0005\n\u0005e\u0013AD:i_VdGmQ8naJ,7o\u001d\u000b\u0004a\u0006m\u0003\u0002CA/\u0003+\u0002\r!a\u0018\u0002\u000f\tdwnY6JIB!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f\u0011\tqa\u001d;pe\u0006<W-\u0003\u0003\u0002j\u0005\r$a\u0002\"m_\u000e\\\u0017\n\u001a\u0005\b\u0003[\u0002A\u0011AA8\u0003)9(/\u00199TiJ,\u0017-\u001c\u000b\u0007\u0003c\nY(! \u0011\t\u0005M\u0014qO\u0007\u0003\u0003kR!a`#\n\t\u0005e\u0014Q\u000f\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0005\u0002^\u0005-\u0004\u0019AA0\u0011!\ty(a\u001bA\u0002\u0005E\u0014!A:\t\u000f\u00055\u0004\u0001\"\u0001\u0002\u0004R1\u0011QQAF\u0003\u001b\u0003B!a\u001d\u0002\b&!\u0011\u0011RA;\u00051yU\u000f\u001e9viN#(/Z1n\u0011!\ti&!!A\u0002\u0005}\u0003\u0002CA@\u0003\u0003\u0003\r!!\"\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\u0006\trO]1q\r>\u0014XI\\2ssB$\u0018n\u001c8\u0015\t\u0005E\u0014Q\u0013\u0005\t\u0003\u007f\ny\t1\u0001\u0002r!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005eE\u0003BAC\u00037C\u0001\"a \u0002\u0018\u0002\u0007\u0011Q\u0011\u0005\b\u0003?\u0003A\u0011AAQ\u0003I9(/\u00199G_J\u001cu.\u001c9sKN\u001c\u0018n\u001c8\u0015\r\u0005\u0015\u00151UAS\u0011!\ti&!(A\u0002\u0005}\u0003\u0002CA@\u0003;\u0003\r!!\"\t\u000f\u0005}\u0005\u0001\"\u0001\u0002*R1\u0011\u0011OAV\u0003[C\u0001\"!\u0018\u0002(\u0002\u0007\u0011q\f\u0005\t\u0003\u007f\n9\u000b1\u0001\u0002r!9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0016a\u00053bi\u0006\u001cVM]5bY&TXm\u0015;sK\u0006lW\u0003BA[\u0003\u0003$\u0002\"a.\u0002F\u0006\u001d\u00171\u001a\u000b\u0004y\u0005e\u0006BCA^\u0003_\u000b\t\u0011q\u0001\u0002>\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\t1{\u0015q\u0018\t\u0004I\u0006\u0005GaBAb\u0003_\u0013\ra\u001a\u0002\u0002)\"A\u0011QLAX\u0001\u0004\ty\u0006\u0003\u0005\u0002J\u0006=\u0006\u0019AAC\u00031yW\u000f\u001e9viN#(/Z1n\u0011!\ti-a,A\u0002\u0005=\u0017A\u0002<bYV,7\u000f\u0005\u0004\u0002R\u0006m\u0017q\u0018\b\u0005\u0003'\f9ND\u0002U\u0003+L\u0011AD\u0005\u0004\u00033l\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003;\fyN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\r\tI.\u0004\u0005\b\u0003G\u0004A\u0011AAs\u00035!\u0017\r^1TKJL\u0017\r\\5{KV!\u0011q\u001dB\u0001)\u0019\tIOa\u0001\u0003\u0006Q!\u00111^A}!\u0011\ti/!>\u000e\u0005\u0005=(bA@\u0002r*\u0019\u00111\u001f\u0003\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003o\fyOA\tDQVt7.\u001a3CsR,')\u001e4gKJD!\"a?\u0002b\u0006\u0005\t9AA\u007f\u0003))g/\u001b3f]\u000e,GE\r\t\u0005\u0019>\u000by\u0010E\u0002e\u0005\u0003!q!a1\u0002b\n\u0007q\r\u0003\u0005\u0002^\u0005\u0005\b\u0019AA0\u0011!\ti-!9A\u0002\t\u001d\u0001CBAi\u00037\fy\u0010C\u0004\u0003\f\u0001!\tA!\u0004\u0002C\u0011\fG/Y*fe&\fG.\u001b>f/&$\b.\u0012=qY&\u001c\u0017\u000e^\"mCN\u001cH+Y4\u0015\u0011\u0005-(q\u0002B\t\u0005;A\u0001\"!\u0018\u0003\n\u0001\u0007\u0011q\f\u0005\t\u0003\u001b\u0014I\u00011\u0001\u0003\u0014A\"!Q\u0003B\r!\u0019\t\t.a7\u0003\u0018A\u0019AM!\u0007\u0005\u0017\tm!\u0011CA\u0001\u0002\u0003\u0015\ta\u001a\u0002\u0004?\u0012:\u0004\u0002\u0003B\u0010\u0005\u0013\u0001\rA!\t\u0002\u0011\rd\u0017m]:UC\u001e\u0004DAa\t\u0003(A!Aj\u0014B\u0013!\r!'q\u0005\u0003\f\u0005S\u0011i\"!A\u0001\u0002\u000b\u0005qMA\u0002`IaBqA!\f\u0001\t\u0003\u0011y#A\u000beCR\fG)Z:fe&\fG.\u001b>f'R\u0014X-Y7\u0016\t\tE\"\u0011\b\u000b\u0007\u0005g\u0011yD!\u0011\u0015\t\tU\"1\b\t\u0007\u0003#\fYNa\u000e\u0011\u0007\u0011\u0014I\u0004B\u0004\u0002D\n-\"\u0019A4\t\u0011\t}!1\u0006a\u0001\u0005{\u0001B\u0001T(\u00038!A\u0011Q\fB\u0016\u0001\u0004\ty\u0006\u0003\u0005\u0003D\t-\u0002\u0019AA9\u0003-Ig\u000e];u'R\u0014X-Y7")
public class SerializerManager {
    private CompressionCodec compressionCodec;
    private final Serializer defaultSerializer;
    private final SparkConf conf;
    private final Option<byte[]> encryptionKey;
    private final KryoSerializer kryoSerializer;
    private final ClassTag<String> stringClassTag;
    private final Set<ClassTag<?>> primitiveAndPrimitiveArrayClassTags;
    private final boolean compressBroadcast;
    private final boolean compressShuffle;
    private final boolean compressRdds;
    private final boolean compressShuffleSpill;
    private volatile boolean bitmap$0;

    public void setDefaultClassLoader(ClassLoader classLoader) {
        this.kryoSerializer.setDefaultClassLoader(classLoader);
    }

    private CompressionCodec compressionCodec$lzycompute() {
        SerializerManager serializerManager = this;
        synchronized (serializerManager) {
            if (!this.bitmap$0) {
                this.compressionCodec = CompressionCodec$.MODULE$.createCodec(this.conf);
                this.bitmap$0 = true;
            }
        }
        return this.compressionCodec;
    }

    private CompressionCodec compressionCodec() {
        return !this.bitmap$0 ? this.compressionCodec$lzycompute() : this.compressionCodec;
    }

    public boolean encryptionEnabled() {
        return this.encryptionKey.isDefined();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseKryo(ClassTag<?> ct) {
        if (this.primitiveAndPrimitiveArrayClassTags.contains(ct)) return true;
        ClassTag<?> classTag = ct;
        ClassTag<String> classTag2 = this.stringClassTag;
        if (classTag != null) {
            if (!classTag.equals(classTag2)) return false;
            return true;
        }
        if (classTag2 == null) return true;
        return false;
    }

    public Serializer getSerializer(ClassTag<?> ct, boolean autoPick) {
        return autoPick && this.canUseKryo(ct) ? this.kryoSerializer : this.defaultSerializer;
    }

    public Serializer getSerializer(ClassTag<?> keyClassTag, ClassTag<?> valueClassTag) {
        return this.canUseKryo(keyClassTag) && this.canUseKryo(valueClassTag) ? this.kryoSerializer : this.defaultSerializer;
    }

    private boolean shouldCompress(BlockId blockId) {
        BlockId blockId2 = blockId;
        boolean bl = blockId2 instanceof ShuffleBlockId ? this.compressShuffle : (blockId2 instanceof BroadcastBlockId ? this.compressBroadcast : (blockId2 instanceof RDDBlockId ? this.compressRdds : (blockId2 instanceof TempLocalBlockId ? this.compressShuffleSpill : (blockId2 instanceof TempShuffleBlockId ? this.compressShuffle : false))));
        return bl;
    }

    public InputStream wrapStream(BlockId blockId, InputStream s) {
        return this.wrapForCompression(blockId, this.wrapForEncryption(s));
    }

    public OutputStream wrapStream(BlockId blockId, OutputStream s) {
        return this.wrapForCompression(blockId, this.wrapForEncryption(s));
    }

    public InputStream wrapForEncryption(InputStream s) {
        return (InputStream)this.encryptionKey.map((Function1 & Serializable & scala.Serializable)key -> CryptoStreamUtils$.MODULE$.createCryptoInputStream(s, $this.conf, (byte[])key)).getOrElse((Function0 & Serializable & scala.Serializable)() -> s);
    }

    public OutputStream wrapForEncryption(OutputStream s) {
        return (OutputStream)this.encryptionKey.map((Function1 & Serializable & scala.Serializable)key -> CryptoStreamUtils$.MODULE$.createCryptoOutputStream(s, $this.conf, (byte[])key)).getOrElse((Function0 & Serializable & scala.Serializable)() -> s);
    }

    public OutputStream wrapForCompression(BlockId blockId, OutputStream s) {
        return this.shouldCompress(blockId) ? this.compressionCodec().compressedOutputStream(s) : s;
    }

    public InputStream wrapForCompression(BlockId blockId, InputStream s) {
        return this.shouldCompress(blockId) ? this.compressionCodec().compressedInputStream(s) : s;
    }

    public <T> void dataSerializeStream(BlockId blockId, OutputStream outputStream, Iterator<T> values, ClassTag<T> evidence$1) {
        BufferedOutputStream byteStream = new BufferedOutputStream(outputStream);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        SerializerInstance ser = this.getSerializer((ClassTag)Predef$.MODULE$.implicitly(evidence$1), autoPick).newInstance();
        ser.serializeStream(this.wrapForCompression(blockId, byteStream)).writeAll(values, evidence$1).close();
    }

    public <T> ChunkedByteBuffer dataSerialize(BlockId blockId, Iterator<T> values, ClassTag<T> evidence$2) {
        return this.dataSerializeWithExplicitClassTag(blockId, values, (ClassTag)Predef$.MODULE$.implicitly(evidence$2));
    }

    public ChunkedByteBuffer dataSerializeWithExplicitClassTag(BlockId blockId, Iterator<?> values, ClassTag<?> classTag) {
        ChunkedByteBufferOutputStream bbos = new ChunkedByteBufferOutputStream(0x400000, (Function1<Object, ByteBuffer>)(Function1 & Serializable & scala.Serializable)x$1 -> SerializerManager.$anonfun$dataSerializeWithExplicitClassTag$1(BoxesRunTime.unboxToInt((Object)x$1)));
        BufferedOutputStream byteStream = new BufferedOutputStream(bbos);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        SerializerInstance ser = this.getSerializer(classTag, autoPick).newInstance();
        ser.serializeStream(this.wrapForCompression(blockId, byteStream)).writeAll(values, ClassTag$.MODULE$.apply(Object.class)).close();
        return bbos.toChunkedByteBuffer();
    }

    public <T> Iterator<T> dataDeserializeStream(BlockId blockId, InputStream inputStream, ClassTag<T> classTag) {
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        boolean autoPick = !(blockId instanceof StreamBlockId);
        return this.getSerializer(classTag, autoPick).newInstance().deserializeStream(this.wrapForCompression(blockId, stream)).asIterator();
    }

    public static final /* synthetic */ ByteBuffer $anonfun$dataSerializeWithExplicitClassTag$1(int x$1) {
        return ByteBuffer.allocate(x$1);
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf, Option<byte[]> encryptionKey) {
        this.defaultSerializer = defaultSerializer;
        this.conf = conf;
        this.encryptionKey = encryptionKey;
        this.kryoSerializer = new KryoSerializer(conf);
        this.stringClassTag = (ClassTag)Predef$.MODULE$.implicitly((Object)ClassTag$.MODULE$.apply(String.class));
        Set primitiveClassTags = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClassTag[]{ClassTag$.MODULE$.Boolean(), ClassTag$.MODULE$.Byte(), ClassTag$.MODULE$.Char(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Float(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Null(), ClassTag$.MODULE$.Short()}));
        Set arrayClassTags = (Set)primitiveClassTags.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.wrap(), Set$.MODULE$.canBuildFrom());
        this.primitiveAndPrimitiveArrayClassTags = (Set)primitiveClassTags.$plus$plus((GenTraversableOnce)arrayClassTags);
        this.compressBroadcast = conf.getBoolean("spark.broadcast.compress", true);
        this.compressShuffle = conf.getBoolean("spark.shuffle.compress", true);
        this.compressRdds = conf.getBoolean("spark.rdd.compress", false);
        this.compressShuffleSpill = conf.getBoolean("spark.shuffle.spill.compress", true);
    }

    public SerializerManager(Serializer defaultSerializer, SparkConf conf) {
        this(defaultSerializer, conf, (Option<byte[]>)None$.MODULE$);
    }
}

