/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskState$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorKilled$;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.LossReasonPending$;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SlaveLost$;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.TaskDescription;
import org.apache.spark.scheduler.TaskDescription$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.scheduler.WorkerOffer;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RegisteredExecutor$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$RetrieveSparkAppConfig$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$ReviveOffers$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopDriver$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutor$;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages$StopExecutors$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$DriverEndpoint$;
import org.apache.spark.scheduler.cluster.ExecutorData;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.SerializableBuffer;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r}g!B\u0001\u0003\u0001\u0019a!!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0003\u000b\u0019\t\u0011b]2iK\u0012,H.\u001a:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cR\u0001A\u0007\u0014/m\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005a)\u00050Z2vi>\u0014\u0018\t\u001c7pG\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u00031ei\u0011\u0001B\u0005\u00035\u0011\u0011\u0001cU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0011\u0005qyR\"A\u000f\u000b\u0005y1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0001j\"a\u0002'pO\u001eLgn\u001a\u0005\t\u000b\u0001\u0011\t\u0011)A\u0005G\r\u0001\u0001C\u0001\r%\u0013\t)CAA\tUCN\\7k\u00195fIVdWM]%na2D\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001K\u0001\u0007eB\u001cWI\u001c<\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R!\u0001\f\u0004\u0002\u0007I\u00048-\u0003\u0002/W\t1!\u000b]2F]ZD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!K\u0001\beB\u001cWI\u001c<!\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q\u0019AGN\u001c\u0011\u0005U\u0002Q\"\u0001\u0002\t\u000b\u0015\t\u0004\u0019A\u0012\t\u000b\u001d\n\u0004\u0019A\u0015\t\u000fe\u0002!\u0019!C\tu\u0005qAo\u001c;bY\u000e{'/Z\"pk:$X#A\u001e\u0011\u0005q*U\"A\u001f\u000b\u0005yz\u0014AB1u_6L7M\u0003\u0002A\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\t\u001b\u0015\u0001B;uS2T\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G{\ti\u0011\t^8nS\u000eLe\u000e^3hKJDa\u0001\u0013\u0001!\u0002\u0013Y\u0014a\u0004;pi\u0006d7i\u001c:f\u0007>,h\u000e\u001e\u0011\t\u000f)\u0003!\u0019!C\tu\u0005ABo\u001c;bYJ+w-[:uKJ,G-\u0012=fGV$xN]:\t\r1\u0003\u0001\u0015!\u0003<\u0003e!x\u000e^1m%\u0016<\u0017n\u001d;fe\u0016$W\t_3dkR|'o\u001d\u0011\t\u000f9\u0003!\u0019!C\t\u001f\u0006!1m\u001c8g+\u0005\u0001\u0006C\u0001\u000bR\u0013\t\u0011fAA\u0005Ta\u0006\u00148nQ8oM\"1A\u000b\u0001Q\u0001\nA\u000bQaY8oM\u0002BqA\u0016\u0001C\u0002\u0013%q+A\tnCb\u0014\u0006oY'fgN\fw-Z*ju\u0016,\u0012\u0001\u0017\t\u0003\u001deK!AW\b\u0003\u0007%sG\u000f\u0003\u0004]\u0001\u0001\u0006I\u0001W\u0001\u0013[\u0006D(\u000b]2NKN\u001c\u0018mZ3TSj,\u0007\u0005C\u0004_\u0001\t\u0007I\u0011B0\u0002#\u0011,g-Y;mi\u0006\u001b8\u000eV5nK>,H/F\u0001a!\tQ\u0013-\u0003\u0002cW\tQ!\u000b]2US6,w.\u001e;\t\r\u0011\u0004\u0001\u0015!\u0003a\u0003I!WMZ1vYR\f5o\u001b+j[\u0016|W\u000f\u001e\u0011\t\u000f\u0019\u0004!\u0019!C\u0005O\u0006\u0019r,\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_V\t\u0001\u000e\u0005\u0002\u000fS&\u0011!n\u0004\u0002\u0007\t>,(\r\\3\t\r1\u0004\u0001\u0015!\u0003i\u0003QyV.\u001b8SK\u001eL7\u000f^3sK\u0012\u0014\u0016\r^5pA!9a\u000e\u0001b\u0001\n\u0013y\u0017AG7bqJ+w-[:uKJ,GmV1ji&tw\rV5nK6\u001bX#\u00019\u0011\u00059\t\u0018B\u0001:\u0010\u0005\u0011auN\\4\t\rQ\u0004\u0001\u0015!\u0003q\u0003mi\u0017\r\u001f*fO&\u001cH/\u001a:fI^\u000b\u0017\u000e^5oORKW.Z'tA!9a\u000f\u0001b\u0001\n\u0013y\u0017AC2sK\u0006$X\rV5nK\"1\u0001\u0010\u0001Q\u0001\nA\f1b\u0019:fCR,G+[7fA!9!\u0010\u0001b\u0001\n\u0013Y\u0018aD3yK\u000e,Ho\u001c:ECR\fW*\u00199\u0016\u0003q\u0004r!`A\u0003\u0003\u0013\ty\"D\u0001\u007f\u0015\ry\u0018\u0011A\u0001\b[V$\u0018M\u00197f\u0015\r\t\u0019aD\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0004}\n9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u0006\u00033qA!!\u0004\u0002\u0016A\u0019\u0011qB\b\u000e\u0005\u0005E!bAA\nE\u00051AH]8pizJ1!a\u0006\u0010\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011qC\b\u0011\u0007U\n\t#C\u0002\u0002$\t\u0011A\"\u0012=fGV$xN\u001d#bi\u0006Dq!a\n\u0001A\u0003%A0\u0001\tfq\u0016\u001cW\u000f^8s\t\u0006$\u0018-T1qA!A\u00111\u0006\u0001A\u0002\u0013%q+A\fsKF,Xm\u001d;fIR{G/\u00197Fq\u0016\u001cW\u000f^8sg\"I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011G\u0001\u001ce\u0016\fX/Z:uK\u0012$v\u000e^1m\u000bb,7-\u001e;peN|F%Z9\u0015\t\u0005M\u0012\u0011\b\t\u0004\u001d\u0005U\u0012bAA\u001c\u001f\t!QK\\5u\u0011%\tY$!\f\u0002\u0002\u0003\u0007\u0001,A\u0002yIEBq!a\u0010\u0001A\u0003&\u0001,\u0001\rsKF,Xm\u001d;fIR{G/\u00197Fq\u0016\u001cW\u000f^8sg\u0002B\u0003\"!\u0010\u0002D\u0005U\u0013q\u000b\t\u0005\u0003\u000b\n\t&\u0004\u0002\u0002H)\u0019\u0001)!\u0013\u000b\t\u0005-\u0013QJ\u0001\u000bC:tw\u000e^1uS>t'BAA(\u0003\u0015Q\u0017M^1y\u0013\u0011\t\u0019&a\u0012\u0003\u0013\u001d+\u0018M\u001d3fI\nK\u0018!\u0002<bYV,\u0017EAA-\u0003\t\u001au.\u0019:tK\u001e\u0013\u0018-\u001b8fIN\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$g\u0006\u001e5jg\"A\u0011Q\f\u0001A\u0002\u0013%q+A\nok6\u0004VM\u001c3j]\u001e,\u00050Z2vi>\u00148\u000fC\u0005\u0002b\u0001\u0001\r\u0011\"\u0003\u0002d\u00059b.^7QK:$\u0017N\\4Fq\u0016\u001cW\u000f^8sg~#S-\u001d\u000b\u0005\u0003g\t)\u0007C\u0005\u0002<\u0005}\u0013\u0011!a\u00011\"9\u0011\u0011\u000e\u0001!B\u0013A\u0016\u0001\u00068v[B+g\u000eZ5oO\u0016CXmY;u_J\u001c\b\u0005\u000b\u0005\u0002h\u0005\r\u0013QKA,\u0011%\ty\u0007\u0001b\u0001\n\u0013\t\t(A\u0006mSN$XM\\3s\u0005V\u001cXCAA:!\rA\u0012QO\u0005\u0004\u0003o\"!a\u0004'jm\u0016d\u0015n\u001d;f]\u0016\u0014()^:\t\u0011\u0005m\u0004\u0001)A\u0005\u0003g\nA\u0002\\5ti\u0016tWM\u001d\"vg\u0002B\u0011\"a \u0001\u0005\u0004%I!!!\u00021\u0015DXmY;u_J\u001c\b+\u001a8eS:<Gk\u001c*f[>4X-\u0006\u0002\u0002\u0004B9Q0!\u0002\u0002\n\u0005\u0015\u0005c\u0001\b\u0002\b&\u0019\u0011\u0011R\b\u0003\u000f\t{w\u000e\\3b]\"A\u0011Q\u0012\u0001!\u0002\u0013\t\u0019)A\rfq\u0016\u001cW\u000f^8sgB+g\u000eZ5oOR{'+Z7pm\u0016\u0004\u0003\u0006CAF\u0003\u0007\n)&a\u0016\t\u0013\u0005M\u0005\u00011A\u0005\u0012\u0005U\u0015\u0001\u00065pgR$v\u000eT8dC2$\u0016m]6D_VtG/\u0006\u0002\u0002\u0018B9\u00111BAM\u0003\u0013A\u0016\u0002BAN\u0003;\u00111!T1q\u0011%\ty\n\u0001a\u0001\n#\t\t+\u0001\ri_N$Hk\u001c'pG\u0006dG+Y:l\u0007>,h\u000e^0%KF$B!a\r\u0002$\"Q\u00111HAO\u0003\u0003\u0005\r!a&\t\u0011\u0005\u001d\u0006\u0001)Q\u0005\u0003/\u000bQ\u0003[8tiR{Gj\\2bYR\u000b7o[\"pk:$\b\u0005\u000b\u0005\u0002&\u0006\r\u0013QKA,\u0011!\ti\u000b\u0001a\u0001\n#9\u0016A\u00057pG\u0006d\u0017\u000e^=Bo\u0006\u0014X\rV1tWND\u0011\"!-\u0001\u0001\u0004%\t\"a-\u0002-1|7-\u00197jif\fu/\u0019:f)\u0006\u001c8n]0%KF$B!a\r\u00026\"I\u00111HAX\u0003\u0003\u0005\r\u0001\u0017\u0005\b\u0003s\u0003\u0001\u0015)\u0003Y\u0003MawnY1mSRL\u0018i^1sKR\u000b7o[:!Q!\t9,a\u0011\u0002V\u0005]\u0003\u0002CA`\u0001\u0001\u0007I\u0011C,\u00021\r,(O]3oi\u0016CXmY;u_JLEmQ8v]R,'\u000fC\u0005\u0002D\u0002\u0001\r\u0011\"\u0005\u0002F\u0006a2-\u001e:sK:$X\t_3dkR|'/\u00133D_VtG/\u001a:`I\u0015\fH\u0003BA\u001a\u0003\u000fD\u0011\"a\u000f\u0002B\u0006\u0005\t\u0019\u0001-\t\u000f\u0005-\u0007\u0001)Q\u00051\u0006I2-\u001e:sK:$X\t_3dkR|'/\u00133D_VtG/\u001a:!Q\u0011\tI-a4\u0011\u00079\t\t.C\u0002\u0002T>\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003/\u0004!\u0019!C\u0005\u00033\fAB]3wSZ,G\u000b\u001b:fC\u0012,\"!a7\u0011\t\u0005u\u0017q\\\u0007\u0002\u007f%\u0019\u0011\u0011] \u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u0005\u0002f\u0002\u0001\u000b\u0011BAn\u00035\u0011XM^5wKRC'/Z1eA\u00191\u0011\u0011\u001e\u0001\u0001\u0003W\u0014a\u0002\u0012:jm\u0016\u0014XI\u001c3q_&tGo\u0005\u0004\u0002h6\tio\u0007\t\u0004U\u0005=\u0018bAAyW\t)B\u000b\u001b:fC\u0012\u001c\u0016MZ3Sa\u000e,e\u000e\u001a9pS:$\b\"C\u0014\u0002h\n\u0015\r\u0011\"\u0011)\u0011%\u0001\u0014q\u001dB\u0001B\u0003%\u0011\u0006C\u0006\u0002z\u0006\u001d(\u0011!Q\u0001\n\u0005m\u0018aD:qCJ\\\u0007K]8qKJ$\u0018.Z:\u0011\r\u0005u(q\u0001B\u0007\u001d\u0011\tyPa\u0001\u000f\t\u0005=!\u0011A\u0005\u0002!%\u0019!QA\b\u0002\u000fA\f7m[1hK&!!\u0011\u0002B\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0005\u000by\u0001c\u0002\b\u0003\u0010\u0005%\u0011\u0011B\u0005\u0004\u0005#y!A\u0002+va2,'\u0007C\u00043\u0003O$\tA!\u0006\u0015\r\t]!1\u0004B\u000f!\u0011\u0011I\"a:\u000e\u0003\u0001Aaa\nB\n\u0001\u0004I\u0003\u0002CA}\u0005'\u0001\r!a?\t\u0015\t\u0005\u0012q\u001db\u0001\n#\u0011\u0019#\u0001\u000efq\u0016\u001cW\u000f^8sgB+g\u000eZ5oO2{7o\u001d*fCN|g.\u0006\u0002\u0003&A)QPa\n\u0002\n%\u0019!\u0011\u0006@\u0003\u000f!\u000b7\u000f[*fi\"I!QFAtA\u0003%!QE\u0001\u001cKb,7-\u001e;peN\u0004VM\u001c3j]\u001edun]:SK\u0006\u001cxN\u001c\u0011\t\u0015\tE\u0012q\u001db\u0001\n#\u0011\u0019$A\nbI\u0012\u0014Xm]:U_\u0016CXmY;u_JLE-\u0006\u0002\u00036A9Q0!\u0002\u00038\u0005%\u0001c\u0001\u0016\u0003:%\u0019!1H\u0016\u0003\u0015I\u00038-\u00113ee\u0016\u001c8\u000fC\u0005\u0003@\u0005\u001d\b\u0015!\u0003\u00036\u0005!\u0012\r\u001a3sKN\u001cHk\\#yK\u000e,Ho\u001c:JI\u0002B\u0001Ba\u0011\u0002h\u0012\u0005#QI\u0001\b_:\u001cF/\u0019:u)\t\t\u0019\u0004\u0003\u0005\u0003J\u0005\u001dH\u0011\tB&\u0003\u001d\u0011XmY3jm\u0016,\"A!\u0014\u0011\u000f9\u0011yEa\u0015\u00024%\u0019!\u0011K\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u00042A\u0004B+\u0013\r\u00119f\u0004\u0002\u0004\u0003:L\b\u0002\u0003B.\u0003O$\tE!\u0018\u0002\u001fI,7-Z5wK\u0006sGMU3qYf$BA!\u0014\u0003`!A!\u0011\rB-\u0001\u0004\u0011\u0019'A\u0004d_:$X\r\u001f;\u0011\u0007)\u0012)'C\u0002\u0003h-\u0012aB\u00159d\u0007\u0006dGnQ8oi\u0016DH\u000f\u0003\u0005\u0003l\u0005\u001dH\u0011\u0002B#\u0003)i\u0017m[3PM\u001a,'o\u001d\u0005\t\u0005_\n9\u000f\"\u0011\u0003r\u0005qqN\u001c#jg\u000e|gN\\3di\u0016$G\u0003BA\u001a\u0005gB\u0001B!\u001e\u0003n\u0001\u0007!qG\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\t\u0011\t-\u0014q\u001dC\u0005\u0005s\"B!a\r\u0003|!A!Q\u0010B<\u0001\u0004\tI!\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012D\u0001B!!\u0002h\u0012%!1Q\u0001\u0010Kb,7-\u001e;pe&\u001b\u0018\t\\5wKR!\u0011Q\u0011BC\u0011!\u0011iHa A\u0002\u0005%\u0001\u0002\u0003BE\u0003O$IAa#\u0002\u00171\fWO\\2i)\u0006\u001c8n\u001d\u000b\u0005\u0003g\u0011i\t\u0003\u0005\u0003\u0010\n\u001d\u0005\u0019\u0001BI\u0003\u0015!\u0018m]6t!\u0019\tiPa\u0002\u0003\u0014B1\u0011Q B\u0004\u0005+\u00032\u0001\u0007BL\u0013\r\u0011I\n\u0002\u0002\u0010)\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]\"A!QTAt\t\u0013\u0011y*\u0001\bsK6|g/Z#yK\u000e,Ho\u001c:\u0015\r\u0005M\"\u0011\u0015BR\u0011!\u0011iHa'A\u0002\u0005%\u0001\u0002\u0003BS\u00057\u0003\rAa*\u0002\rI,\u0017m]8o!\rA\"\u0011V\u0005\u0004\u0005W#!AE#yK\u000e,Ho\u001c:M_N\u001c(+Z1t_:D\u0001Ba,\u0002h\u0012%!\u0011W\u0001\re\u0016lwN^3X_J\\WM\u001d\u000b\t\u0003g\u0011\u0019La.\u0003<\"A!Q\u0017BW\u0001\u0004\tI!\u0001\u0005x_J\\WM]%e\u0011!\u0011IL!,A\u0002\u0005%\u0011\u0001\u00025pgRD\u0001B!0\u0003.\u0002\u0007\u0011\u0011B\u0001\b[\u0016\u001c8/Y4f\u0011!\u0011\t-a:\u0005\u0012\t\r\u0017a\u00043jg\u0006\u0014G.Z#yK\u000e,Ho\u001c:\u0015\t\u0005\u0015%Q\u0019\u0005\t\u0005{\u0012y\f1\u0001\u0002\n!I!\u0011\u001a\u0001A\u0002\u0013\u0005!1Z\u0001\u000fIJLg/\u001a:F]\u0012\u0004x.\u001b8u+\t\u0011i\rE\u0002+\u0005\u001fL1A!5,\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001aD\u0011B!6\u0001\u0001\u0004%\tAa6\u0002%\u0011\u0014\u0018N^3s\u000b:$\u0007o\\5oi~#S-\u001d\u000b\u0005\u0003g\u0011I\u000e\u0003\u0006\u0002<\tM\u0017\u0011!a\u0001\u0005\u001bD\u0001B!8\u0001A\u0003&!QZ\u0001\u0010IJLg/\u001a:F]\u0012\u0004x.\u001b8uA!1!\u0011\u001d\u0001\u0005\u0012\u001d\f!#\\5o%\u0016<\u0017n\u001d;fe\u0016$'+\u0019;j_\"9!Q\u001d\u0001\u0005B\t\u0015\u0013!B:uCJ$\bb\u0002Bu\u0001\u0011E!1^\u0001\u0018GJ,\u0017\r^3Ee&4XM]#oIB|\u0017N\u001c;SK\u001a$BA!4\u0003n\"A!q\u001eBt\u0001\u0004\u0011\t0\u0001\u0006qe>\u0004XM\u001d;jKN\u0004R! Bz\u0005\u001bI1A!>\u007f\u0005-\t%O]1z\u0005V4g-\u001a:\t\u000f\te\b\u0001\"\u0005\u0003|\u0006!2M]3bi\u0016$%/\u001b<fe\u0016sG\r]8j]R$BAa\u0006\u0003~\"A!q\u001eB|\u0001\u0004\tY\u0010C\u0004\u0004\u0002\u0001!\tA!\u0012\u0002\u001bM$x\u000e]#yK\u000e,Ho\u001c:t\u0011\u001d\u0019)\u0001\u0001C!\u0005\u000b\nAa\u001d;pa\"91\u0011\u0002\u0001\u0005\u0012\t\u0015\u0013!\u0002:fg\u0016$\bbBB\u0007\u0001\u0011\u0005#QI\u0001\re\u00164\u0018N^3PM\u001a,'o\u001d\u0005\b\u0007#\u0001A\u0011IB\n\u0003!Y\u0017\u000e\u001c7UCN\\GCCA\u001a\u0007+\u0019Iba\u0007\u0004 !91qCB\b\u0001\u0004\u0001\u0018A\u0002;bg.LE\r\u0003\u0005\u0003~\r=\u0001\u0019AA\u0005\u0011!\u0019iba\u0004A\u0002\u0005\u0015\u0015aD5oi\u0016\u0014(/\u001e9u)\"\u0014X-\u00193\t\u0011\t\u00156q\u0002a\u0001\u0003\u0013Aqaa\t\u0001\t\u0003\u001a)#\u0001\neK\u001a\fW\u000f\u001c;QCJ\fG\u000e\\3mSNlG#\u0001-\t\u000f\tu\u0005\u0001\"\u0005\u0004*Q1\u00111GB\u0016\u0007[A\u0001B! \u0004(\u0001\u0007\u0011\u0011\u0002\u0005\t\u0005K\u001b9\u00031\u0001\u0003(\"9!q\u0016\u0001\u0005\u0012\rEB\u0003CA\u001a\u0007g\u0019)da\u000e\t\u0011\tU6q\u0006a\u0001\u0003\u0013A\u0001B!/\u00040\u0001\u0007\u0011\u0011\u0002\u0005\t\u0005{\u001by\u00031\u0001\u0002\n!911\b\u0001\u0005\u0002\ru\u0012!H:vM\u001aL7-[3oiJ+7o\\;sG\u0016\u001c(+Z4jgR,'/\u001a3\u0015\u0005\u0005\u0015\u0005bBB!\u0001\u0011\u00053QH\u0001\bSN\u0014V-\u00193z\u0011\u0019\u0019)\u0005\u0001C\u0005/\u0006!b.^7Fq&\u001cH/\u001b8h\u000bb,7-\u001e;peNDqa!\u0013\u0001\t\u0003\u001aY%\u0001\bhKR,\u00050Z2vi>\u0014\u0018\nZ:\u0015\u0005\r5\u0003CBA\u007f\u0005\u000f\tI\u0001C\u0004\u0004R\u0001!\te!\n\u0002+5\f\u0007PT;n\u0007>t7-\u001e:sK:$H+Y:lg\"91Q\u000b\u0001\u0005F\r]\u0013\u0001\u0005:fcV,7\u000f^#yK\u000e,Ho\u001c:t)\u0011\t)i!\u0017\t\u000f\rm31\u000ba\u00011\u00061b.^7BI\u0012LG/[8oC2,\u00050Z2vi>\u00148\u000fC\u0004\u0004`\u0001!)e!\u0019\u0002+I,\u0017/^3tiR{G/\u00197Fq\u0016\u001cW\u000f^8sgRA\u0011QQB2\u0007O\u001aI\u0007C\u0004\u0004f\ru\u0003\u0019\u0001-\u0002\u00199,X.\u0012=fGV$xN]:\t\u000f\u000556Q\fa\u00011\"A\u00111SB/\u0001\u0004\t9\nC\u0004\u0004n\u0001!\tba\u001c\u0002/\u0011|'+Z9vKN$Hk\u001c;bY\u0016CXmY;u_J\u001cH\u0003BB9\u0007w\u0002baa\u001d\u0004x\u0005\u0015UBAB;\u0015\t\u0001u\"\u0003\u0003\u0004z\rU$A\u0002$viV\u0014X\rC\u0004\u0004~\r-\u0004\u0019\u0001-\u0002\u001dI,\u0017/^3ti\u0016$Gk\u001c;bY\"91\u0011\u0011\u0001\u0005F\r\r\u0015!D6jY2,\u00050Z2vi>\u00148\u000f\u0006\u0006\u0004N\r\u00155\u0011RBG\u0007#C\u0001ba\"\u0004\u0000\u0001\u00071QJ\u0001\fKb,7-\u001e;pe&#7\u000f\u0003\u0005\u0004\f\u000e}\u0004\u0019AAC\u0003a\tGM[;tiR\u000b'oZ3u\u001dVlW\t_3dkR|'o\u001d\u0005\t\u0007\u001f\u001by\b1\u0001\u0002\u0006\u0006i1m\\;oi\u001a\u000b\u0017\u000e\\;sKND!ba%\u0004\u0000A\u0005\t\u0019AAC\u0003\u00151wN]2f\u0011\u001d\u00199\n\u0001C\t\u00073\u000bq\u0002Z8LS2dW\t_3dkR|'o\u001d\u000b\u0005\u0007c\u001aY\n\u0003\u0005\u0004\b\u000eU\u0005\u0019AB'\u0011\u001d\u0019y\n\u0001C#\u0007C\u000b1c[5mY\u0016CXmY;u_J\u001cxJ\u001c%pgR$B!!\"\u0004$\"A!\u0011XBO\u0001\u0004\tI\u0001C\u0004\u0004(\u0002!\tb!+\u00027\u0019,Go\u00195IC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8t)\t\u0019Y\u000bE\u0003\u000f\u0007[\u001b\t,C\u0002\u00040>\u0011aa\u00149uS>t\u0007#\u0002\b\u00044\u000e]\u0016bAB[\u001f\t)\u0011I\u001d:bsB\u0019ab!/\n\u0007\rmvB\u0001\u0003CsR,w\u0001CB`\u0005!\u0005aa!1\u0002;\r{\u0017M]:f\u000fJ\f\u0017N\\3e'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012\u00042!NBb\r\u001d\t!\u0001#\u0001\u0007\u0007\u000b\u001c2aa1\u000e\u0011\u001d\u001141\u0019C\u0001\u0007\u0013$\"a!1\t\u0015\r571\u0019b\u0001\n\u0003\u0019y-A\u0007F\u001d\u0012\u0003v*\u0013(U?:\u000bU*R\u000b\u0003\u0007#\u0004Baa5\u0004Z6\u00111Q\u001b\u0006\u0004\u0007/\u001c\u0015\u0001\u00027b]\u001eLA!a\u0007\u0004V\"I1Q\\BbA\u0003%1\u0011[\u0001\u000f\u000b:#\u0005kT%O)~s\u0015)T#!\u0001")
public class CoarseGrainedSchedulerBackend
implements ExecutorAllocationClient,
SchedulerBackend,
Logging {
    public final TaskSchedulerImpl org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler;
    private final RpcEnv rpcEnv;
    private final AtomicInteger totalCoreCount;
    private final AtomicInteger totalRegisteredExecutors;
    private final SparkConf conf;
    private final int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize;
    private final RpcTimeout defaultAskTimeout;
    private final double _minRegisteredRatio;
    private final long maxRegisteredWaitingTimeMs;
    private final long createTime;
    private final HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private int requestedTotalExecutors;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    private final LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private final HashMap<String, Object> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private scala.collection.immutable.Map<String, Object> hostToLocalTaskCount;
    @GuardedBy(value="CoarseGrainedSchedulerBackend.this")
    private int localityAwareTasks;
    private volatile int currentExecutorIdCounter;
    private final ScheduledExecutorService org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$reviveThread;
    private RpcEndpointRef driverEndpoint;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private final String org$apache$spark$scheduler$SchedulerBackend$$appId;

    public static String ENDPOINT_NAME() {
        return CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public String applicationId() {
        return SchedulerBackend.applicationId$(this);
    }

    @Override
    public Option<String> applicationAttemptId() {
        return SchedulerBackend.applicationAttemptId$(this);
    }

    @Override
    public Option<scala.collection.immutable.Map<String, String>> getDriverLogUrls() {
        return SchedulerBackend.getDriverLogUrls$(this);
    }

    @Override
    public boolean killExecutor(String executorId) {
        return ExecutorAllocationClient.killExecutor$(this, executorId);
    }

    @Override
    public boolean killExecutors$default$4() {
        return ExecutorAllocationClient.killExecutors$default$4$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String org$apache$spark$scheduler$SchedulerBackend$$appId() {
        return this.org$apache$spark$scheduler$SchedulerBackend$$appId;
    }

    @Override
    public final void org$apache$spark$scheduler$SchedulerBackend$_setter_$org$apache$spark$scheduler$SchedulerBackend$$appId_$eq(String x$1) {
        this.org$apache$spark$scheduler$SchedulerBackend$$appId = x$1;
    }

    public RpcEnv rpcEnv() {
        return this.rpcEnv;
    }

    public AtomicInteger totalCoreCount() {
        return this.totalCoreCount;
    }

    public AtomicInteger totalRegisteredExecutors() {
        return this.totalRegisteredExecutors;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize;
    }

    private RpcTimeout defaultAskTimeout() {
        return this.defaultAskTimeout;
    }

    private double _minRegisteredRatio() {
        return this._minRegisteredRatio;
    }

    private long maxRegisteredWaitingTimeMs() {
        return this.maxRegisteredWaitingTimeMs;
    }

    private long createTime() {
        return this.createTime;
    }

    public HashMap<String, ExecutorData> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap;
    }

    private int requestedTotalExecutors() {
        return this.requestedTotalExecutors;
    }

    private void requestedTotalExecutors_$eq(int x$1) {
        this.requestedTotalExecutors = x$1;
    }

    public int org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors;
    }

    public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(int x$1) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = x$1;
    }

    public LiveListenerBus org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus;
    }

    public HashMap<String, Object> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove;
    }

    public scala.collection.immutable.Map<String, Object> hostToLocalTaskCount() {
        return this.hostToLocalTaskCount;
    }

    public void hostToLocalTaskCount_$eq(scala.collection.immutable.Map<String, Object> x$1) {
        this.hostToLocalTaskCount = x$1;
    }

    public int localityAwareTasks() {
        return this.localityAwareTasks;
    }

    public void localityAwareTasks_$eq(int x$1) {
        this.localityAwareTasks = x$1;
    }

    public int currentExecutorIdCounter() {
        return this.currentExecutorIdCounter;
    }

    public void currentExecutorIdCounter_$eq(int x$1) {
        this.currentExecutorIdCounter = x$1;
    }

    public ScheduledExecutorService org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$reviveThread() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$reviveThread;
    }

    public RpcEndpointRef driverEndpoint() {
        return this.driverEndpoint;
    }

    public void driverEndpoint_$eq(RpcEndpointRef x$1) {
        this.driverEndpoint = x$1;
    }

    public double minRegisteredRatio() {
        return this._minRegisteredRatio();
    }

    @Override
    public void start() {
        ArrayBuffer properties = new ArrayBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.sc().conf().getAll())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)CoarseGrainedSchedulerBackend.$anonfun$start$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            BoxedUnit boxedUnit = key.startsWith("spark.") ? properties.$plus$eq((Object)new Tuple2((Object)key, (Object)value)) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        this.driverEndpoint_$eq(this.createDriverEndpointRef((ArrayBuffer<Tuple2<String, String>>)properties));
    }

    public RpcEndpointRef createDriverEndpointRef(ArrayBuffer<Tuple2<String, String>> properties) {
        return this.rpcEnv().setupEndpoint(CoarseGrainedSchedulerBackend$.MODULE$.ENDPOINT_NAME(), this.createDriverEndpoint((Seq<Tuple2<String, String>>)properties));
    }

    public DriverEndpoint createDriverEndpoint(Seq<Tuple2<String, String>> properties) {
        return new DriverEndpoint(this, this.rpcEnv(), properties);
    }

    public void stopExecutors() {
        try {
            if (this.driverEndpoint() != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down all executors");
                this.driverEndpoint().askSync(CoarseGrainedClusterMessages$StopExecutors$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
        }
        catch (Exception e) {
            throw new SparkException("Error asking standalone scheduler to shut down executors", e);
        }
    }

    @Override
    public void stop() {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$reviveThread().shutdownNow();
        this.stopExecutors();
        try {
            if (this.driverEndpoint() != null) {
                this.driverEndpoint().askSync(CoarseGrainedClusterMessages$StopDriver$.MODULE$, ClassTag$.MODULE$.Boolean());
            }
        }
        catch (Exception e) {
            throw new SparkException("Error stopping standalone scheduler's driver endpoint", e);
        }
    }

    public void reset() {
        Set set;
        CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this;
        synchronized (coarseGrainedSchedulerBackend) {
            this.requestedTotalExecutors_$eq(0);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(0);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().clear();
            set = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().keys().toSet();
        }
        Set executors = set;
        executors.foreach((Function1 & Serializable & scala.Serializable)eid -> {
            this.removeExecutor(eid, new SlaveLost("Stale executor after cluster manager re-registered.", SlaveLost$.MODULE$.apply$default$2()));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void reviveOffers() {
        this.driverEndpoint().send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
    }

    @Override
    public void killTask(long taskId, String executorId, boolean interruptThread, String reason) {
        this.driverEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread, reason));
    }

    @Override
    public int defaultParallelism() {
        return this.conf().getInt("spark.default.parallelism", package$.MODULE$.max(this.totalCoreCount().get(), 2));
    }

    public void removeExecutor(String executorId, ExecutorLossReason reason) {
        this.driverEndpoint().send(new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason));
    }

    public void removeWorker(String workerId, String host, String message) {
        this.driverEndpoint().ask(new CoarseGrainedClusterMessages.RemoveWorker(workerId, host, message), ClassTag$.MODULE$.Boolean()).failed().foreach((Function1 & Serializable & scala.Serializable)t -> {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> t.getMessage(), t);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
    }

    public boolean sufficientResourcesRegistered() {
        return true;
    }

    @Override
    public boolean isReady() {
        if (this.sufficientResourcesRegistered()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("SchedulerBackend is ready for scheduling beginning after ").append(new StringBuilder(37).append("reached minRegisteredResourcesRatio: ").append(this.minRegisteredRatio()).toString()).toString());
            return true;
        }
        if (System.currentTimeMillis() - this.createTime() >= this.maxRegisteredWaitingTimeMs()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("SchedulerBackend is ready for scheduling beginning after waiting ").append(new StringBuilder(39).append("maxRegisteredResourcesWaitingTime: ").append(this.maxRegisteredWaitingTimeMs()).append("(ms)").toString()).toString());
            return true;
        }
        return false;
    }

    private int numExistingExecutors() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().size();
    }

    @Override
    public Seq<String> getExecutorIds() {
        return this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().keySet().toSeq();
    }

    @Override
    public int maxNumConcurrentTasks() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().values().map((Function1 & Serializable & scala.Serializable)executor -> BoxesRunTime.boxToInteger((int)CoarseGrainedSchedulerBackend.$anonfun$maxNumConcurrentTasks$1(this, executor)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    @Override
    public final boolean requestExecutors(int numAdditionalExecutors) {
        Future<Object> future;
        if (numAdditionalExecutors < 0) {
            throw new IllegalArgumentException(new StringBuilder(65).append("Attempted to request a negative number of additional executor(s) ").append(new StringBuilder(60).append(numAdditionalExecutors).append(" from the cluster manager. Please specify a positive number!").toString()).toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Requesting ").append(numAdditionalExecutors).append(" additional executor(s) from the cluster manager").toString());
        CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this;
        synchronized (coarseGrainedSchedulerBackend) {
            this.requestedTotalExecutors_$eq(this.requestedTotalExecutors() + numAdditionalExecutors);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + numAdditionalExecutors);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Number of pending executors is now ").append(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors()).toString());
            if (this.requestedTotalExecutors() != this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size()) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(219).append("requestExecutors(").append(numAdditionalExecutors).append("): Executor request doesn't match:\n             |requestedTotalExecutors  = ").append(this.requestedTotalExecutors()).append("\n             |numExistingExecutors     = ").append(this.numExistingExecutors()).append("\n             |numPendingExecutors      = ").append(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors()).append("\n             |executorsPendingToRemove = ").append(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size()).toString())).stripMargin());
            }
            future = this.doRequestTotalExecutors(this.requestedTotalExecutors());
        }
        Future<Object> response = future;
        return BoxesRunTime.unboxToBoolean((Object)this.defaultAskTimeout().awaitResult(response));
    }

    @Override
    public final boolean requestTotalExecutors(int numExecutors, int localityAwareTasks, scala.collection.immutable.Map<String, Object> hostToLocalTaskCount) {
        Future<Object> future;
        if (numExecutors < 0) {
            throw new IllegalArgumentException(new StringBuilder(54).append("Attempted to request a negative number of executor(s) ").append(new StringBuilder(60).append(numExecutors).append(" from the cluster manager. Please specify a positive number!").toString()).toString());
        }
        CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this;
        synchronized (coarseGrainedSchedulerBackend) {
            this.requestedTotalExecutors_$eq(numExecutors);
            this.localityAwareTasks_$eq(localityAwareTasks);
            this.hostToLocalTaskCount_$eq(hostToLocalTaskCount);
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(package$.MODULE$.max(numExecutors - this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size(), 0));
            future = this.doRequestTotalExecutors(numExecutors);
        }
        Future<Object> response = future;
        return BoxesRunTime.unboxToBoolean((Object)this.defaultAskTimeout().awaitResult(response));
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public final Seq<String> killExecutors(Seq<String> executorIds, boolean adjustTargetNumExecutors, boolean countFailures, boolean force) {
        Future future;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Requesting to kill executor(s) ").append(executorIds.mkString(", ")).toString());
        CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this;
        synchronized (coarseGrainedSchedulerBackend) {
            Future<Object> future2;
            Tuple2 tuple2 = executorIds.partition((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)CoarseGrainedSchedulerBackend.$anonfun$killExecutors$2(this, key)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq knownExecutors = (Seq)tuple2._1();
            Seq unknownExecutors = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)knownExecutors, (Object)unknownExecutors);
            Tuple2 tuple23 = tuple22;
            Seq knownExecutors2 = (Seq)tuple23._1();
            Seq unknownExecutors2 = (Seq)tuple23._2();
            unknownExecutors2.foreach((Function1 & Serializable & scala.Serializable)id -> {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Executor to kill ").append(id).append(" does not exist!").toString());
                return BoxedUnit.UNIT;
            });
            Seq executorsToKill = (Seq)((TraversableLike)knownExecutors2.filter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)CoarseGrainedSchedulerBackend.$anonfun$killExecutors$5(this, id)))).filter((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)CoarseGrainedSchedulerBackend.$anonfun$killExecutors$6(this, force, id)));
            executorsToKill.foreach((Function1 & Serializable & scala.Serializable)id -> {
                CoarseGrainedSchedulerBackend.$anonfun$killExecutors$7(this, countFailures, id);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Actual list of executor(s) to be killed is ").append(executorsToKill.mkString(", ")).toString());
            if (adjustTargetNumExecutors) {
                this.requestedTotalExecutors_$eq(package$.MODULE$.max(this.requestedTotalExecutors() - executorsToKill.size(), 0));
                if (this.requestedTotalExecutors() != this.numExistingExecutors() + this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size()) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(254).append("killExecutors(").append(executorIds).append(", ").append(adjustTargetNumExecutors).append(", ").append(countFailures).append(", ").append(force).append("):\n                 |Executor counts do not match:\n                 |requestedTotalExecutors  = ").append(this.requestedTotalExecutors()).append("\n                 |numExistingExecutors     = ").append(this.numExistingExecutors()).append("\n                 |numPendingExecutors      = ").append(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors()).append("\n                 |executorsPendingToRemove = ").append(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().size()).toString())).stripMargin());
                }
                future2 = this.doRequestTotalExecutors(this.requestedTotalExecutors());
            } else {
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() + executorsToKill.size());
                future2 = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            Future<Object> adjustTotalExecutors = future2;
            Function1 & Serializable & scala.Serializable killExecutors = !executorsToKill.isEmpty() ? (Function1 & Serializable & scala.Serializable)x$7 -> this.doKillExecutors((Seq<String>)executorsToKill) : (Function1 & Serializable & scala.Serializable)x$8 -> Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Future killResponse = adjustTotalExecutors.flatMap((Function1)killExecutors, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            future = killResponse.flatMap((Function1 & Serializable & scala.Serializable)killSuccessful -> Future$.MODULE$.successful(BoxesRunTime.unboxToBoolean((Object)killSuccessful) ? executorsToKill : Seq$.MODULE$.empty()), (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
        }
        Future response = future;
        return (Seq)this.defaultAskTimeout().awaitResult(response);
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public final boolean killExecutorsOnHost(String host) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Requesting to kill any and all executors on host ").append(host).toString());
        this.driverEndpoint().send(new CoarseGrainedClusterMessages.KillExecutorsOnHost(host));
        return true;
    }

    public Option<byte[]> fetchHadoopDelegationTokens() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$start$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$maxNumConcurrentTasks$1(CoarseGrainedSchedulerBackend $this, ExecutorData executor) {
        return executor.totalCores() / $this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK();
    }

    public static final /* synthetic */ boolean $anonfun$killExecutors$2(CoarseGrainedSchedulerBackend $this, String key) {
        return $this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().contains((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$killExecutors$5(CoarseGrainedSchedulerBackend $this, String id) {
        return !$this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)id);
    }

    public static final /* synthetic */ boolean $anonfun$killExecutors$6(CoarseGrainedSchedulerBackend $this, boolean force$1, String id) {
        return force$1 || !$this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.isExecutorBusy(id);
    }

    public static final /* synthetic */ void $anonfun$killExecutors$7(CoarseGrainedSchedulerBackend $this, boolean countFailures$1, String id) {
        $this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().update((Object)id, (Object)BoxesRunTime.boxToBoolean((!countFailures$1 ? 1 : 0) != 0));
    }

    public CoarseGrainedSchedulerBackend(TaskSchedulerImpl scheduler, RpcEnv rpcEnv) {
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler = scheduler;
        this.rpcEnv = rpcEnv;
        ExecutorAllocationClient.$init$(this);
        SchedulerBackend.$init$(this);
        Logging.$init$(this);
        this.totalCoreCount = new AtomicInteger(0);
        this.totalRegisteredExecutors = new AtomicInteger(0);
        this.conf = scheduler.sc().conf();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize = RpcUtils$.MODULE$.maxMessageSizeBytes(this.conf());
        this.defaultAskTimeout = RpcUtils$.MODULE$.askRpcTimeout(this.conf());
        this._minRegisteredRatio = package$.MODULE$.min(1.0, this.conf().getDouble("spark.scheduler.minRegisteredResourcesRatio", 0.0));
        this.maxRegisteredWaitingTimeMs = this.conf().getTimeAsMs("spark.scheduler.maxRegisteredResourcesWaitingTime", "30s");
        this.createTime = System.currentTimeMillis();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap = new HashMap();
        this.requestedTotalExecutors = 0;
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors = 0;
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus = scheduler.sc().listenerBus();
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove = new HashMap();
        this.hostToLocalTaskCount = Predef$.MODULE$.Map().empty();
        this.localityAwareTasks = 0;
        this.currentExecutorIdCounter = 0;
        this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$reviveThread = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("driver-revive-thread");
        this.driverEndpoint = null;
    }

    public class DriverEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        public final Seq<Tuple2<String, String>> org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties;
        private final HashSet<String> executorsPendingLossReason;
        private final HashMap<RpcAddress, String> addressToExecutorId;
        private transient Logger org$apache$spark$internal$Logging$$log_;
        public final /* synthetic */ CoarseGrainedSchedulerBackend $outer;

        @Override
        public String logName() {
            return Logging.logName$(this);
        }

        @Override
        public Logger log() {
            return Logging.log$(this);
        }

        @Override
        public void logInfo(Function0<String> msg) {
            Logging.logInfo$(this, msg);
        }

        @Override
        public void logDebug(Function0<String> msg) {
            Logging.logDebug$(this, msg);
        }

        @Override
        public void logTrace(Function0<String> msg) {
            Logging.logTrace$(this, msg);
        }

        @Override
        public void logWarning(Function0<String> msg) {
            Logging.logWarning$(this, msg);
        }

        @Override
        public void logError(Function0<String> msg) {
            Logging.logError$(this, msg);
        }

        @Override
        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$(this, msg, throwable);
        }

        @Override
        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$(this, msg, throwable);
        }

        @Override
        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$(this, msg, throwable);
        }

        @Override
        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$(this, msg, throwable);
        }

        @Override
        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$(this, msg, throwable);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$(this, isInterpreter);
        }

        @Override
        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
        }

        @Override
        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$(this);
        }

        @Override
        public final RpcEndpointRef self() {
            return RpcEndpoint.self$(this);
        }

        @Override
        public void onError(Throwable cause) {
            RpcEndpoint.onError$(this, cause);
        }

        @Override
        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.onConnected$(this, remoteAddress);
        }

        @Override
        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.onNetworkError$(this, cause, remoteAddress);
        }

        @Override
        public void onStop() {
            RpcEndpoint.onStop$(this);
        }

        @Override
        public final void stop() {
            RpcEndpoint.stop$(this);
        }

        @Override
        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        @Override
        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        @Override
        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public HashSet<String> executorsPendingLossReason() {
            return this.executorsPendingLossReason;
        }

        public HashMap<RpcAddress, String> addressToExecutorId() {
            return this.addressToExecutorId;
        }

        @Override
        public void onStart() {
            long reviveIntervalMs = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().conf().getTimeAsMs("spark.scheduler.revive.interval", "1s");
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$reviveThread().scheduleAtFixedRate(new Runnable(this){
                private final /* synthetic */ DriverEndpoint $outer;

                public void run() {
                    Utils$.MODULE$.tryLogNonFatalError((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)$this.$outer.self()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                        DriverEndpoint$$anon$1.$anonfun$run$2(x$1);
                        return BoxedUnit.UNIT;
                    }));
                }

                public static final /* synthetic */ void $anonfun$run$2(RpcEndpointRef x$1) {
                    x$1.send(CoarseGrainedClusterMessages$ReviveOffers$.MODULE$);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$DriverEndpoint$$anon$1 ), $anonfun$run$2$adapted(org.apache.spark.rpc.RpcEndpointRef )}, serializedLambda);
                }
            }, 0L, reviveIntervalMs, TimeUnit.MILLISECONDS);
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receive() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.StatusUpdate) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.StatusUpdate statusUpdate = (CoarseGrainedClusterMessages.StatusUpdate)A1;
                        String executorId = statusUpdate.executorId();
                        long taskId = statusUpdate.taskId();
                        Enumeration.Value state = statusUpdate.state();
                        SerializableBuffer data = statusUpdate.data();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.statusUpdate(taskId, state, data.value());
                        if (TaskState$.MODULE$.isFinished(state)) {
                            Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                ExecutorData executorInfo = (ExecutorData)some.value();
                                executorInfo.freeCores_$eq(executorInfo.freeCores() + this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(executorId);
                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            } else if (None$.MODULE$.equals(option)) {
                                this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Ignored task status update (").append(taskId).append(" state ").append(state).append(") ").append(new StringBuilder(30).append("from unknown executor with ID ").append(executorId).toString()).toString());
                                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                throw new MatchError((Object)option);
                            }
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else if (CoarseGrainedClusterMessages$ReviveOffers$.MODULE$.equals(A1)) {
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.KillTask) {
                        CoarseGrainedClusterMessages.KillTask killTask = (CoarseGrainedClusterMessages.KillTask)A1;
                        long taskId = killTask.taskId();
                        String executorId = killTask.executor();
                        boolean interruptThread = killTask.interruptThread();
                        String reason = killTask.reason();
                        Option option = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            ExecutorData executorInfo = (ExecutorData)some.value();
                            executorInfo.executorEndpoint().send(new CoarseGrainedClusterMessages.KillTask(taskId, executorId, interruptThread, reason));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Attempted to kill task ").append(taskId).append(" for unknown executor ").append(executorId).append(".").toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.KillExecutorsOnHost) {
                        CoarseGrainedClusterMessages.KillExecutorsOnHost killExecutorsOnHost = (CoarseGrainedClusterMessages.KillExecutorsOnHost)A1;
                        String host = killExecutorsOnHost.host();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.getExecutorsAliveOnHost(host).foreach((Function1 & Serializable & scala.Serializable)exec -> $this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().killExecutors((Seq<String>)exec.toSeq(), false, false, true));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.UpdateDelegationTokens) {
                        CoarseGrainedClusterMessages.UpdateDelegationTokens updateDelegationTokens = (CoarseGrainedClusterMessages.UpdateDelegationTokens)A1;
                        byte[] newDelegationTokens = updateDelegationTokens.tokens();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().values().foreach((Function1 & Serializable & scala.Serializable)ed -> {
                            DriverEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$4(newDelegationTokens, ed);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor.executorId();
                        ExecutorLossReason reason = removeExecutor.reason();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                            DriverEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$5(x$2);
                            return BoxedUnit.UNIT;
                        });
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(executorId, reason);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.StatusUpdate ? true : (CoarseGrainedClusterMessages$ReviveOffers$.MODULE$.equals(object) ? true : (object instanceof CoarseGrainedClusterMessages.KillTask ? true : (object instanceof CoarseGrainedClusterMessages.KillExecutorsOnHost ? true : (object instanceof CoarseGrainedClusterMessages.UpdateDelegationTokens ? true : object instanceof CoarseGrainedClusterMessages.RemoveExecutor))));
                    return bl;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$4(byte[] newDelegationTokens$1, ExecutorData ed) {
                    ed.executorEndpoint().send(new CoarseGrainedClusterMessages.UpdateDelegationTokens(newDelegationTokens$1));
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$5(ExecutorData x$2) {
                    x$2.executorEndpoint().send(CoarseGrainedClusterMessages$StopExecutor$.MODULE$);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String long scala.Enumeration$Value ), $anonfun$applyOrElse$2(long java.lang.String ), $anonfun$applyOrElse$3(org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$receive$1 scala.collection.Set ), $anonfun$applyOrElse$4$adapted(byte[] org.apache.spark.scheduler.cluster.ExecutorData ), $anonfun$applyOrElse$5$adapted(org.apache.spark.scheduler.cluster.ExecutorData )}, serializedLambda);
                }
            };
        }

        @Override
        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DriverEndpoint $outer;
                private final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RegisterExecutor registerExecutor = (CoarseGrainedClusterMessages.RegisterExecutor)A1;
                        String executorId = registerExecutor.executorId();
                        RpcEndpointRef executorRef = registerExecutor.executorRef();
                        String hostname = registerExecutor.hostname();
                        int cores = registerExecutor.cores();
                        scala.collection.immutable.Map<String, String> logUrls = registerExecutor.logUrls();
                        if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().contains((Object)executorId)) {
                            executorRef.send(new CoarseGrainedClusterMessages.RegisterExecutorFailed(new StringBuilder(23).append("Duplicate executor ID: ").append(executorId).toString()));
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.nodeBlacklist().contains((Object)hostname)) {
                            this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Rejecting ").append(executorId).append(" as it has been blacklisted.").toString());
                            executorRef.send(new CoarseGrainedClusterMessages.RegisterExecutorFailed(new StringBuilder(25).append("Executor is blacklisted: ").append(executorId).toString()));
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            RpcAddress executorAddress = executorRef.address() != null ? executorRef.address() : this.context$1.senderAddress();
                            this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Registered executor ").append(executorRef).append(" (").append(executorAddress).append(") with ID ").append(executorId).toString());
                            this.$outer.addressToExecutorId().update((Object)executorAddress, (Object)executorId);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(cores);
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(1);
                            ExecutorData data = new ExecutorData(executorRef, executorAddress, hostname, cores, cores, logUrls);
                            CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                            synchronized (coarseGrainedSchedulerBackend) {
                                this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().put((Object)executorId, (Object)data);
                                if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().currentExecutorIdCounter() < new StringOps(Predef$.MODULE$.augmentString(executorId)).toInt()) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().currentExecutorIdCounter_$eq(new StringOps(Predef$.MODULE$.augmentString(executorId)).toInt());
                                }
                                if (this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() > 0) {
                                    this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors_$eq(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors() - 1);
                                    this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Decremented number of pending executors (").append($this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$numPendingExecutors()).append(" left)").toString());
                                }
                            }
                            executorRef.send(CoarseGrainedClusterMessages$RegisteredExecutor$.MODULE$);
                            this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorAdded(System.currentTimeMillis(), executorId, data));
                            this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else if (CoarseGrainedClusterMessages$StopDriver$.MODULE$.equals(A1)) {
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        this.$outer.stop();
                        object = BoxedUnit.UNIT;
                    } else if (CoarseGrainedClusterMessages$StopExecutors$.MODULE$.equals(A1)) {
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asking each executor to shut down");
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DriverEndpoint$$anonfun$receiveAndReply$1.$anonfun$applyOrElse$10(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                            DriverEndpoint$$anonfun$receiveAndReply$1.$anonfun$applyOrElse$11(x$3);
                            return BoxedUnit.UNIT;
                        });
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.RemoveWorker) {
                        CoarseGrainedClusterMessages.RemoveWorker removeWorker = (CoarseGrainedClusterMessages.RemoveWorker)A1;
                        String workerId = removeWorker.workerId();
                        String host = removeWorker.host();
                        String message = removeWorker.message();
                        this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeWorker(workerId, host, message);
                        this.context$1.reply(BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else if (CoarseGrainedClusterMessages$RetrieveSparkAppConfig$.MODULE$.equals(A1)) {
                        CoarseGrainedClusterMessages.SparkAppConfig reply = new CoarseGrainedClusterMessages.SparkAppConfig(this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties, SparkEnv$.MODULE$.get().securityManager().getIOEncryptionKey(), this.$outer.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().fetchHadoopDelegationTokens());
                        this.context$1.reply(reply);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    Object object = x2;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterExecutor ? true : (CoarseGrainedClusterMessages$StopDriver$.MODULE$.equals(object) ? true : (CoarseGrainedClusterMessages$StopExecutors$.MODULE$.equals(object) ? true : (object instanceof CoarseGrainedClusterMessages.RemoveWorker ? true : CoarseGrainedClusterMessages$RetrieveSparkAppConfig$.MODULE$.equals(object))));
                    return bl;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$10(Tuple2 check$ifrefutable$1) {
                    Tuple2 tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$11(Tuple2 x$3) {
                    Tuple2 tuple2 = x$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ExecutorData executorData = (ExecutorData)tuple2._2();
                    executorData.executorEndpoint().send(CoarseGrainedClusterMessages$StopExecutor$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(java.lang.String ), $anonfun$applyOrElse$7(java.lang.String org.apache.spark.rpc.RpcEndpointRef org.apache.spark.rpc.RpcAddress ), $anonfun$applyOrElse$8(org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend$DriverEndpoint$$anonfun$receiveAndReply$1 ), $anonfun$applyOrElse$9(), $anonfun$applyOrElse$10$adapted(scala.Tuple2 ), $anonfun$applyOrElse$11$adapted(scala.Tuple2 )}, serializedLambda);
                }
            };
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers() {
            block3: {
                Seq<Seq<TaskDescription>> seq;
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                synchronized (coarseGrainedSchedulerBackend) {
                    Map activeExecutors = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().filterKeys((Function1 & Serializable & scala.Serializable)executorId -> BoxesRunTime.boxToBoolean((boolean)this.executorIsAlive(executorId)));
                    scala.collection.immutable.IndexedSeq workOffers = ((TraversableOnce)activeExecutors.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String id = (String)tuple2._1();
                        ExecutorData executorData = (ExecutorData)tuple2._2();
                        WorkerOffer workerOffer = new WorkerOffer(id, executorData.executorHost(), executorData.freeCores(), (Option<String>)new Some((Object)executorData.executorAddress().hostPort()));
                        return workerOffer;
                    }, Iterable$.MODULE$.canBuildFrom())).toIndexedSeq();
                    seq = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((IndexedSeq<WorkerOffer>)workOffers);
                }
                Seq<Seq<TaskDescription>> taskDescs = seq;
                if (taskDescs.isEmpty()) break block3;
                this.launchTasks(taskDescs);
            }
        }

        @Override
        public void onDisconnected(RpcAddress remoteAddress) {
            this.addressToExecutorId().get((Object)remoteAddress).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(x$4, new SlaveLost("Remote RPC client disassociated. Likely due to containers exceeding thresholds, or network issues. Check driver logs for WARN messages.", SlaveLost$.MODULE$.apply$default$2()));
                return BoxedUnit.UNIT;
            });
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$makeOffers(String executorId) {
            block5: {
                Seq<Seq<TaskDescription>> seq;
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                synchronized (coarseGrainedSchedulerBackend) {
                    Seq<Seq<TaskDescription>> seq2;
                    if (this.executorIsAlive(executorId)) {
                        ExecutorData executorData = (ExecutorData)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)executorId);
                        IndexedSeq workOffers = (IndexedSeq)scala.package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WorkerOffer[]{new WorkerOffer(executorId, executorData.executorHost(), executorData.freeCores(), (Option<String>)new Some((Object)executorData.executorAddress().hostPort()))}));
                        seq2 = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.resourceOffers((IndexedSeq<WorkerOffer>)workOffers);
                    } else {
                        seq2 = (Seq<Seq<TaskDescription>>)Seq$.MODULE$.empty();
                    }
                    seq = seq2;
                }
                Seq<Seq<TaskDescription>> taskDescs = seq;
                if (taskDescs.isEmpty()) break block5;
                this.launchTasks(taskDescs);
            }
        }

        private synchronized boolean executorIsAlive(String executorId) {
            return !this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId) && !this.executorsPendingLossReason().contains((Object)executorId);
        }

        private void launchTasks(Seq<Seq<TaskDescription>> tasks) {
            ((IterableLike)tasks.flatten((Function1)Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable & scala.Serializable)task -> {
                DriverEndpoint.$anonfun$launchTasks$1(this, task);
                return BoxedUnit.UNIT;
            });
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeExecutor(String executorId, ExecutorLossReason reason) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Asked to remove executor ").append(executorId).append(" with reason ").append(reason).toString());
            Option option = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().get((Object)executorId);
            if (option instanceof Some) {
                boolean bl;
                Some some = (Some)option;
                ExecutorData executorInfo = (ExecutorData)some.value();
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                synchronized (coarseGrainedSchedulerBackend) {
                    this.addressToExecutorId().$minus$eq((Object)executorInfo.executorAddress());
                    this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().$minus$eq((Object)executorId);
                    this.executorsPendingLossReason().$minus$eq((Object)executorId);
                    bl = BoxesRunTime.unboxToBoolean((Object)this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().remove((Object)executorId).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                }
                boolean killed = bl;
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalCoreCount().addAndGet(-executorInfo.totalCores());
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().totalRegisteredExecutors().addAndGet(-1);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, killed ? ExecutorKilled$.MODULE$ : reason);
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$listenerBus().post(new SparkListenerExecutorRemoved(System.currentTimeMillis(), executorId, reason.toString()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.sc().env().blockManager().master().removeExecutorAsync(executorId);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Asked to remove non-existent executor ").append(executorId).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }

        public void org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$removeWorker(String workerId, String host, String message) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Asked to remove worker ").append(workerId).append(" with reason ").append(message).toString());
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.workerRemoved(workerId, host, message);
        }

        /*
         * WARNING - void declaration
         */
        public boolean disableExecutor(String executorId) {
            void var2_4;
            block5: {
                boolean bl;
                CoarseGrainedSchedulerBackend coarseGrainedSchedulerBackend = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer();
                synchronized (coarseGrainedSchedulerBackend) {
                    boolean bl2;
                    if (this.executorIsAlive(executorId)) {
                        this.executorsPendingLossReason().$plus$eq((Object)executorId);
                        bl2 = true;
                    } else {
                        bl2 = this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorsPendingToRemove().contains((Object)executorId);
                    }
                    bl = bl2;
                }
                boolean shouldDisable = bl;
                if (!shouldDisable) break block5;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Disabling executor ").append(executorId).append(".").toString());
                this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.executorLost(executorId, LossReasonPending$.MODULE$);
            }
            return (boolean)var2_4;
        }

        public /* synthetic */ CoarseGrainedSchedulerBackend org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$launchTasks$2(DriverEndpoint $this, ByteBuffer serializedTask$1, TaskDescription task$1, TaskSetManager taskSetMgr) {
            try {
                String msg = "Serialized task %s:%d was %d bytes, which exceeds max allowed: spark.rpc.message.maxSize (%d bytes). Consider increasing spark.rpc.message.maxSize or using broadcast variables for large values.";
                msg = new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)task$1.taskId()), BoxesRunTime.boxToInteger((int)task$1.index()), BoxesRunTime.boxToInteger((int)serializedTask$1.limit()), BoxesRunTime.boxToInteger((int)$this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize())}));
                taskSetMgr.abort(msg, taskSetMgr.abort$default$2());
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception in error callback", e);
            }
        }

        public static final /* synthetic */ void $anonfun$launchTasks$1(DriverEndpoint $this, TaskDescription task) {
            ByteBuffer serializedTask = TaskDescription$.MODULE$.encode(task);
            if (serializedTask.limit() >= $this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$maxRpcMessageSize()) {
                Option$.MODULE$.apply((Object)$this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.taskIdToTaskSetManager().get(BoxesRunTime.boxToLong((long)task.taskId()))).foreach((Function1 & Serializable & scala.Serializable)taskSetMgr -> {
                    DriverEndpoint.$anonfun$launchTasks$2($this, serializedTask, task, taskSetMgr);
                    return BoxedUnit.UNIT;
                });
            } else {
                ExecutorData executorData = (ExecutorData)$this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$executorDataMap().apply((Object)task.executorId());
                executorData.freeCores_$eq(executorData.freeCores() - $this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$$scheduler.CPUS_PER_TASK());
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Launching task ").append(task.taskId()).append(" on executor id: ").append(task.executorId()).append(" hostname: ").append(new StringBuilder(1).append(executorData.executorHost()).append(".").toString()).toString());
                executorData.executorEndpoint().send(new CoarseGrainedClusterMessages.LaunchTask(new SerializableBuffer(serializedTask)));
            }
        }

        public DriverEndpoint(CoarseGrainedSchedulerBackend $outer, RpcEnv rpcEnv, Seq<Tuple2<String, String>> sparkProperties) {
            this.rpcEnv = rpcEnv;
            this.org$apache$spark$scheduler$cluster$CoarseGrainedSchedulerBackend$DriverEndpoint$$sparkProperties = sparkProperties;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.$init$(this);
            Logging.$init$(this);
            this.executorsPendingLossReason = new HashSet();
            this.addressToExecutorId = new HashMap();
        }
    }
}

