/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.jadira.usertype.spi.shared.AbstractSingleColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.ConfigurationHelper;
import org.jadira.usertype.spi.shared.IntegratorConfiguredType;
import org.jadira.usertype.spi.shared.Jdbc42Configured;
import org.jadira.usertype.spi.timezone.proxy.WrapsSession;
import org.jadira.usertype.spi.utils.lang.ConcurrentHashMapBackedProperties;
import org.jadira.usertype.spi.utils.runtime.JavaVersion;

public abstract class AbstractParameterizedUserType<T, J, C extends ColumnMapper<T, J>>
extends AbstractSingleColumnUserType<T, J, C>
implements ParameterizedType,
IntegratorConfiguredType {
    private static final long serialVersionUID = -8038898451426631564L;
    private Properties parameterValues;

    public void setParameterValues(Properties parameters) {
        this.parameterValues = new ConcurrentHashMapBackedProperties(parameters);
    }

    protected Properties getParameterValues() {
        return this.parameterValues;
    }

    @Override
    public void applyConfiguration(SessionFactory sessionFactory) {
        this.doApplyConfiguration();
    }

    private <Z> void doApplyConfiguration() {
        Jdbc42Configured next;
        if (JavaVersion.isJava8OrLater() && Jdbc42Configured.class.isAssignableFrom(this.getClass())) {
            next = (Jdbc42Configured)((Object)this);
            this.performJdbc42Configuration(next);
        }
        if (JavaVersion.isJava8OrLater() && Jdbc42Configured.class.isAssignableFrom(this.getColumnMapper().getClass())) {
            next = (Jdbc42Configured)((Object)this);
            this.performJdbc42Configuration(next);
        }
    }

    private void performJdbc42Configuration(Jdbc42Configured next) {
        String apisString;
        Boolean jdbc42Apis = null;
        if (this.getParameterValues() != null && (apisString = this.getParameterValues().getProperty("jdbc42Apis")) != null) {
            jdbc42Apis = Boolean.parseBoolean(apisString);
        }
        if (jdbc42Apis == null) {
            jdbc42Apis = ConfigurationHelper.getUse42Api();
        }
        if (jdbc42Apis == null) {
            jdbc42Apis = Boolean.FALSE;
        }
        next.setUseJdbc42Apis(jdbc42Apis);
    }

    @Override
    protected SharedSessionContractImplementor doWrapSession(SharedSessionContractImplementor session) {
        SharedSessionContractImplementor mySession = session;
        if (WrapsSession.class.isAssignableFrom(this.getColumnMapper().getClass())) {
            mySession = ((WrapsSession)this.getColumnMapper()).wrapSession(mySession);
        }
        if (WrapsSession.class.isAssignableFrom(this.getClass())) {
            mySession = ((WrapsSession)((Object)this)).wrapSession(mySession);
        }
        return mySession;
    }
}

