/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.LicenseCapacity;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class License
implements Serializable {
    private String licenseId;
    private String type;
    private String pool;
    private List<LicenseCapacity> capacities;
    private List<Tag> tags;

    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public License withLicenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public License withType(String type) {
        this.type = type;
        return this;
    }

    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public License withPool(String pool) {
        this.pool = pool;
        return this;
    }

    public List<LicenseCapacity> getCapacities() {
        if (this.capacities == null) {
            this.capacities = new ArrayList<LicenseCapacity>();
        }
        return this.capacities;
    }

    public void setCapacities(Collection<LicenseCapacity> capacities) {
        if (capacities == null) {
            this.capacities = null;
            return;
        }
        ArrayList<LicenseCapacity> capacitiesCopy = new ArrayList<LicenseCapacity>(capacities.size());
        capacitiesCopy.addAll(capacities);
        this.capacities = capacitiesCopy;
    }

    public License withCapacities(LicenseCapacity ... capacities) {
        if (this.getCapacities() == null) {
            this.setCapacities(new ArrayList<LicenseCapacity>(capacities.length));
        }
        for (LicenseCapacity value : capacities) {
            this.getCapacities().add(value);
        }
        return this;
    }

    public License withCapacities(Collection<LicenseCapacity> capacities) {
        if (capacities == null) {
            this.capacities = null;
        } else {
            ArrayList<LicenseCapacity> capacitiesCopy = new ArrayList<LicenseCapacity>(capacities.size());
            capacitiesCopy.addAll(capacities);
            this.capacities = capacitiesCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public License withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public License withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLicenseId() != null) {
            sb.append("LicenseId: " + this.getLicenseId() + ", ");
        }
        if (this.getType() != null) {
            sb.append("Type: " + this.getType() + ", ");
        }
        if (this.getPool() != null) {
            sb.append("Pool: " + this.getPool() + ", ");
        }
        if (this.getCapacities() != null) {
            sb.append("Capacities: " + this.getCapacities() + ", ");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLicenseId() == null ? 0 : this.getLicenseId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPool() == null ? 0 : this.getPool().hashCode());
        hashCode = 31 * hashCode + (this.getCapacities() == null ? 0 : ((Object)this.getCapacities()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof License)) {
            return false;
        }
        License other = (License)obj;
        if (other.getLicenseId() == null ^ this.getLicenseId() == null) {
            return false;
        }
        if (other.getLicenseId() != null && !other.getLicenseId().equals(this.getLicenseId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPool() == null ^ this.getPool() == null) {
            return false;
        }
        if (other.getPool() != null && !other.getPool().equals(this.getPool())) {
            return false;
        }
        if (other.getCapacities() == null ^ this.getCapacities() == null) {
            return false;
        }
        if (other.getCapacities() != null && !((Object)other.getCapacities()).equals(this.getCapacities())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

