/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.services.cloudformation.model.TemplateParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateTemplateResult
implements Serializable {
    private List<TemplateParameter> parameters;
    private String description;
    private List<String> capabilities;
    private String capabilitiesReason;

    public List<TemplateParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<TemplateParameter>();
        }
        return this.parameters;
    }

    public void setParameters(Collection<TemplateParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        ArrayList<TemplateParameter> parametersCopy = new ArrayList<TemplateParameter>(parameters.size());
        parametersCopy.addAll(parameters);
        this.parameters = parametersCopy;
    }

    public ValidateTemplateResult withParameters(TemplateParameter ... parameters) {
        if (this.getParameters() == null) {
            this.setParameters(new ArrayList<TemplateParameter>(parameters.length));
        }
        for (TemplateParameter value : parameters) {
            this.getParameters().add(value);
        }
        return this;
    }

    public ValidateTemplateResult withParameters(Collection<TemplateParameter> parameters) {
        if (parameters == null) {
            this.parameters = null;
        } else {
            ArrayList<TemplateParameter> parametersCopy = new ArrayList<TemplateParameter>(parameters.size());
            parametersCopy.addAll(parameters);
            this.parameters = parametersCopy;
        }
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ValidateTemplateResult withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<String> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<String>();
        }
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.size());
        capabilitiesCopy.addAll(capabilities);
        this.capabilities = capabilitiesCopy;
    }

    public ValidateTemplateResult withCapabilities(String ... capabilities) {
        if (this.getCapabilities() == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String value : capabilities) {
            this.getCapabilities().add(value);
        }
        return this;
    }

    public ValidateTemplateResult withCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
        } else {
            ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.size());
            capabilitiesCopy.addAll(capabilities);
            this.capabilities = capabilitiesCopy;
        }
        return this;
    }

    public String getCapabilitiesReason() {
        return this.capabilitiesReason;
    }

    public void setCapabilitiesReason(String capabilitiesReason) {
        this.capabilitiesReason = capabilitiesReason;
    }

    public ValidateTemplateResult withCapabilitiesReason(String capabilitiesReason) {
        this.capabilitiesReason = capabilitiesReason;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getParameters() != null) {
            sb.append("Parameters: " + this.getParameters() + ", ");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ", ");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: " + this.getCapabilities() + ", ");
        }
        if (this.getCapabilitiesReason() != null) {
            sb.append("CapabilitiesReason: " + this.getCapabilitiesReason() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : ((Object)this.getParameters()).hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : ((Object)this.getCapabilities()).hashCode());
        hashCode = 31 * hashCode + (this.getCapabilitiesReason() == null ? 0 : this.getCapabilitiesReason().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateTemplateResult)) {
            return false;
        }
        ValidateTemplateResult other = (ValidateTemplateResult)obj;
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !((Object)other.getParameters()).equals(this.getParameters())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !((Object)other.getCapabilities()).equals(this.getCapabilities())) {
            return false;
        }
        if (other.getCapabilitiesReason() == null ^ this.getCapabilitiesReason() == null) {
            return false;
        }
        return other.getCapabilitiesReason() == null || other.getCapabilitiesReason().equals(this.getCapabilitiesReason());
    }
}

