/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.example;

import com.twilio.base.ResourceSet;
import com.twilio.http.TwilioRestClient;
import com.twilio.http.ValidationClient;
import com.twilio.rest.api.v2010.account.Message;
import com.twilio.rest.api.v2010.account.NewSigningKey;
import com.twilio.type.PhoneNumber;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import org.apache.commons.codec.binary.Base64;

public class ValidationExample {
    public static final String ACCOUNT_SID = System.getenv("TWILIO_ACCOUNT_SID");
    public static final String AUTH_TOKEN = System.getenv("TWILIO_AUTH_TOKEN");

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair pair = keyGen.generateKeyPair();
        PublicKey pk = pair.getPublic();
        TwilioRestClient client = new TwilioRestClient.Builder(ACCOUNT_SID, AUTH_TOKEN).build();
        com.twilio.rest.accounts.v1.credential.PublicKey key = com.twilio.rest.accounts.v1.credential.PublicKey.creator(Base64.encodeBase64String(pk.getEncoded())).setFriendlyName("Public Key").create(client);
        NewSigningKey signingKey = NewSigningKey.creator().create(client);
        TwilioRestClient validationClient = new TwilioRestClient.Builder(signingKey.getSid(), signingKey.getSecret()).accountSid(ACCOUNT_SID).httpClient(new ValidationClient(ACCOUNT_SID, key.getSid(), signingKey.getSid(), pair.getPrivate())).build();
        ResourceSet<Message> messages = Message.reader().read(validationClient);
        for (Message message : messages) {
            System.out.println(message.getBody());
        }
        Message message = Message.creator(new PhoneNumber("+1XXXXXXXXXX"), new PhoneNumber("+1XXXXXXXXXX"), "Public Key Client Validation Test").create(validationClient);
        System.out.println(message.getSid());
    }
}

