/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.twiml.TwiML;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Play
extends TwiML {
    private final Integer loop;
    private final String digits;
    private final URI url;

    private Play() {
        this(new Builder());
    }

    private Play(Builder b) {
        super("Play", b);
        this.loop = b.loop;
        this.digits = b.digits;
        this.url = b.url;
    }

    @Override
    protected String getElementBody() {
        return this.getUrl() == null ? null : this.getUrl().toString();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getLoop() != null) {
            attrs.put("loop", this.getLoop().toString());
        }
        if (this.getDigits() != null) {
            attrs.put("digits", this.getDigits());
        }
        return attrs;
    }

    public Integer getLoop() {
        return this.loop;
    }

    public String getDigits() {
        return this.digits;
    }

    public URI getUrl() {
        return this.url;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private Integer loop;
        private String digits;
        private URI url;

        public Builder(URI url) {
            this.url = url;
        }

        public Builder(String url) {
            this.url = Promoter.uriFromString(url);
        }

        public Builder() {
        }

        public Builder loop(Integer loop) {
            this.loop = loop;
            return this;
        }

        public Builder digits(String digits) {
            this.digits = digits;
            return this;
        }

        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        public Play build() {
            return new Play(this);
        }
    }
}

