/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.ipmessaging.v2.service.channel;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.ipmessaging.v2.service.channel.Webhook;
import java.util.List;

public class WebhookCreator
extends Creator<Webhook> {
    private final String pathServiceSid;
    private final String pathChannelSid;
    private final Webhook.Type type;
    private String configurationUrl;
    private Webhook.Method configurationMethod;
    private List<String> configurationFilters;
    private List<String> configurationTriggers;
    private String configurationFlowSid;
    private Integer configurationRetryCount;

    public WebhookCreator(String pathServiceSid, String pathChannelSid, Webhook.Type type) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.type = type;
    }

    public WebhookCreator setConfigurationUrl(String configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public WebhookCreator setConfigurationMethod(Webhook.Method configurationMethod) {
        this.configurationMethod = configurationMethod;
        return this;
    }

    public WebhookCreator setConfigurationFilters(List<String> configurationFilters) {
        this.configurationFilters = configurationFilters;
        return this;
    }

    public WebhookCreator setConfigurationFilters(String configurationFilters) {
        return this.setConfigurationFilters(Promoter.listOfOne(configurationFilters));
    }

    public WebhookCreator setConfigurationTriggers(List<String> configurationTriggers) {
        this.configurationTriggers = configurationTriggers;
        return this;
    }

    public WebhookCreator setConfigurationTriggers(String configurationTriggers) {
        return this.setConfigurationTriggers(Promoter.listOfOne(configurationTriggers));
    }

    public WebhookCreator setConfigurationFlowSid(String configurationFlowSid) {
        this.configurationFlowSid = configurationFlowSid;
        return this;
    }

    public WebhookCreator setConfigurationRetryCount(Integer configurationRetryCount) {
        this.configurationRetryCount = configurationRetryCount;
        return this;
    }

    @Override
    public Webhook create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.IPMESSAGING.toString(), "/v2/Services/" + this.pathServiceSid + "/Channels/" + this.pathChannelSid + "/Webhooks", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.type != null) {
            request.addPostParam("Type", this.type.toString());
        }
        if (this.configurationUrl != null) {
            request.addPostParam("Configuration.Url", this.configurationUrl);
        }
        if (this.configurationMethod != null) {
            request.addPostParam("Configuration.Method", this.configurationMethod.toString());
        }
        if (this.configurationFilters != null) {
            for (String prop : this.configurationFilters) {
                request.addPostParam("Configuration.Filters", prop);
            }
        }
        if (this.configurationTriggers != null) {
            for (String prop : this.configurationTriggers) {
                request.addPostParam("Configuration.Triggers", prop);
            }
        }
        if (this.configurationFlowSid != null) {
            request.addPostParam("Configuration.FlowSid", this.configurationFlowSid);
        }
        if (this.configurationRetryCount != null) {
            request.addPostParam("Configuration.RetryCount", this.configurationRetryCount.toString());
        }
    }
}

