/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.usertype.ParameterizedType;
import org.jadira.usertype.spi.shared.AbstractSingleColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.ConfigurationHelper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.IntegratorConfiguredType;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;

public abstract class AbstractParameterizedUserType<T, J, C extends ColumnMapper<T, J>>
extends AbstractSingleColumnUserType<T, J, C>
implements ParameterizedType,
IntegratorConfiguredType {
    private static final long serialVersionUID = -8038898451426631564L;
    private Properties parameterValues;

    public void setParameterValues(Properties parameters) {
        this.parameterValues = parameters;
    }

    protected Properties getParameterValues() {
        return this.parameterValues;
    }

    @Override
    public void applyConfiguration(SessionFactory sessionFactory) {
        this.doApplyConfiguration();
    }

    private <Z> void doApplyConfiguration() {
        Object next;
        if (DatabaseZoneConfigured.class.isAssignableFrom(this.getClass())) {
            next = (DatabaseZoneConfigured)((Object)this);
            this.performDatabaseZoneConfiguration((DatabaseZoneConfigured<Z>)next);
        }
        if (JavaZoneConfigured.class.isAssignableFrom(this.getClass())) {
            next = (JavaZoneConfigured)((Object)this);
            this.performJavaZoneConfiguration((JavaZoneConfigured<Z>)next);
        }
        if (DatabaseZoneConfigured.class.isAssignableFrom(this.getColumnMapper().getClass())) {
            next = (DatabaseZoneConfigured)this.getColumnMapper();
            this.performDatabaseZoneConfiguration((DatabaseZoneConfigured<Z>)next);
        }
        if (JavaZoneConfigured.class.isAssignableFrom(this.getColumnMapper().getClass())) {
            next = (JavaZoneConfigured)this.getColumnMapper();
            this.performJavaZoneConfiguration((JavaZoneConfigured<Z>)next);
        }
    }

    private <Z> void performDatabaseZoneConfiguration(DatabaseZoneConfigured<Z> next) {
        String databaseZone = null;
        if (this.getParameterValues() != null) {
            databaseZone = this.getParameterValues().getProperty("databaseZone");
        }
        if (databaseZone == null) {
            databaseZone = ConfigurationHelper.getProperty("databaseZone");
        }
        if (databaseZone != null) {
            if ("jvm".equals(databaseZone)) {
                next.setDatabaseZone(null);
            } else {
                next.setDatabaseZone(next.parseZone(databaseZone));
            }
        }
    }

    private <Z> void performJavaZoneConfiguration(JavaZoneConfigured<Z> next) {
        String javaZone = null;
        if (this.getParameterValues() != null) {
            javaZone = this.getParameterValues().getProperty("javaZone");
        }
        if (javaZone == null) {
            javaZone = ConfigurationHelper.getProperty("javaZone");
        }
        if (javaZone != null) {
            if ("jvm".equals(javaZone)) {
                next.setJavaZone(null);
            } else {
                next.setJavaZone(next.parseZone(javaZone));
            }
        }
    }
}

