/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpMethod;
import com.twilio.rest.video.v1.CompositionHookCreator;
import com.twilio.rest.video.v1.CompositionHookDeleter;
import com.twilio.rest.video.v1.CompositionHookFetcher;
import com.twilio.rest.video.v1.CompositionHookReader;
import com.twilio.rest.video.v1.CompositionHookUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CompositionHook
extends Resource {
    private static final long serialVersionUID = 281311376768009L;
    private final String accountSid;
    private final String friendlyName;
    private final Boolean enabled;
    private final DateTime dateCreated;
    private final String dateUpdated;
    private final String sid;
    private final List<String> audioSources;
    private final List<String> audioSourcesExcluded;
    private final Map<String, Object> videoLayout;
    private final String resolution;
    private final Boolean trim;
    private final Format format;
    private final String statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final URI url;

    public static CompositionHookFetcher fetcher(String pathSid) {
        return new CompositionHookFetcher(pathSid);
    }

    public static CompositionHookReader reader() {
        return new CompositionHookReader();
    }

    public static CompositionHookDeleter deleter(String pathSid) {
        return new CompositionHookDeleter(pathSid);
    }

    public static CompositionHookCreator creator(String friendlyName) {
        return new CompositionHookCreator(friendlyName);
    }

    public static CompositionHookUpdater updater(String pathSid, String friendlyName) {
        return new CompositionHookUpdater(pathSid, friendlyName);
    }

    public static CompositionHook fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CompositionHook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CompositionHook fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, CompositionHook.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CompositionHook(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="enabled") Boolean enabled, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="sid") String sid, @JsonProperty(value="audio_sources") List<String> audioSources, @JsonProperty(value="audio_sources_excluded") List<String> audioSourcesExcluded, @JsonProperty(value="video_layout") Map<String, Object> videoLayout, @JsonProperty(value="resolution") String resolution, @JsonProperty(value="trim") Boolean trim, @JsonProperty(value="format") Format format, @JsonProperty(value="status_callback") String statusCallback, @JsonProperty(value="status_callback_method") HttpMethod statusCallbackMethod, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.enabled = enabled;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = dateUpdated;
        this.sid = sid;
        this.audioSources = audioSources;
        this.audioSourcesExcluded = audioSourcesExcluded;
        this.videoLayout = videoLayout;
        this.resolution = resolution;
        this.trim = trim;
        this.format = format;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Boolean getEnabled() {
        return this.enabled;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final String getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getSid() {
        return this.sid;
    }

    public final List<String> getAudioSources() {
        return this.audioSources;
    }

    public final List<String> getAudioSourcesExcluded() {
        return this.audioSourcesExcluded;
    }

    public final Map<String, Object> getVideoLayout() {
        return this.videoLayout;
    }

    public final String getResolution() {
        return this.resolution;
    }

    public final Boolean getTrim() {
        return this.trim;
    }

    public final Format getFormat() {
        return this.format;
    }

    public final String getStatusCallback() {
        return this.statusCallback;
    }

    public final HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositionHook other = (CompositionHook)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.sid, other.sid) && Objects.equals(this.audioSources, other.audioSources) && Objects.equals(this.audioSourcesExcluded, other.audioSourcesExcluded) && Objects.equals(this.videoLayout, other.videoLayout) && Objects.equals(this.resolution, other.resolution) && Objects.equals(this.trim, other.trim) && Objects.equals((Object)this.format, (Object)other.format) && Objects.equals(this.statusCallback, other.statusCallback) && Objects.equals((Object)this.statusCallbackMethod, (Object)other.statusCallbackMethod) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.friendlyName, this.enabled, this.dateCreated, this.dateUpdated, this.sid, this.audioSources, this.audioSourcesExcluded, this.videoLayout, this.resolution, this.trim, this.format, this.statusCallback, this.statusCallbackMethod, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("friendlyName", this.friendlyName).add("enabled", this.enabled).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("sid", this.sid).add("audioSources", this.audioSources).add("audioSourcesExcluded", this.audioSourcesExcluded).add("videoLayout", this.videoLayout).add("resolution", this.resolution).add("trim", this.trim).add("format", (Object)this.format).add("statusCallback", this.statusCallback).add("statusCallbackMethod", (Object)this.statusCallbackMethod).add("url", this.url).toString();
    }

    public static enum Format {
        MP4("mp4"),
        WEBM("webm");

        private final String value;

        private Format(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Format forValue(String value) {
            return (Format)Promoter.enumFromString((String)value, (Enum[])Format.values());
        }
    }
}

