/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.syncstream;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.sync.v1.service.syncstream.StreamMessageCreator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamMessage
extends Resource {
    private static final long serialVersionUID = 144642288348060L;
    private final String sid;
    private final Map<String, Object> data;

    public static StreamMessageCreator creator(String pathServiceSid, String pathStreamSid, Map<String, Object> data) {
        return new StreamMessageCreator(pathServiceSid, pathStreamSid, data);
    }

    public static StreamMessage fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, StreamMessage.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static StreamMessage fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, StreamMessage.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private StreamMessage(@JsonProperty(value="sid") String sid, @JsonProperty(value="data") Map<String, Object> data) {
        this.sid = sid;
        this.data = data;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamMessage other = (StreamMessage)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("data", this.data).toString();
    }
}

