/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.CallCreator;
import com.twilio.rest.api.v2010.account.CallDeleter;
import com.twilio.rest.api.v2010.account.CallFetcher;
import com.twilio.rest.api.v2010.account.CallReader;
import com.twilio.rest.api.v2010.account.CallUpdater;
import com.twilio.type.Endpoint;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Call
extends Resource {
    private static final long serialVersionUID = 194998930798610L;
    private final String accountSid;
    private final String annotation;
    private final String answeredBy;
    private final String apiVersion;
    private final String callerName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String direction;
    private final String duration;
    private final DateTime endTime;
    private final String forwardedFrom;
    private final String from;
    private final String fromFormatted;
    private final String groupSid;
    private final String parentCallSid;
    private final String phoneNumberSid;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String sid;
    private final DateTime startTime;
    private final Status status;
    private final Map<String, String> subresourceUris;
    private final String to;
    private final String toFormatted;
    private final String uri;

    public static CallCreator creator(String pathAccountSid, Endpoint to, PhoneNumber from, URI url) {
        return new CallCreator(pathAccountSid, to, from, url);
    }

    public static CallCreator creator(Endpoint to, PhoneNumber from, URI url) {
        return new CallCreator(to, from, url);
    }

    public static CallCreator creator(String pathAccountSid, Endpoint to, PhoneNumber from, String applicationSid) {
        return new CallCreator(pathAccountSid, to, from, applicationSid);
    }

    public static CallCreator creator(Endpoint to, PhoneNumber from, String applicationSid) {
        return new CallCreator(to, from, applicationSid);
    }

    public static CallDeleter deleter(String pathAccountSid, String pathSid) {
        return new CallDeleter(pathAccountSid, pathSid);
    }

    public static CallDeleter deleter(String pathSid) {
        return new CallDeleter(pathSid);
    }

    public static CallFetcher fetcher(String pathAccountSid, String pathSid) {
        return new CallFetcher(pathAccountSid, pathSid);
    }

    public static CallFetcher fetcher(String pathSid) {
        return new CallFetcher(pathSid);
    }

    public static CallReader reader(String pathAccountSid) {
        return new CallReader(pathAccountSid);
    }

    public static CallReader reader() {
        return new CallReader();
    }

    public static CallUpdater updater(String pathAccountSid, String pathSid) {
        return new CallUpdater(pathAccountSid, pathSid);
    }

    public static CallUpdater updater(String pathSid) {
        return new CallUpdater(pathSid);
    }

    public static Call fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Call.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Call fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Call.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Call(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="annotation") String annotation, @JsonProperty(value="answered_by") String answeredBy, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="caller_name") String callerName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="direction") String direction, @JsonProperty(value="duration") String duration, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="forwarded_from") String forwardedFrom, @JsonProperty(value="from") String from, @JsonProperty(value="from_formatted") String fromFormatted, @JsonProperty(value="group_sid") String groupSid, @JsonProperty(value="parent_call_sid") String parentCallSid, @JsonProperty(value="phone_number_sid") String phoneNumberSid, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="sid") String sid, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="status") Status status, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris, @JsonProperty(value="to") String to, @JsonProperty(value="to_formatted") String toFormatted, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.annotation = annotation;
        this.answeredBy = answeredBy;
        this.apiVersion = apiVersion;
        this.callerName = callerName;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.direction = direction;
        this.duration = duration;
        this.endTime = DateConverter.rfc2822DateTimeFromString(endTime);
        this.forwardedFrom = forwardedFrom;
        this.from = from;
        this.fromFormatted = fromFormatted;
        this.groupSid = groupSid;
        this.parentCallSid = parentCallSid;
        this.phoneNumberSid = phoneNumberSid;
        this.price = price;
        this.priceUnit = priceUnit;
        this.sid = sid;
        this.startTime = DateConverter.rfc2822DateTimeFromString(startTime);
        this.status = status;
        this.subresourceUris = subresourceUris;
        this.to = to;
        this.toFormatted = toFormatted;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAnnotation() {
        return this.annotation;
    }

    public final String getAnsweredBy() {
        return this.answeredBy;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getCallerName() {
        return this.callerName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getDirection() {
        return this.direction;
    }

    public final String getDuration() {
        return this.duration;
    }

    public final DateTime getEndTime() {
        return this.endTime;
    }

    public final String getForwardedFrom() {
        return this.forwardedFrom;
    }

    public final String getFrom() {
        return this.from;
    }

    public final String getFromFormatted() {
        return this.fromFormatted;
    }

    public final String getGroupSid() {
        return this.groupSid;
    }

    public final String getParentCallSid() {
        return this.parentCallSid;
    }

    public final String getPhoneNumberSid() {
        return this.phoneNumberSid;
    }

    public final BigDecimal getPrice() {
        return this.price;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final String getSid() {
        return this.sid;
    }

    public final DateTime getStartTime() {
        return this.startTime;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public final String getTo() {
        return this.to;
    }

    public final String getToFormatted() {
        return this.toFormatted;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Call other = (Call)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.annotation, other.annotation) && Objects.equals(this.answeredBy, other.answeredBy) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.callerName, other.callerName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.direction, other.direction) && Objects.equals(this.duration, other.duration) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.forwardedFrom, other.forwardedFrom) && Objects.equals(this.from, other.from) && Objects.equals(this.fromFormatted, other.fromFormatted) && Objects.equals(this.groupSid, other.groupSid) && Objects.equals(this.parentCallSid, other.parentCallSid) && Objects.equals(this.phoneNumberSid, other.phoneNumberSid) && Objects.equals(this.price, other.price) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.sid, other.sid) && Objects.equals(this.startTime, other.startTime) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.subresourceUris, other.subresourceUris) && Objects.equals(this.to, other.to) && Objects.equals(this.toFormatted, other.toFormatted) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.annotation, this.answeredBy, this.apiVersion, this.callerName, this.dateCreated, this.dateUpdated, this.direction, this.duration, this.endTime, this.forwardedFrom, this.from, this.fromFormatted, this.groupSid, this.parentCallSid, this.phoneNumberSid, this.price, this.priceUnit, this.sid, this.startTime, this.status, this.subresourceUris, this.to, this.toFormatted, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("annotation", this.annotation).add("answeredBy", this.answeredBy).add("apiVersion", this.apiVersion).add("callerName", this.callerName).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("direction", this.direction).add("duration", this.duration).add("endTime", this.endTime).add("forwardedFrom", this.forwardedFrom).add("from", this.from).add("fromFormatted", this.fromFormatted).add("groupSid", this.groupSid).add("parentCallSid", this.parentCallSid).add("phoneNumberSid", this.phoneNumberSid).add("price", this.price).add("priceUnit", this.priceUnit).add("sid", this.sid).add("startTime", this.startTime).add("status", (Object)this.status).add("subresourceUris", this.subresourceUris).add("to", this.to).add("toFormatted", this.toFormatted).add("uri", this.uri).toString();
    }

    public static enum UpdateStatus {
        CANCELED("canceled"),
        COMPLETED("completed");

        private final String value;

        private UpdateStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static UpdateStatus forValue(String value) {
            return (UpdateStatus)Promoter.enumFromString((String)value, (Enum[])UpdateStatus.values());
        }
    }

    public static enum Status {
        QUEUED("queued"),
        RINGING("ringing"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed"),
        BUSY("busy"),
        FAILED("failed"),
        NO_ANSWER("no-answer"),
        CANCELED("canceled");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }

    public static enum Event {
        INITIATED("initiated"),
        RINGING("ringing"),
        ANSWERED("answered"),
        COMPLETED("completed");

        private final String value;

        private Event(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Event forValue(String value) {
            return (Event)Promoter.enumFromString((String)value, (Enum[])Event.values());
        }
    }
}

