/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfo;
import org.apache.spark.storage.BlockInfo$;
import org.slf4j.Logger;
import org.spark_project.guava.collect.ConcurrentHashMultiset;
import org.spark_project.guava.collect.ImmutableMultiset;
import org.spark_project.guava.collect.Multiset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.MultiMap;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u0001\u0003\u0001\tQ!\u0001\u0005\"m_\u000e\\\u0017J\u001c4p\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c2\u0001A\u0006\u0012!\taq\"D\u0001\u000e\u0015\u0005q\u0011!B:dC2\f\u0017B\u0001\t\u000e\u0005\u0019\te.\u001f*fMB\u0011!#F\u0007\u0002')\u0011A\u0003B\u0001\tS:$XM\u001d8bY&\u0011ac\u0005\u0002\b\u0019><w-\u001b8h\u0011\u0015A\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\u0006\ty\u0001Aa\b\u0002\u000e)\u0006\u001c8.\u0011;uK6\u0004H/\u00133\u0011\u00051\u0001\u0013BA\u0011\u000e\u0005\u0011auN\\4\t\r\r\u0002\u0001\u0015!\u0003%\u0003\u0015IgNZ8t!\u0011)#\u0006L\u0018\u000e\u0003\u0019R!a\n\u0015\u0002\u000f5,H/\u00192mK*\u0011\u0011&D\u0001\u000bG>dG.Z2uS>t\u0017BA\u0016'\u0005\u001dA\u0015m\u001d5NCB\u0004\"\u0001H\u0017\n\u00059\u0012!a\u0002\"m_\u000e\\\u0017\n\u001a\t\u00039AJ!!\r\u0002\u0003\u0013\tcwnY6J]\u001a|\u0007\u0006\u0002\u00124{y\u0002\"\u0001N\u001e\u000e\u0003UR!AN\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00029s\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0003i\nQA[1wCbL!\u0001P\u001b\u0003\u0013\u001d+\u0018M\u001d3fI\nK\u0018!\u0002<bYV,\u0017%A \u0002\tQD\u0017n\u001d\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\"\u0002!]\u0014\u0018\u000e^3M_\u000e\\7OQ=UCN\\'cA\"F\u0017\u001a!A\t\u0011\u0001C\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0011)#F\u0012%\u0011\u0005\u001dkR\"\u0001\u0001\u0011\u0007\u0015JE&\u0003\u0002KM\t\u00191+\u001a;\u0011\t\u0015be\tL\u0005\u0003\u001b\u001a\u0012\u0001\"T;mi&l\u0015\r\u001d\u0015\u0005\u0001Njd\b\u0003\u0004Q\u0001\u0001\u0006I!U\u0001\u0010e\u0016\fG\rT8dWN\u0014\u0015\u0010V1tWB!QE\u000b$S!\r\u0019F\fL\u0007\u0002)*\u0011QKV\u0001\bG>dG.Z2u\u0015\t9\u0006,\u0001\u0004d_6lwN\u001c\u0006\u00033j\u000baaZ8pO2,'\"A.\u0002\u0007\r|W.\u0003\u0002^)\n12i\u001c8dkJ\u0014XM\u001c;ICNDW*\u001e7uSN,G\u000f\u000b\u0003Pgur\u0004\"\u00021\u0001\t\u0003\t\u0017\u0001\u0004:fO&\u001cH/\u001a:UCN\\GC\u00012f!\ta1-\u0003\u0002e\u001b\t!QK\\5u\u0011\u00151w\f1\u0001G\u00035!\u0018m]6BiR,W\u000e\u001d;JI\")\u0001\u000e\u0001C\u0005S\u0006!2-\u001e:sK:$H+Y:l\u0003R$X-\u001c9u\u0013\u0012,\u0012A\u0012\u0005\u0006W\u0002!\t\u0001\\\u0001\u000fY>\u001c7NR8s%\u0016\fG-\u001b8h)\ri\u0007O\u001d\t\u0004\u00199|\u0013BA8\u000e\u0005\u0019y\u0005\u000f^5p]\")\u0011O\u001ba\u0001Y\u00059!\r\\8dW&#\u0007bB:k!\u0003\u0005\r\u0001^\u0001\tE2|7m[5oOB\u0011A\"^\u0005\u0003m6\u0011qAQ8pY\u0016\fg\u000eC\u0003y\u0001\u0011\u0005\u00110\u0001\bm_\u000e\\gi\u001c:Xe&$\u0018N\\4\u0015\u00075T8\u0010C\u0003ro\u0002\u0007A\u0006C\u0004toB\u0005\t\u0019\u0001;\t\u000bu\u0004A\u0011\u0001@\u0002;\u0005\u001c8/\u001a:u\u00052|7m[%t\u0019>\u001c7.\u001a3G_J<&/\u001b;j]\u001e$\"aL@\t\u000bEd\b\u0019\u0001\u0017\t\u0011\u0005\r\u0001\u0001\"\u0001\u0003\u0003\u000b\t1aZ3u)\ri\u0017q\u0001\u0005\u0007c\u0006\u0005\u0001\u0019\u0001\u0017\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005iAm\\<oOJ\fG-\u001a'pG.$2AYA\b\u0011\u0019\t\u0018\u0011\u0002a\u0001Y!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011AB;oY>\u001c7\u000eF\u0003c\u0003/\tI\u0002\u0003\u0004r\u0003#\u0001\r\u0001\f\u0005\nM\u0006E\u0001\u0013!a\u0001\u00037\u00012\u0001\u00048G\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\ta\u0003\\8dW:+wO\u00117pG.4uN],sSRLgn\u001a\u000b\u0006i\u0006\r\u0012Q\u0005\u0005\u0007c\u0006u\u0001\u0019\u0001\u0017\t\u000f\u0005\u001d\u0012Q\u0004a\u0001_\u0005aa.Z<CY>\u001c7.\u00138g_\"9\u00111\u0006\u0001\u0005\u0002\u00055\u0012A\u0006:fY\u0016\f7/Z!mY2{7m[:G_J$\u0016m]6\u0015\t\u0005=\u0012q\t\t\u0006\u0003c\t\t\u0005\f\b\u0005\u0003g\tiD\u0004\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI$G\u0001\u0007yI|w\u000e\u001e \n\u00039I1!a\u0010\u000e\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0011\u0002F\t\u00191+Z9\u000b\u0007\u0005}R\u0002\u0003\u0004g\u0003S\u0001\rA\u0012\u0005\t\u0003\u0017\u0002A\u0011\u0001\u0002\u0002N\u0005\u0001r-\u001a;UCN\\Gj\\2l\u0007>,h\u000e\u001e\u000b\u0005\u0003\u001f\n)\u0006E\u0002\r\u0003#J1!a\u0015\u000e\u0005\rIe\u000e\u001e\u0005\u0007M\u0006%\u0003\u0019\u0001$\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\u0005!1/\u001b>f+\t\ty\u0005\u0003\u0005\u0002`\u0001!\tAAA1\u0003U9W\r\u001e(v[\n,'o\u00144NCB,e\u000e\u001e:jKN,\u0012a\b\u0005\b\u0003K\u0002A\u0011AA4\u0003\u001d)g\u000e\u001e:jKN,\"!!\u001b\u0011\r\u0005E\u00121NA8\u0013\u0011\ti'!\u0012\u0003\u0011%#XM]1u_J\u0004R\u0001DA9Y=J1!a\u001d\u000e\u0005\u0019!V\u000f\u001d7fe!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0014a\u0003:f[>4XM\u00117pG.$2AYA>\u0011\u0019\t\u0018Q\u000fa\u0001Y!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0015!B2mK\u0006\u0014H#\u00012\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005\u001d\u0015\u0001\u00077pG.4uN\u001d*fC\u0012Lgn\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0012\u0016\u0004i\u0006-5FAAG!\u0011\ty)a&\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005aj\u0011\u0002BAM\u0003#\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ti\nAI\u0001\n\u0003\t9)\u0001\rm_\u000e\\gi\u001c:Xe&$\u0018N\\4%I\u00164\u0017-\u001e7uIIB\u0011\"!)\u0001#\u0003%\t!a)\u0002!UtGn\\2lI\u0011,g-Y;mi\u0012\u0012TCAASU\u0011\tY\"a#")
public class BlockInfoManager
implements Logging {
    @GuardedBy(value="this")
    private final HashMap<BlockId, BlockInfo> infos;
    @GuardedBy(value="this")
    private final HashMap<Object, Set<BlockId>> writeLocksByTask;
    @GuardedBy(value="this")
    private final HashMap<Object, ConcurrentHashMultiset<BlockId>> readLocksByTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public synchronized void registerTask(long taskAttemptId) {
        Predef$.MODULE$.require(!this.readLocksByTask.contains((Object)BoxesRunTime.boxToLong((long)taskAttemptId)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Task attempt ").append(taskAttemptId).append(" is already registered").toString());
        this.readLocksByTask.update((Object)BoxesRunTime.boxToLong((long)taskAttemptId), (Object)ConcurrentHashMultiset.create());
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BlockInfo$.MODULE$.NON_TASK_WRITER()));
    }

    public synchronized Option<BlockInfo> lockForReading(BlockId blockId, boolean blocking) {
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Task ").append(this.currentTaskAttemptId()).append(" trying to acquire read lock for ").append(blockId).toString());
        do {
            Option option;
            if (None$.MODULE$.equals(option = this.infos.get((Object)blockId))) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                BlockInfo info = (BlockInfo)some.value();
                if (info.writerTask() == BlockInfo$.MODULE$.NO_WRITER()) {
                    info.readerCount_$eq(info.readerCount() + 1);
                    ((ConcurrentHashMultiset)this.readLocksByTask.apply((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()))).add((Object)blockId);
                    this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(this.currentTaskAttemptId()).append(" acquired read lock for ").append(blockId).toString());
                    return new Some((Object)info);
                }
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            if (!blocking) continue;
            this.wait();
        } while (blocking);
        return None$.MODULE$;
    }

    public boolean lockForReading$default$2() {
        return true;
    }

    public synchronized Option<BlockInfo> lockForWriting(BlockId blockId, boolean blocking) {
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Task ").append(this.currentTaskAttemptId()).append(" trying to acquire write lock for ").append(blockId).toString());
        do {
            Option option;
            if (None$.MODULE$.equals(option = this.infos.get((Object)blockId))) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                BlockInfo info = (BlockInfo)some.value();
                if (info.writerTask() == BlockInfo$.MODULE$.NO_WRITER() && info.readerCount() == 0) {
                    info.writerTask_$eq(this.currentTaskAttemptId());
                    ((MultiMap)this.writeLocksByTask).addBinding((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Object)blockId);
                    this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Task ").append(this.currentTaskAttemptId()).append(" acquired write lock for ").append(blockId).toString());
                    return new Some((Object)info);
                }
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            if (!blocking) continue;
            this.wait();
        } while (blocking);
        return None$.MODULE$;
    }

    public boolean lockForWriting$default$2() {
        return true;
    }

    public synchronized BlockInfo assertBlockIsLockedForWriting(BlockId blockId) {
        BlockInfo info;
        Option option = this.infos.get((Object)blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            info = (BlockInfo)some.value();
            if (info.writerTask() != this.currentTaskAttemptId()) {
                throw new SparkException(new StringBuilder(39).append("Task ").append(this.currentTaskAttemptId()).append(" has not locked block ").append(blockId).append(" for writing").toString());
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new SparkException(new StringBuilder(21).append("Block ").append(blockId).append(" does not exist").toString());
            }
            throw new MatchError((Object)option);
        }
        BlockInfo blockInfo = info;
        return blockInfo;
    }

    public synchronized Option<BlockInfo> get(BlockId blockId) {
        return this.infos.get((Object)blockId);
    }

    public synchronized void downgradeLock(BlockId blockId) {
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Task ").append(this.currentTaskAttemptId()).append(" downgrading write lock for ").append(blockId).toString());
        BlockInfo info = (BlockInfo)this.get(blockId).get();
        Predef$.MODULE$.require(info.writerTask() == this.currentTaskAttemptId(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Task ").append(this.currentTaskAttemptId()).append(" tried to downgrade a write lock that it does not hold on").append(new StringBuilder(7).append(" block ").append(blockId).toString()).toString());
        this.unlock(blockId, this.unlock$default$2());
        Option<BlockInfo> lockOutcome = this.lockForReading(blockId, false);
        Predef$.MODULE$.assert(lockOutcome.isDefined());
    }

    public synchronized void unlock(BlockId blockId, Option<Object> taskAttemptId) {
        MultiMap multiMap;
        long taskId = BoxesRunTime.unboxToLong((Object)taskAttemptId.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.currentTaskAttemptId()));
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Task ").append(taskId).append(" releasing lock for ").append(blockId).toString());
        BlockInfo info = (BlockInfo)this.get(blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(16).append("Block ").append(blockId).append(" not found").toString());
        });
        if (info.writerTask() != BlockInfo$.MODULE$.NO_WRITER()) {
            info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
            multiMap = ((MultiMap)this.writeLocksByTask).removeBinding((Object)BoxesRunTime.boxToLong((long)taskId), (Object)blockId);
        } else {
            Predef$.MODULE$.assert(info.readerCount() > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Block ").append(blockId).append(" is not locked for reading").toString());
            info.readerCount_$eq(info.readerCount() - 1);
            ConcurrentHashMultiset countsForTask = (ConcurrentHashMultiset)this.readLocksByTask.apply((Object)BoxesRunTime.boxToLong((long)taskId));
            int newPinCountForTask = countsForTask.remove((Object)blockId, 1) - 1;
            Predef$.MODULE$.assert(newPinCountForTask >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Task ").append(taskId).append(" release lock on block ").append(blockId).append(" more times than it acquired it").toString());
            multiMap = BoxedUnit.UNIT;
        }
        this.notifyAll();
    }

    public Option<Object> unlock$default$2() {
        return None$.MODULE$;
    }

    public synchronized boolean lockNewBlockForWriting(BlockId blockId, BlockInfo newBlockInfo) {
        boolean bl;
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Task ").append(this.currentTaskAttemptId()).append(" trying to put ").append(blockId).toString());
        Option<BlockInfo> option = this.lockForReading(blockId, this.lockForReading$default$2());
        if (option instanceof Some) {
            bl = false;
        } else if (None$.MODULE$.equals(option)) {
            this.infos.update((Object)blockId, (Object)newBlockInfo);
            this.lockForWriting(blockId, this.lockForWriting$default$2());
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Seq<BlockId> releaseAllLocksForTask(long taskAttemptId) {
        void var3_2;
        ArrayBuffer blocksWithReleasedLocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Multiset readLocks = (Multiset)this.readLocksByTask.remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableMultiset.of());
        Iterable writeLocks = (Iterable)this.writeLocksByTask.remove((Object)BoxesRunTime.boxToLong((long)taskAttemptId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
        writeLocks.foreach((Function1 & Serializable & scala.Serializable)blockId -> {
            $this.infos.get(blockId).foreach((Function1 & Serializable & scala.Serializable)info -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$4(taskAttemptId, info);
                return BoxedUnit.UNIT;
            });
            return blocksWithReleasedLocks.$plus$eq(blockId);
        });
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(readLocks.entrySet().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            BlockInfoManager.$anonfun$releaseAllLocksForTask$5(this, blocksWithReleasedLocks, entry);
            return BoxedUnit.UNIT;
        });
        this.notifyAll();
        return var3_2;
    }

    public int getTaskLockCount(long taskAttemptId) {
        return BoxesRunTime.unboxToInt((Object)this.readLocksByTask.get((Object)BoxesRunTime.boxToLong((long)taskAttemptId)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)this.writeLocksByTask.get((Object)BoxesRunTime.boxToLong((long)taskAttemptId)).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public synchronized int size() {
        return this.infos.size();
    }

    public synchronized long getNumberOfMapEntries() {
        return this.size() + this.readLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.readLocksByTask.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$1(x$4)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.writeLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.writeLocksByTask.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$2(x$5)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public synchronized Iterator<Tuple2<BlockId, BlockInfo>> entries() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.infos.toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).toIterator();
    }

    public synchronized void removeBlock(BlockId blockId) {
        BlockInfo blockInfo;
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Task ").append(this.currentTaskAttemptId()).append(" trying to remove block ").append(blockId).toString());
        Option option = this.infos.get((Object)blockId);
        if (option instanceof Some) {
            Some some = (Some)option;
            blockInfo = (BlockInfo)some.value();
            if (blockInfo.writerTask() != this.currentTaskAttemptId()) {
                throw new IllegalStateException(new StringBuilder(52).append("Task ").append(this.currentTaskAttemptId()).append(" called remove() on block ").append(blockId).append(" without a write lock").toString());
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(44).append("Task ").append(this.currentTaskAttemptId()).append(" called remove() on non-existent block ").append(blockId).toString());
            }
            throw new MatchError((Object)option);
        }
        this.infos.remove((Object)blockId);
        blockInfo.readerCount_$eq(0);
        blockInfo.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        HashMap hashMap = (HashMap)((MultiMap)this.writeLocksByTask).removeBinding((Object)BoxesRunTime.boxToLong((long)this.currentTaskAttemptId()), (Object)blockId);
        this.notifyAll();
    }

    public synchronized void clear() {
        this.infos.valuesIterator().foreach((Function1 & Serializable & scala.Serializable)blockInfo -> {
            BlockInfoManager.$anonfun$clear$1(blockInfo);
            return BoxedUnit.UNIT;
        });
        this.infos.clear();
        this.readLocksByTask.clear();
        this.writeLocksByTask.clear();
        this.notifyAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$4(long taskAttemptId$2, BlockInfo info) {
        Predef$.MODULE$.assert(info.writerTask() == taskAttemptId$2);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$6(int lockCount$1, BlockInfo info) {
        info.readerCount_$eq(info.readerCount() - lockCount$1);
        Predef$.MODULE$.assert(info.readerCount() >= 0);
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$5(BlockInfoManager $this, ArrayBuffer blocksWithReleasedLocks$1, Multiset.Entry entry) {
        BlockId blockId = (BlockId)entry.getElement();
        int lockCount = entry.getCount();
        blocksWithReleasedLocks$1.$plus$eq((Object)blockId);
        $this.get(blockId).foreach((Function1 & Serializable & scala.Serializable)info -> {
            BlockInfoManager.$anonfun$releaseAllLocksForTask$6(lockCount, info);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$1(Tuple2 x$4) {
        return ((ConcurrentHashMultiset)x$4._2()).size();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$2(Tuple2 x$5) {
        return ((TraversableOnce)x$5._2()).size();
    }

    public static final /* synthetic */ void $anonfun$clear$1(BlockInfo blockInfo) {
        blockInfo.readerCount_$eq(0);
        blockInfo.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
    }

    public BlockInfoManager() {
        Logging.$init$(this);
        this.infos = new HashMap();
        this.writeLocksByTask = new MultiMap<Object, BlockId>(null){

            public Set<BlockId> makeSet() {
                return MultiMap.makeSet$((MultiMap)this);
            }

            public MultiMap addBinding(Object key, Object value) {
                return MultiMap.addBinding$((MultiMap)this, (Object)key, (Object)value);
            }

            public MultiMap removeBinding(Object key, Object value) {
                return MultiMap.removeBinding$((MultiMap)this, (Object)key, (Object)value);
            }

            public boolean entryExists(Object key, Function1 p) {
                return MultiMap.entryExists$((MultiMap)this, (Object)key, (Function1)p);
            }
            {
                MultiMap.$init$((MultiMap)this);
            }
        };
        this.readLocksByTask = new HashMap();
        this.registerTask(BlockInfo$.MODULE$.NON_TASK_WRITER());
    }
}

