/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.FIFOSchedulingAlgorithm;
import org.apache.spark.scheduler.FairSchedulingAlgorithm;
import org.apache.spark.scheduler.Schedulable;
import org.apache.spark.scheduler.SchedulingAlgorithm;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.scheduler.TaskSetManager;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005-f!B\u0001\u0003\u0001\u0011Q!\u0001\u0002)p_2T!a\u0001\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\t\u0001Y\u0011#\u0006\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u0019R\"\u0001\u0002\n\u0005Q\u0011!aC*dQ\u0016$W\u000f\\1cY\u0016\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0003\u0002\u0011%tG/\u001a:oC2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BC\u0002\u0013\u0005a$\u0001\u0005q_>dg*Y7f\u0007\u0001)\u0012a\b\t\u0003A\u001dr!!I\u0013\u0011\u0005\tjQ\"A\u0012\u000b\u0005\u0011j\u0012A\u0002\u001fs_>$h(\u0003\u0002'\u001b\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t1S\u0002\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003 \u0003%\u0001xn\u001c7OC6,\u0007\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001/\u00039\u00198\r[3ek2LgnZ'pI\u0016,\u0012a\f\t\u0003amr!!M\u001d\u000f\u0005IBdBA\u001a8\u001d\t!dG\u0004\u0002#k%\t\u0011\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I!A\u000f\u0002\u0002\u001dM\u001b\u0007.\u001a3vY&tw-T8eK&\u0011A(\u0010\u0002\u000f'\u000eDW\rZ;mS:<Wj\u001c3f\u0015\tQ$\u0001\u0003\u0005@\u0001\t\u0005\t\u0015!\u00030\u0003=\u00198\r[3ek2LgnZ'pI\u0016\u0004\u0003\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u0019%t\u0017\u000e^'j]NC\u0017M]3\u0011\u00051\u0019\u0015B\u0001#\u000e\u0005\rIe\u000e\u001e\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0005\u0006Q\u0011N\\5u/\u0016Lw\r\u001b;\t\u000b!\u0003A\u0011A%\u0002\rqJg.\u001b;?)\u0015Q5\nT'O!\t\u0011\u0002\u0001C\u0003\u001d\u000f\u0002\u0007q\u0004C\u0003.\u000f\u0002\u0007q\u0006C\u0003B\u000f\u0002\u0007!\tC\u0003G\u000f\u0002\u0007!\tC\u0004Q\u0001\t\u0007I\u0011A)\u0002!M\u001c\u0007.\u001a3vY\u0006\u0014G.Z)vKV,W#\u0001*\u0011\u0007MS\u0016#D\u0001U\u0015\t)f+\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0016-\u0002\tU$\u0018\u000e\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tYFKA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\t\ru\u0003\u0001\u0015!\u0003S\u0003E\u00198\r[3ek2\f'\r\\3Rk\u0016,X\r\t\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0003q\u00198\r[3ek2\f'\r\\3OC6,Gk\\*dQ\u0016$W\u000f\\1cY\u0016,\u0012!\u0019\t\u0005'\n|\u0012#\u0003\u0002d)\n\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\t\r\u0015\u0004\u0001\u0015!\u0003b\u0003u\u00198\r[3ek2\f'\r\\3OC6,Gk\\*dQ\u0016$W\u000f\\1cY\u0016\u0004\u0003bB4\u0001\u0005\u0004%\t\u0001[\u0001\u0007o\u0016Lw\r\u001b;\u0016\u0003\tCaA\u001b\u0001!\u0002\u0013\u0011\u0015aB<fS\u001eDG\u000f\t\u0005\bY\u0002\u0011\r\u0011\"\u0001i\u0003!i\u0017N\\*iCJ,\u0007B\u00028\u0001A\u0003%!)A\u0005nS:\u001c\u0006.\u0019:fA!9\u0001\u000f\u0001a\u0001\n\u0003A\u0017\u0001\u0004:v]:Lgn\u001a+bg.\u001c\bb\u0002:\u0001\u0001\u0004%\ta]\u0001\u0011eVtg.\u001b8h)\u0006\u001c8n]0%KF$\"\u0001^<\u0011\u00051)\u0018B\u0001<\u000e\u0005\u0011)f.\u001b;\t\u000fa\f\u0018\u0011!a\u0001\u0005\u0006\u0019\u0001\u0010J\u0019\t\ri\u0004\u0001\u0015)\u0003C\u00035\u0011XO\u001c8j]\u001e$\u0016m]6tA!9A\u0010\u0001b\u0001\n\u0003A\u0017\u0001\u00039sS>\u0014\u0018\u000e^=\t\ry\u0004\u0001\u0015!\u0003C\u0003%\u0001(/[8sSRL\b\u0005\u0003\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0001i\u0003\u001d\u0019H/Y4f\u0013\u0012D\u0011\"!\u0002\u0001\u0001\u0004%\t!a\u0002\u0002\u0017M$\u0018mZ3JI~#S-\u001d\u000b\u0004i\u0006%\u0001\u0002\u0003=\u0002\u0004\u0005\u0005\t\u0019\u0001\"\t\u000f\u00055\u0001\u0001)Q\u0005\u0005\u0006A1\u000f^1hK&#\u0007\u0005\u0003\u0005\u0002\u0012\u0001\u0011\r\u0011\"\u0001\u001f\u0003\u0011q\u0017-\\3\t\u000f\u0005U\u0001\u0001)A\u0005?\u0005)a.Y7fA!I\u0011\u0011\u0004\u0001A\u0002\u0013\u0005\u00111D\u0001\u0007a\u0006\u0014XM\u001c;\u0016\u0003)C\u0011\"a\b\u0001\u0001\u0004%\t!!\t\u0002\u0015A\f'/\u001a8u?\u0012*\u0017\u000fF\u0002u\u0003GA\u0001\u0002_A\u000f\u0003\u0003\u0005\rA\u0013\u0005\b\u0003O\u0001\u0001\u0015)\u0003K\u0003\u001d\u0001\u0018M]3oi\u0002B\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\u00025Q\f7o[*fiN\u001b\u0007.\u001a3vY&tw-\u00117h_JLG\u000f[7\u0016\u0005\u0005=\u0002c\u0001\n\u00022%\u0019\u00111\u0007\u0002\u0003'M\u001b\u0007.\u001a3vY&tw-\u00117h_JLG\u000f[7\t\u0011\u0005]\u0002\u0001)A\u0005\u0003_\t1\u0004^1tWN+GoU2iK\u0012,H.\u001b8h\u00032<wN]5uQ6\u0004\u0003bBA\u001e\u0001\u0011\u0005\u0013QH\u0001\u000fC\u0012$7k\u00195fIVd\u0017M\u00197f)\r!\u0018q\b\u0005\b\u0003\u0003\nI\u00041\u0001\u0012\u0003-\u00198\r[3ek2\f'\r\\3\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u0005\t\"/Z7pm\u0016\u001c6\r[3ek2\f'\r\\3\u0015\u0007Q\fI\u0005C\u0004\u0002B\u0005\r\u0003\u0019A\t\t\u000f\u00055\u0003\u0001\"\u0011\u0002P\u0005!r-\u001a;TG\",G-\u001e7bE2,')\u001f(b[\u0016$2!EA)\u0011\u001d\t\u0019&a\u0013A\u0002}\tqb]2iK\u0012,H.\u00192mK:\u000bW.\u001a\u0005\b\u0003/\u0002A\u0011IA-\u00031)\u00070Z2vi>\u0014Hj\\:u)\u001d!\u00181LA0\u0003GBq!!\u0018\u0002V\u0001\u0007q$\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012Dq!!\u0019\u0002V\u0001\u0007q$\u0001\u0003i_N$\b\u0002CA3\u0003+\u0002\r!a\u001a\u0002\rI,\u0017m]8o!\r\u0011\u0012\u0011N\u0005\u0004\u0003W\u0012!AE#yK\u000e,Ho\u001c:M_N\u001c(+Z1t_:Dq!a\u001c\u0001\t\u0003\n\t(\u0001\fdQ\u0016\u001c7n\u00159fGVd\u0017\r^1cY\u0016$\u0016m]6t)\u0011\t\u0019(!\u001f\u0011\u00071\t)(C\u0002\u0002x5\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002|\u00055\u0004\u0019\u0001\"\u0002)5Lg\u000eV5nKR{7\u000b]3dk2\fG/[8o\u0011\u001d\ty\b\u0001C!\u0003\u0003\u000bQcZ3u'>\u0014H/\u001a3UCN\\7+\u001a;Rk\u0016,X-\u0006\u0002\u0002\u0004B1\u0011QQAH\u0003'k!!a\"\u000b\t\u0005%\u00151R\u0001\b[V$\u0018M\u00197f\u0015\r\ti)D\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAI\u0003\u000f\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0019!#!&\n\u0007\u0005]%A\u0001\bUCN\\7+\u001a;NC:\fw-\u001a:\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\u0006!\u0012N\\2sK\u0006\u001cXMU;o]&tw\rV1tWN$2\u0001^AP\u0011\u001d\t\t+!'A\u0002\t\u000bq\u0001^1tW:+X\u000eC\u0004\u0002&\u0002!\t!a*\u0002)\u0011,7M]3bg\u0016\u0014VO\u001c8j]\u001e$\u0016m]6t)\r!\u0018\u0011\u0016\u0005\b\u0003C\u000b\u0019\u000b1\u0001C\u0001")
public class Pool
implements Schedulable,
Logging {
    private final String poolName;
    private final Enumeration.Value schedulingMode;
    private final ConcurrentLinkedQueue<Schedulable> schedulableQueue;
    private final ConcurrentHashMap<String, Schedulable> schedulableNameToSchedulable;
    private final int weight;
    private final int minShare;
    private int runningTasks;
    private final int priority;
    private int stageId;
    private final String name;
    private Pool parent;
    private final SchedulingAlgorithm taskSetSchedulingAlgorithm;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String poolName() {
        return this.poolName;
    }

    @Override
    public Enumeration.Value schedulingMode() {
        return this.schedulingMode;
    }

    @Override
    public ConcurrentLinkedQueue<Schedulable> schedulableQueue() {
        return this.schedulableQueue;
    }

    public ConcurrentHashMap<String, Schedulable> schedulableNameToSchedulable() {
        return this.schedulableNameToSchedulable;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    @Override
    public int minShare() {
        return this.minShare;
    }

    @Override
    public int runningTasks() {
        return this.runningTasks;
    }

    public void runningTasks_$eq(int x$1) {
        this.runningTasks = x$1;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public int stageId() {
        return this.stageId;
    }

    public void stageId_$eq(int x$1) {
        this.stageId = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Pool parent() {
        return this.parent;
    }

    @Override
    public void parent_$eq(Pool x$1) {
        this.parent = x$1;
    }

    private SchedulingAlgorithm taskSetSchedulingAlgorithm() {
        return this.taskSetSchedulingAlgorithm;
    }

    @Override
    public void addSchedulable(Schedulable schedulable) {
        Predef$.MODULE$.require(schedulable != null);
        this.schedulableQueue().add(schedulable);
        this.schedulableNameToSchedulable().put(schedulable.name(), schedulable);
        schedulable.parent_$eq(this);
    }

    @Override
    public void removeSchedulable(Schedulable schedulable) {
        this.schedulableQueue().remove(schedulable);
        this.schedulableNameToSchedulable().remove(schedulable.name());
    }

    @Override
    public Schedulable getSchedulableByName(String schedulableName) {
        Schedulable schedulable2;
        Object object = new Object();
        try {
            if (this.schedulableNameToSchedulable().containsKey(schedulableName)) {
                return this.schedulableNameToSchedulable().get(schedulableName);
            }
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)schedulable -> {
                Pool.$anonfun$getSchedulableByName$1(schedulableName, object, schedulable);
                return BoxedUnit.UNIT;
            });
            schedulable2 = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                schedulable2 = (Schedulable)ex.value();
            }
            throw ex;
        }
        return schedulable2;
    }

    @Override
    public void executorLost(String executorId, String host, ExecutorLossReason reason) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.executorLost(executorId, host, reason);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean checkSpeculatableTasks(int minTimeToSpeculation) {
        BooleanRef shouldRevive = BooleanRef.create((boolean)false);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).foreach((Function1 & Serializable & scala.Serializable)schedulable -> {
            Pool.$anonfun$checkSpeculatableTasks$1(minTimeToSpeculation, shouldRevive, schedulable);
            return BoxedUnit.UNIT;
        });
        return shouldRevive.elem;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayBuffer<TaskSetManager> getSortedTaskSetQueue() {
        void var1_1;
        ArrayBuffer sortedTaskSetQueue = new ArrayBuffer();
        Seq sortedSchedulableQueue = (Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.schedulableQueue()).asScala()).toSeq().sortWith((Function2 & Serializable & scala.Serializable)(s1, s2) -> BoxesRunTime.boxToBoolean((boolean)Pool.$anonfun$getSortedTaskSetQueue$1(this, s1, s2)));
        sortedSchedulableQueue.foreach((Function1 & Serializable & scala.Serializable)schedulable -> sortedTaskSetQueue.$plus$plus$eq(schedulable.getSortedTaskSetQueue()));
        return var1_1;
    }

    public void increaseRunningTasks(int taskNum) {
        block0: {
            this.runningTasks_$eq(this.runningTasks() + taskNum);
            if (this.parent() == null) break block0;
            this.parent().increaseRunningTasks(taskNum);
        }
    }

    public void decreaseRunningTasks(int taskNum) {
        block0: {
            this.runningTasks_$eq(this.runningTasks() - taskNum);
            if (this.parent() == null) break block0;
            this.parent().decreaseRunningTasks(taskNum);
        }
    }

    public static final /* synthetic */ void $anonfun$getSchedulableByName$1(String schedulableName$1, Object nonLocalReturnKey1$1, Schedulable schedulable) {
        Schedulable sched = schedulable.getSchedulableByName(schedulableName$1);
        if (sched != null) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)sched);
        }
    }

    public static final /* synthetic */ void $anonfun$checkSpeculatableTasks$1(int minTimeToSpeculation$1, BooleanRef shouldRevive$1, Schedulable schedulable) {
        shouldRevive$1.elem |= schedulable.checkSpeculatableTasks(minTimeToSpeculation$1);
    }

    public static final /* synthetic */ boolean $anonfun$getSortedTaskSetQueue$1(Pool $this, Schedulable s1, Schedulable s2) {
        return $this.taskSetSchedulingAlgorithm().comparator(s1, s2);
    }

    public Pool(String poolName, Enumeration.Value schedulingMode, int initMinShare, int initWeight) {
        SchedulingAlgorithm schedulingAlgorithm;
        this.poolName = poolName;
        this.schedulingMode = schedulingMode;
        Logging.$init$(this);
        this.schedulableQueue = new ConcurrentLinkedQueue();
        this.schedulableNameToSchedulable = new ConcurrentHashMap();
        this.weight = initWeight;
        this.minShare = initMinShare;
        this.runningTasks = 0;
        this.priority = 0;
        this.stageId = -1;
        this.name = poolName;
        this.parent = null;
        Enumeration.Value value = schedulingMode;
        Enumeration.Value value2 = SchedulingMode$.MODULE$.FAIR();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            schedulingAlgorithm = new FairSchedulingAlgorithm();
        } else {
            Enumeration.Value value4 = SchedulingMode$.MODULE$.FIFO();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                schedulingAlgorithm = new FIFOSchedulingAlgorithm();
            } else {
                String msg = new StringBuilder(56).append("Unsupported scheduling mode: ").append(schedulingMode).append(". Use FAIR or FIFO instead.").toString();
                throw new IllegalArgumentException(msg);
            }
        }
        this.taskSetSchedulingAlgorithm = schedulingAlgorithm;
    }
}

