/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.spark.scheduler.HighlyCompressedMapStatus$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.util.Utils$;
import org.roaringbitmap.RoaringBitmap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\u0001\u0003\u0001\u0011Q!!\u0007%jO\"d\u0017pQ8naJ,7o]3e\u001b\u0006\u00048\u000b^1ukNT!a\u0001\u0003\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0014\t\u0001Y\u0011#\u0006\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u0019R\"\u0001\u0002\n\u0005Q\u0011!!C'baN#\u0018\r^;t!\t12$D\u0001\u0018\u0015\tA\u0012$\u0001\u0002j_*\t!$\u0001\u0003kCZ\f\u0017B\u0001\u000f\u0018\u00059)\u0005\u0010^3s]\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0002\u0003\u0006K\u0001I\u0001\u0004Y>\u001c7\u0001\u0001\t\u0003C\u0011j\u0011A\t\u0006\u0003G\u0011\tqa\u001d;pe\u0006<W-\u0003\u0002&E\tq!\t\\8dW6\u000bg.Y4fe&#\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0015\u0002#9,XNT8o\u000b6\u0004H/\u001f\"m_\u000e\\7\u000f\u0005\u0002\rS%\u0011!&\u0004\u0002\u0004\u0013:$\b\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0015B\u0017\u0002\u0017\u0015l\u0007\u000f^=CY>\u001c7n\u001d\t\u0003]Ej\u0011a\f\u0006\u0003a!\tQB]8be&twMY5u[\u0006\u0004\u0018B\u0001\u001a0\u00055\u0011v.\u0019:j]\u001e\u0014\u0015\u000e^7ba\"AA\u0007\u0001B\u0001B\u0003&Q'A\u0004bm\u001e\u001c\u0016N_3\u0011\u000511\u0014BA\u001c\u000e\u0005\u0011auN\\4\t\u0011e\u0002!\u00111A\u0005\ni\na\u0002[;hK\ncwnY6TSj,7/F\u0001<!\u0011a4\t\u000b$\u000f\u0005u\n\u0005C\u0001 \u000e\u001b\u0005y$B\u0001! \u0003\u0019a$o\\8u}%\u0011!)D\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%aA'ba*\u0011!)\u0004\t\u0003\u0019\u001dK!\u0001S\u0007\u0003\t\tKH/\u001a\u0005\t\u0015\u0002\u0011\t\u0019!C\u0005\u0017\u0006\u0011\u0002.^4f\u00052|7m[*ju\u0016\u001cx\fJ3r)\tau\n\u0005\u0002\r\u001b&\u0011a*\u0004\u0002\u0005+:LG\u000fC\u0004Q\u0013\u0006\u0005\t\u0019A\u001e\u0002\u0007a$\u0013\u0007\u0003\u0005S\u0001\t\u0005\t\u0015)\u0003<\u0003=AWoZ3CY>\u001c7nU5{KN\u0004\u0003\"\u0002+\u0001\t\u0013)\u0016A\u0002\u001fj]&$h\b\u0006\u0004W/bK&l\u0017\t\u0003%\u0001AQAH*A\u0002\u0001BQaJ*A\u0002!BQ\u0001L*A\u00025BQ\u0001N*A\u0002UBQ!O*A\u0002mBQ\u0001\u0016\u0001\u0005\u0012u#\u0012A\u0016\u0005\u0006?\u0002!\t\u0005Y\u0001\tY>\u001c\u0017\r^5p]V\t\u0001\u0005C\u0003c\u0001\u0011\u00053-A\bhKR\u001c\u0016N_3G_J\u0014En\\2l)\t)D\rC\u0003fC\u0002\u0007\u0001&\u0001\u0005sK\u0012,8-Z%e\u0011\u00159\u0007\u0001\"\u0011i\u000359(/\u001b;f\u000bb$XM\u001d8bYR\u0011A*\u001b\u0005\u0006U\u001a\u0004\ra[\u0001\u0004_V$\bC\u0001\fm\u0013\tiwC\u0001\u0007PE*,7\r^(viB,H\u000fC\u0003p\u0001\u0011\u0005\u0003/\u0001\u0007sK\u0006$W\t\u001f;fe:\fG\u000e\u0006\u0002Mc\")!O\u001ca\u0001g\u0006\u0011\u0011N\u001c\t\u0003-QL!!^\f\u0003\u0017=\u0013'.Z2u\u0013:\u0004X\u000f^\u0004\u0007o\nA\t\u0001\u0002=\u00023!Kw\r\u001b7z\u0007>l\u0007O]3tg\u0016$W*\u00199Ti\u0006$Xo\u001d\t\u0003%e4a!\u0001\u0002\t\u0002\u0011Q8cA=\fwB\u0011A\u0002`\u0005\u0003{6\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001V=\u0005\u0002}$\u0012\u0001\u001f\u0005\b\u0003\u0007IH\u0011AA\u0003\u0003\u0015\t\u0007\u000f\u001d7z)\u00151\u0016qAA\u0005\u0011\u0019q\u0012\u0011\u0001a\u0001A!A\u00111BA\u0001\u0001\u0004\ti!A\tv]\u000e|W\u000e\u001d:fgN,GmU5{KN\u0004B\u0001DA\bk%\u0019\u0011\u0011C\u0007\u0003\u000b\u0005\u0013(/Y=\t\u0013\u0005U\u00110!A\u0005\n\u0005]\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b\u001a\u0003\u0011a\u0017M\\4\n\t\u0005\r\u0012Q\u0004\u0002\u0007\u001f\nTWm\u0019;")
public class HighlyCompressedMapStatus
implements MapStatus,
Externalizable {
    private BlockManagerId loc;
    private RoaringBitmap emptyBlocks;
    private long avgSize;
    private Map<Object, Object> hugeBlockSizes;

    public static HighlyCompressedMapStatus apply(BlockManagerId blockManagerId, long[] lArray) {
        return HighlyCompressedMapStatus$.MODULE$.apply(blockManagerId, lArray);
    }

    private Map<Object, Object> hugeBlockSizes() {
        return this.hugeBlockSizes;
    }

    private void hugeBlockSizes_$eq(Map<Object, Object> x$1) {
        this.hugeBlockSizes = x$1;
    }

    @Override
    public BlockManagerId location() {
        return this.loc;
    }

    @Override
    public long getSizeForBlock(int reduceId) {
        long l;
        Predef$.MODULE$.assert(this.hugeBlockSizes() != null);
        if (this.emptyBlocks.contains(reduceId)) {
            l = 0L;
        } else {
            long l2;
            Option option = this.hugeBlockSizes().get((Object)BoxesRunTime.boxToInteger((int)reduceId));
            if (option instanceof Some) {
                Some some = (Some)option;
                byte size = BoxesRunTime.unboxToByte((Object)some.value());
                l2 = MapStatus$.MODULE$.decompressSize(size);
            } else if (None$.MODULE$.equals(option)) {
                l2 = this.avgSize;
            } else {
                throw new MatchError((Object)option);
            }
            l = l2;
        }
        return l;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.loc.writeExternal(out);
            $this.emptyBlocks.writeExternal(out);
            out.writeLong($this.avgSize);
            out.writeInt(this.hugeBlockSizes().size());
            this.hugeBlockSizes().foreach((Function1 & Serializable & scala.Serializable)kv -> {
                HighlyCompressedMapStatus.$anonfun$writeExternal$3(out, kv);
                return BoxedUnit.UNIT;
            });
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.loc = BlockManagerId$.MODULE$.apply(in);
            $this.emptyBlocks = new RoaringBitmap();
            $this.emptyBlocks.readExternal(in);
            $this.avgSize = in.readLong();
            int count = in.readInt();
            ArrayBuffer hugeBlockSizesArray = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1 & Serializable & scala.Serializable)x$2 -> HighlyCompressedMapStatus.$anonfun$readExternal$3(in, hugeBlockSizesArray, BoxesRunTime.unboxToInt((Object)x$2)));
            this.hugeBlockSizes_$eq((Map<Object, Object>)hugeBlockSizesArray.toMap(Predef$.MODULE$.$conforms()));
        });
    }

    public static final /* synthetic */ void $anonfun$writeExternal$3(ObjectOutput out$2, Tuple2 kv) {
        out$2.writeInt(kv._1$mcI$sp());
        out$2.writeByte(BoxesRunTime.unboxToByte((Object)kv._2()));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$readExternal$3(ObjectInput in$2, ArrayBuffer hugeBlockSizesArray$1, int x$2) {
        int block = in$2.readInt();
        byte size = in$2.readByte();
        return hugeBlockSizesArray$1.$plus$eq((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)block), (Object)BoxesRunTime.boxToByte((byte)size)));
    }

    public HighlyCompressedMapStatus(BlockManagerId loc, int numNonEmptyBlocks, RoaringBitmap emptyBlocks, long avgSize, Map<Object, Object> hugeBlockSizes) {
        this.loc = loc;
        this.emptyBlocks = emptyBlocks;
        this.avgSize = avgSize;
        this.hugeBlockSizes = hugeBlockSizes;
        Predef$.MODULE$.require(loc == null || avgSize > 0L || this.hugeBlockSizes().size() > 0 || numNonEmptyBlocks == 0, (Function0 & Serializable & scala.Serializable)() -> "Average size can only be zero for map stages that produced no output");
    }

    public HighlyCompressedMapStatus() {
        this(null, -1, null, -1L, null);
    }
}

