/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.Serializable;
import org.apache.spark.Dependency;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.BlockRDDPartition;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManager$;
import org.apache.spark.storage.BlockResult;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\u0001\u0003\u0001\u0011Q!\u0001\u0003\"m_\u000e\\'\u000b\u0012#\u000b\u0005\r!\u0011a\u0001:eI*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014x-\u0006\u0002\f%M\u0011\u0001\u0001\u0004\t\u0004\u001b9\u0001R\"\u0001\u0002\n\u0005=\u0011!a\u0001*E\tB\u0011\u0011C\u0005\u0007\u0001\t\u0015\u0019\u0002A1\u0001\u0016\u0005\u0005!6\u0001A\t\u0003-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011qAT8uQ&tw\r\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\u0004\u0003:L\b\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u0005M\u001c\u0007C\u0001\u0012$\u001b\u0005!\u0011B\u0001\u0013\u0005\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!1\u0003A!b\u0001\n\u00039\u0013\u0001\u00032m_\u000e\\\u0017\nZ:\u0016\u0003!\u00022aF\u0015,\u0013\tQ\u0003DA\u0003BeJ\f\u0017\u0010\u0005\u0002-_5\tQF\u0003\u0002/\t\u000591\u000f^8sC\u001e,\u0017B\u0001\u0019.\u0005\u001d\u0011En\\2l\u0013\u0012D\u0001B\r\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\nE2|7m[%eg\u0002B#!\r\u001b\u0011\u0005])\u0014B\u0001\u001c\u0019\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u00059\u0001\t\r\t\u0015a\u0003:\u0003))g/\u001b3f]\u000e,G%\r\t\u0004uu\u0002R\"A\u001e\u000b\u0005qB\u0012a\u0002:fM2,7\r^\u0005\u0003}m\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006\u0001\u0002!\t!Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t+e\t\u0006\u0002D\tB\u0019Q\u0002\u0001\t\t\u000baz\u00049A\u001d\t\u000b\u0001z\u0004\u0019A\u0011\t\u000b\u0019z\u0004\u0019\u0001\u0015\t\u0011!\u0003\u0001R1A\u0005\u0002%\u000b!b\u00187pG\u0006$\u0018n\u001c8t+\u0005Q\u0005\u0003B&SWUs!\u0001\u0014)\u0011\u00055CR\"\u0001(\u000b\u0005=#\u0012A\u0002\u001fs_>$h(\u0003\u0002R1\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\u00075\u000b\u0007O\u0003\u0002R1A\u0019ak\u00170\u000f\u0005]KfBA'Y\u0013\u0005I\u0012B\u0001.\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0007M+\u0017O\u0003\u0002[1A\u00111jX\u0005\u0003AR\u0013aa\u0015;sS:<\u0007FA$5\u0011\u001d\u0019\u0007\u00011A\u0005\n\u0011\f\u0001bX5t-\u0006d\u0017\u000eZ\u000b\u0002KB\u0011qCZ\u0005\u0003Ob\u0011qAQ8pY\u0016\fg\u000eC\u0004j\u0001\u0001\u0007I\u0011\u00026\u0002\u0019}K7OV1mS\u0012|F%Z9\u0015\u0005-t\u0007CA\fm\u0013\ti\u0007D\u0001\u0003V]&$\bbB8i\u0003\u0003\u0005\r!Z\u0001\u0004q\u0012\n\u0004BB9\u0001A\u0003&Q-A\u0005`SN4\u0016\r\\5eA!\u0012\u0001o\u001d\t\u0003/QL!!\u001e\r\u0003\u0011Y|G.\u0019;jY\u0016DQa\u001e\u0001\u0005Ba\fQbZ3u!\u0006\u0014H/\u001b;j_:\u001cX#A=\u0011\u0007]I#\u0010\u0005\u0002#w&\u0011A\u0010\u0002\u0002\n!\u0006\u0014H/\u001b;j_:DQA \u0001\u0005B}\fqaY8naV$X\r\u0006\u0004\u0002\u0002\u0005\u001d\u00111\u0002\t\u0005-\u0006\r\u0001#C\u0002\u0002\u0006u\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u0007\u0003\u0013i\b\u0019\u0001>\u0002\u000bM\u0004H.\u001b;\t\u000f\u00055Q\u00101\u0001\u0002\u0010\u000591m\u001c8uKb$\bc\u0001\u0012\u0002\u0012%\u0019\u00111\u0003\u0003\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\b\u0003/\u0001A\u0011IA\r\u0003U9W\r\u001e)sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N$2!VA\u000e\u0011\u001d\tI!!\u0006A\u0002iD\u0001\"a\b\u0001\t\u0003!\u0011\u0011E\u0001\re\u0016lwN^3CY>\u001c7n\u001d\u000b\u0002W\"9\u0011Q\u0005\u0001\u0005\u0002\u0011!\u0017aB5t-\u0006d\u0017\u000e\u001a\u0005\t\u0003S\u0001A\u0011\u0001\u0003\u0002\"\u0005Y\u0011m]:feR4\u0016\r\\5e\u0011\u001d\ti\u0003\u0001C\t\u0003_\t1cZ3u\u00052|7m[%e\u0019>\u001c\u0017\r^5p]N$\u0012A\u0013")
public class BlockRDD<T>
extends RDD<T> {
    private transient Map<BlockId, Seq<String>> _locations;
    private final transient BlockId[] blockIds;
    private final ClassTag<T> evidence$1;
    private volatile boolean _isValid;
    private volatile transient boolean bitmap$trans$0;

    public BlockId[] blockIds() {
        return this.blockIds;
    }

    private Map<BlockId, Seq<String>> _locations$lzycompute() {
        BlockRDD blockRDD = this;
        synchronized (blockRDD) {
            if (!this.bitmap$trans$0) {
                this._locations = BlockManager$.MODULE$.blockIdsToLocations(this.blockIds(), SparkEnv$.MODULE$.get(), BlockManager$.MODULE$.blockIdsToLocations$default$3());
                this.bitmap$trans$0 = true;
            }
        }
        return this._locations;
    }

    public Map<BlockId, Seq<String>> _locations() {
        return !this.bitmap$trans$0 ? this._locations$lzycompute() : this._locations;
    }

    private boolean _isValid() {
        return this._isValid;
    }

    private void _isValid_$eq(boolean x$1) {
        this._isValid = x$1;
    }

    @Override
    public Partition[] getPartitions() {
        this.assertValid();
        return (Partition[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.blockIds().length).map((Function1 & Serializable & scala.Serializable)i -> BlockRDD.$anonfun$getPartitions$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    @Override
    public Iterator<T> compute(Partition split, TaskContext context) {
        this.assertValid();
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        BlockId blockId = ((BlockRDDPartition)split).blockId();
        Option<BlockResult> option = blockManager.get(blockId, this.evidence$1);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringBuilder(49).append("Could not compute split, block ").append(blockId).append(" of RDD ").append(this.id()).append(" not found").toString());
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        BlockResult block = (BlockResult)some.value();
        Iterator<Object> iterator = block.data();
        return iterator;
    }

    @Override
    public Seq<String> getPreferredLocations(Partition split) {
        this.assertValid();
        return (Seq)this._locations().apply((Object)((BlockRDDPartition)split).blockId());
    }

    public void removeBlocks() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.blockIds())).foreach((Function1 & Serializable & scala.Serializable)blockId -> {
            BlockRDD.$anonfun$removeBlocks$1(this, blockId);
            return BoxedUnit.UNIT;
        });
        this._isValid_$eq(false);
    }

    public boolean isValid() {
        return this._isValid();
    }

    public void assertValid() {
        if (!this.isValid()) {
            throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Attempted to use %s after its blocks have been removed!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString()})));
        }
    }

    public Map<BlockId, Seq<String>> getBlockIdLocations() {
        return this._locations();
    }

    public static final /* synthetic */ Partition $anonfun$getPartitions$1(BlockRDD $this, int i) {
        return new BlockRDDPartition($this.blockIds()[i], i);
    }

    public static final /* synthetic */ void $anonfun$removeBlocks$1(BlockRDD $this, BlockId blockId) {
        $this.sparkContext().env().blockManager().master().removeBlock(blockId);
    }

    public BlockRDD(SparkContext sc, BlockId[] blockIds, ClassTag<T> evidence$1) {
        this.blockIds = blockIds;
        this.evidence$1 = evidence$1;
        super(sc, (Seq<Dependency<?>>)Nil$.MODULE$, evidence$1);
        this._isValid = true;
    }
}

