/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.internal.io.HadoopMapRedCommitProtocol;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol;
import org.apache.spark.internal.io.HadoopWriteConfigUtil;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.HadoopRDD$;
import org.apache.spark.util.SerializableJobConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de!B\u0001\u0003\u0001\u0019a!a\u0007%bI>|\u0007/T1q%\u0016$wK]5uK\u000e{gNZ5h+RLGN\u0003\u0002\u0004\t\u0005\u0011\u0011n\u001c\u0006\u0003\u000b\u0019\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0019Q\u0002\u0006\u0012\u0014\u0007\u0001qA\u0005\u0005\u0003\u0010!I\tS\"\u0001\u0002\n\u0005E\u0011!!\u0006%bI>|\u0007o\u0016:ji\u0016\u001cuN\u001c4jOV#\u0018\u000e\u001c\t\u0003'Qa\u0001\u0001B\u0003\u0016\u0001\t\u0007qCA\u0001L\u0007\u0001\t\"\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000f9{G\u000f[5oOB\u0011\u0011dH\u0005\u0003Ai\u00111!\u00118z!\t\u0019\"\u0005B\u0003$\u0001\t\u0007qCA\u0001W!\t)c%D\u0001\u0005\u0013\t9CAA\u0004M_\u001e<\u0017N\\4\t\u0011%\u0002!\u0011!Q\u0001\n)\nAaY8oMB\u00111FL\u0007\u0002Y)\u0011QFB\u0001\u0005kRLG.\u0003\u00020Y\t\u00192+\u001a:jC2L'0\u00192mK*{'mQ8oM\"A\u0011\u0007\u0001B\u0002B\u0003-!'\u0001\u0006fm&$WM\\2fIM\u00022a\r\u001c\"\u001b\u0005!$BA\u001b\u001b\u0003\u001d\u0011XM\u001a7fGRL!a\u000e\u001b\u0003\u0011\rc\u0017m]:UC\u001eDQ!\u000f\u0001\u0005\u0002i\na\u0001P5oSRtDCA\u001e?)\taT\b\u0005\u0003\u0010\u0001I\t\u0003\"B\u00199\u0001\b\u0011\u0004\"B\u00159\u0001\u0004Q\u0003b\u0002!\u0001\u0001\u0004%I!Q\u0001\r_V$\b/\u001e;G_Jl\u0017\r^\u000b\u0002\u0005B\u00121i\u0014\t\u0004\t.seBA#J!\t1%$D\u0001H\u0015\tAe#\u0001\u0004=e>|GOP\u0005\u0003\u0015j\ta\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0015\u0019E.Y:t\u0015\tQ%\u0004\u0005\u0002\u0014\u001f\u0012I\u0001+UA\u0001\u0002\u0003\u0015\ta\u0015\u0002\u0004?\u0012\n\u0004B\u0002*\u0001A\u0003&!)A\u0007pkR\u0004X\u000f\u001e$pe6\fG\u000fI\t\u00031Q\u0003B!\u0016.\u0013C5\taK\u0003\u0002X1\u00061Q.\u00199sK\u0012T!!\u0017\u0005\u0002\r!\fGm\\8q\u0013\tYfK\u0001\u0007PkR\u0004X\u000f\u001e$pe6\fG\u000fC\u0004^\u0001\u0001\u0007I\u0011\u00020\u0002!=,H\u000f];u\r>\u0014X.\u0019;`I\u0015\fHCA0c!\tI\u0002-\u0003\u0002b5\t!QK\\5u\u0011\u001d\u0019G,!AA\u0002\u0011\f1\u0001\u001f\u00132a\t)w\rE\u0002E\u0017\u001a\u0004\"aE4\u0005\u0013A\u0013\u0017\u0011!A\u0001\u0006\u0003\u0019\u0006bB5\u0001\u0001\u0004%IA[\u0001\u0007oJLG/\u001a:\u0016\u0003-\u0004B!\u00167\u0013C%\u0011QN\u0016\u0002\r%\u0016\u001cwN\u001d3Xe&$XM\u001d\u0005\b_\u0002\u0001\r\u0011\"\u0003q\u0003)9(/\u001b;fe~#S-\u001d\u000b\u0003?FDqa\u00198\u0002\u0002\u0003\u00071\u000e\u0003\u0004t\u0001\u0001\u0006Ka[\u0001\boJLG/\u001a:!\u0011\u0015)\b\u0001\"\u0003w\u0003\u001d9W\r^\"p]\u001a,\u0012a\u001e\t\u0003+bL!!\u001f,\u0003\u000f){'mQ8oM\")1\u0010\u0001C!y\u0006\u00012M]3bi\u0016TuNY\"p]R,\u0007\u0010\u001e\u000b\u0006{\u0006\u001d\u0011\u0011\u0003\t\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005\u0001,A\u0005nCB\u0014X\rZ;dK&\u0019\u0011QA@\u0003\u0015){'mQ8oi\u0016DH\u000fC\u0004\u0002\ni\u0004\r!a\u0003\u0002\u0019)|'\r\u0016:bG.,'/\u00133\u0011\u0007\u0011\u000bi!C\u0002\u0002\u00105\u0013aa\u0015;sS:<\u0007bBA\nu\u0002\u0007\u0011QC\u0001\u0006U>\u0014\u0017\n\u001a\t\u00043\u0005]\u0011bAA\r5\t\u0019\u0011J\u001c;\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 \u0005A2M]3bi\u0016$\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0015\u0015\u0005\u0005\u0012qEA\u0015\u0003W\ty\u0003E\u0002\u007f\u0003GI1!!\n\u0000\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\t\u0011\u0005%\u00111\u0004a\u0001\u0003\u0017A\u0001\"a\u0005\u0002\u001c\u0001\u0007\u0011Q\u0003\u0005\t\u0003[\tY\u00021\u0001\u0002\u0016\u000591\u000f\u001d7ji&#\u0007\u0002CA\u0019\u00037\u0001\r!!\u0006\u0002\u001bQ\f7o[!ui\u0016l\u0007\u000f^%e\u0011\u001d\t)\u0004\u0001C!\u0003o\tqb\u0019:fCR,7i\\7nSR$XM\u001d\u000b\u0005\u0003s\ty\u0004E\u0002\u0010\u0003wI1!!\u0010\u0003\u0005uA\u0015\rZ8pa6\u000b\u0007OU3ek\u000e,7i\\7nSR\u0004&o\u001c;pG>d\u0007\u0002CA\n\u0003g\u0001\r!!\u0006\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F\u0005Q\u0011N\\5u/JLG/\u001a:\u0015\u000b}\u000b9%a\u0013\t\u0011\u0005%\u0013\u0011\ta\u0001\u0003C\t1\u0002^1tW\u000e{g\u000e^3yi\"A\u0011QFA!\u0001\u0004\t)\u0002C\u0004\u0002P\u0001!\t%!\u0015\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007}\u000b\u0019\u0006\u0003\u0005\u0002V\u00055\u0003\u0019AA,\u0003\u0011\u0001\u0018-\u001b:\u0011\u000be\tIFE\u0011\n\u0007\u0005m#D\u0001\u0004UkBdWM\r\u0005\b\u0003?\u0002A\u0011IA1\u0003-\u0019Gn\\:f/JLG/\u001a:\u0015\u0007}\u000b\u0019\u0007\u0003\u0005\u0002J\u0005u\u0003\u0019AA\u0011\u0011\u001d\t9\u0007\u0001C!\u0003S\n\u0001#\u001b8ji>+H\u000f];u\r>\u0014X.\u0019;\u0015\u0007}\u000bY\u0007C\u0004\u0002n\u0005\u0015\u0004\u0019A?\u0002\u0015)|'mQ8oi\u0016DH\u000fC\u0004\u0002r\u0001!I!a\u001d\u0002\u001f\u001d,GoT;uaV$hi\u001c:nCR$\u0012\u0001\u0016\u0005\b\u0003o\u0002A\u0011IA=\u0003)\t7o]3si\u000e{gN\u001a\u000b\u0006?\u0006m\u0014Q\u0010\u0005\b\u0003[\n)\b1\u0001~\u0011\u001dI\u0013Q\u000fa\u0001\u0003\u007f\u0002B!!!\u0002\u00046\ta!C\u0002\u0002\u0006\u001a\u0011\u0011b\u00159be.\u001cuN\u001c4")
public class HadoopMapRedWriteConfigUtil<K, V>
extends HadoopWriteConfigUtil<K, V>
implements Logging {
    private final SerializableJobConf conf;
    private Class<? extends OutputFormat<K, V>> outputFormat;
    private RecordWriter<K, V> writer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Class<? extends OutputFormat<K, V>> outputFormat() {
        return this.outputFormat;
    }

    private void outputFormat_$eq(Class<? extends OutputFormat<K, V>> x$1) {
        this.outputFormat = x$1;
    }

    private RecordWriter<K, V> writer() {
        return this.writer;
    }

    private void writer_$eq(RecordWriter<K, V> x$1) {
        this.writer = x$1;
    }

    private JobConf getConf() {
        return this.conf.value();
    }

    @Override
    public JobContext createJobContext(String jobTrackerId, int jobId) {
        SerializableWritable<JobID> jobAttemptId = new SerializableWritable<JobID>(new JobID(jobTrackerId, jobId));
        return new JobContextImpl(this.getConf(), (org.apache.hadoop.mapreduce.JobID)jobAttemptId.value());
    }

    @Override
    public TaskAttemptContext createTaskAttemptContext(String jobTrackerId, int jobId, int splitId, int taskAttemptId) {
        HadoopRDD$.MODULE$.addLocalConfiguration(jobTrackerId, jobId, splitId, taskAttemptId, this.conf.value());
        TaskAttemptID attemptId = new TaskAttemptID(jobTrackerId, jobId, TaskType.MAP, splitId, taskAttemptId);
        return new TaskAttemptContextImpl(this.getConf(), attemptId);
    }

    @Override
    public HadoopMapReduceCommitProtocol createCommitter(int jobId) {
        HadoopRDD$.MODULE$.addLocalConfiguration("", 0, 0, 0, this.getConf());
        return (HadoopMapReduceCommitProtocol)FileCommitProtocol$.MODULE$.instantiate(HadoopMapRedCommitProtocol.class.getName(), ((Object)BoxesRunTime.boxToInteger((int)jobId)).toString(), this.getConf().get("mapred.output.dir"), FileCommitProtocol$.MODULE$.instantiate$default$4());
    }

    @Override
    public void initWriter(TaskAttemptContext taskContext, int splitId) {
        NumberFormat numfmt = NumberFormat.getInstance(Locale.US);
        numfmt.setMinimumIntegerDigits(5);
        numfmt.setGroupingUsed(false);
        String outputName = new StringBuilder(5).append("part-").append(numfmt.format(splitId)).toString();
        Path path = FileOutputFormat.getOutputPath((JobConf)this.getConf());
        FileSystem fs = path != null ? path.getFileSystem((Configuration)this.getConf()) : FileSystem.get((Configuration)this.getConf());
        this.writer_$eq(this.getConf().getOutputFormat().getRecordWriter(fs, this.getConf(), outputName, (Progressable)Reporter.NULL));
        Predef$.MODULE$.require(this.writer() != null, (Function0 & Serializable & scala.Serializable)() -> "Unable to obtain RecordWriter");
    }

    @Override
    public void write(Tuple2<K, V> pair) {
        Predef$.MODULE$.require(this.writer() != null, (Function0 & Serializable & scala.Serializable)() -> "Must call createWriter before write.");
        this.writer().write(pair._1(), pair._2());
    }

    @Override
    public void closeWriter(TaskAttemptContext taskContext) {
        block0: {
            if (this.writer() == null) break block0;
            this.writer().close(Reporter.NULL);
        }
    }

    @Override
    public void initOutputFormat(JobContext jobContext) {
        block0: {
            if (this.outputFormat() != null) break block0;
            this.outputFormat_$eq(this.getConf().getOutputFormat().getClass());
        }
    }

    private OutputFormat<K, V> getOutputFormat() {
        Predef$.MODULE$.require(this.outputFormat() != null, (Function0 & Serializable & scala.Serializable)() -> "Must call initOutputFormat first.");
        return this.outputFormat().newInstance();
    }

    @Override
    public void assertConf(JobContext jobContext, SparkConf conf) {
        block3: {
            OutputFormat<K, V> outputFormatInstance = this.getOutputFormat();
            Class keyClass = this.getConf().getOutputKeyClass();
            Class valueClass = this.getConf().getOutputValueClass();
            if (outputFormatInstance == null) {
                throw new SparkException("Output format class not set");
            }
            if (keyClass == null) {
                throw new SparkException("Output key class not set");
            }
            if (valueClass == null) {
                throw new SparkException("Output value class not set");
            }
            SparkHadoopUtil$.MODULE$.get().addCredentials(this.getConf());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Saving as hadoop file of type (").append(keyClass.getSimpleName()).append(", ").append(valueClass.getSimpleName()).append(")").toString());
            if (!SparkHadoopWriterUtils$.MODULE$.isOutputSpecValidationEnabled(conf)) break block3;
            FileSystem ignoredFs = FileSystem.get((Configuration)this.getConf());
            this.getOutputFormat().checkOutputSpecs(ignoredFs, this.getConf());
        }
    }

    public HadoopMapRedWriteConfigUtil(SerializableJobConf conf, ClassTag<V> evidence$3) {
        this.conf = conf;
        super(evidence$3);
        Logging.$init$(this);
        this.outputFormat = null;
        this.writer = null;
    }
}

