/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.ExternalShuffleService$;
import org.apache.spark.deploy.ExternalShuffleServiceSource;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.metrics.MetricsSystem;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.shuffle.ExternalShuffleBlockHandler;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf!B\u0001\u0003\u0001\tQ!AF#yi\u0016\u0014h.\u00197TQV4g\r\\3TKJ4\u0018nY3\u000b\u0005\r!\u0011A\u00023fa2|\u0017P\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h'\r\u00011\"\u0005\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I)R\"A\n\u000b\u0005Q!\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005Y\u0019\"a\u0002'pO\u001eLgn\u001a\u0005\t1\u0001\u0011\t\u0011)A\u00055\u0005I1\u000f]1sW\u000e{gNZ\u0002\u0001!\tYB$D\u0001\u0005\u0013\tiBAA\u0005Ta\u0006\u00148nQ8oM\"Aq\u0004\u0001B\u0001B\u0003%\u0001%A\btK\u000e,(/\u001b;z\u001b\u0006t\u0017mZ3s!\tY\u0012%\u0003\u0002#\t\ty1+Z2ve&$\u00180T1oC\u001e,'\u000fC\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0004M!J\u0003CA\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\r$\u0001\u0004Q\u0002\"B\u0010$\u0001\u0004\u0001\u0003bB\u0016\u0001\u0005\u0004%\t\u0002L\u0001\u0014[\u0006\u001cH/\u001a:NKR\u0014\u0018nY:TsN$X-\\\u000b\u0002[A\u0011a&M\u0007\u0002_)\u0011\u0001\u0007B\u0001\b[\u0016$(/[2t\u0013\t\u0011tFA\u0007NKR\u0014\u0018nY:TsN$X-\u001c\u0005\u0007i\u0001\u0001\u000b\u0011B\u0017\u0002)5\f7\u000f^3s\u001b\u0016$(/[2t'f\u001cH/Z7!\u0011\u001d1\u0004A1A\u0005\n]\nq!\u001a8bE2,G-F\u00019!\ta\u0011(\u0003\u0002;\u001b\t9!i\\8mK\u0006t\u0007B\u0002\u001f\u0001A\u0003%\u0001(\u0001\u0005f]\u0006\u0014G.\u001a3!\u0011\u001dq\u0004A1A\u0005\n}\nA\u0001]8siV\t\u0001\t\u0005\u0002\r\u0003&\u0011!)\u0004\u0002\u0004\u0013:$\bB\u0002#\u0001A\u0003%\u0001)A\u0003q_J$\b\u0005C\u0004G\u0001\t\u0007I\u0011B$\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g+\u0005A\u0005CA%O\u001b\u0005Q%BA&M\u0003\u0011)H/\u001b7\u000b\u00055#\u0011a\u00028fi^|'o[\u0005\u0003\u001f*\u0013Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0007BB)\u0001A\u0003%\u0001*\u0001\bue\u0006t7\u000f]8si\u000e{gN\u001a\u0011\t\u000fM\u0003!\u0019!C\u0005)\u0006a!\r\\8dW\"\u000bg\u000e\u001a7feV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002Y\u0019\u000691\u000f[;gM2,\u0017B\u0001.X\u0005m)\u0005\u0010^3s]\u0006d7\u000b[;gM2,'\t\\8dW\"\u000bg\u000e\u001a7fe\"1A\f\u0001Q\u0001\nU\u000bQB\u00197pG.D\u0015M\u001c3mKJ\u0004\u0003b\u00020\u0001\u0005\u0004%IaX\u0001\u0011iJ\fgn\u001d9peR\u001cuN\u001c;fqR,\u0012\u0001\u0019\t\u0003C\nl\u0011\u0001T\u0005\u0003G2\u0013\u0001\u0003\u0016:b]N\u0004xN\u001d;D_:$X\r\u001f;\t\r\u0015\u0004\u0001\u0015!\u0003a\u0003E!(/\u00198ta>\u0014HoQ8oi\u0016DH\u000f\t\u0005\nO\u0002\u0001\r\u00111A\u0005\n!\faa]3sm\u0016\u0014X#A5\u0011\u0005)dW\"A6\u000b\u0005\u001dd\u0015BA7l\u0005=!&/\u00198ta>\u0014HoU3sm\u0016\u0014\b\"C8\u0001\u0001\u0004\u0005\r\u0011\"\u0003q\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0003cR\u0004\"\u0001\u0004:\n\u0005Ml!\u0001B+oSRDq!\u001e8\u0002\u0002\u0003\u0007\u0011.A\u0002yIEB\u0011b\u001e\u0001A\u0002\u0003\u0005\u000b\u0015B5\u0002\u000fM,'O^3sA!9\u0011\u0010\u0001b\u0001\n\u0013Q\u0018\u0001F:ik\u001a4G.Z*feZL7-Z*pkJ\u001cW-F\u0001|!\t9C0\u0003\u0002~\u0005\taR\t\u001f;fe:\fGn\u00155vM\u001adWmU3sm&\u001cWmU8ve\u000e,\u0007BB@\u0001A\u0003%10A\u000btQV4g\r\\3TKJ4\u0018nY3T_V\u00148-\u001a\u0011\t\u000f\u0005\r\u0001\u0001\"\u0005\u0002\u0006\u00051b.Z<TQV4g\r\\3CY>\u001c7\u000eS1oI2,'\u000fF\u0002V\u0003\u000fAq!!\u0003\u0002\u0002\u0001\u0007\u0001*\u0001\u0003d_:4\u0007bBA\u0007\u0001\u0011\u0005\u0011qB\u0001\u000fgR\f'\u000f^%g\u000b:\f'\r\\3e)\u0005\t\bbBA\n\u0001\u0011\u0005\u0011qB\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0003/\u0001A\u0011AA\r\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8SK6|g/\u001a3\u0015\u0007E\fY\u0002\u0003\u0005\u0002\u001e\u0005U\u0001\u0019AA\u0010\u0003\u0015\t\u0007\u000f]%e!\u0011\t\t#a\f\u000f\t\u0005\r\u00121\u0006\t\u0004\u0003KiQBAA\u0014\u0015\r\tI#G\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055R\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\t\u0019D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[i\u0001bBA\u001c\u0001\u0011\u0005\u0011\u0011H\u0001\u0010Kb,7-\u001e;peJ+Wn\u001c<fIR)\u0011/a\u000f\u0002@!A\u0011QHA\u001b\u0001\u0004\ty\"\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012D\u0001\"!\b\u00026\u0001\u0007\u0011q\u0004\u0005\b\u0003\u0007\u0002A\u0011AA\b\u0003\u0011\u0019Ho\u001c9\b\u000f\u0005\u001d#\u0001#\u0001\u0002J\u00051R\t\u001f;fe:\fGn\u00155vM\u001adWmU3sm&\u001cW\rE\u0002(\u0003\u00172a!\u0001\u0002\t\u0002\u000553\u0003BA&\u0017EAq\u0001JA&\t\u0003\t\t\u0006\u0006\u0002\u0002J!Yq-a\u0013A\u0002\u0003\u0007I\u0011BA++\u00051\u0003bC8\u0002L\u0001\u0007\t\u0019!C\u0005\u00033\"2!]A.\u0011!)\u0018qKA\u0001\u0002\u00041\u0003BC<\u0002L\u0001\u0007\t\u0011)Q\u0005M!\"\u0011QLA1!\ra\u00111M\u0005\u0004\u0003Kj!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0015\u0005%\u00141\nb\u0001\n\u0013\tY'A\u0004cCJ\u0014\u0018.\u001a:\u0016\u0005\u00055\u0004\u0003BA8\u0003wj!!!\u001d\u000b\t\u0005M\u0014QO\u0001\u000bG>t7-\u001e:sK:$(bA&\u0002x)\u0011\u0011\u0011P\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002~\u0005E$AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\n\u0003\u0003\u000bY\u0005)A\u0005\u0003[\n\u0001BY1se&,'\u000f\t\u0005\t\u0003\u000b\u000bY\u0005\"\u0001\u0002\b\u0006!Q.Y5o)\r\t\u0018\u0011\u0012\u0005\t\u0003\u0017\u000b\u0019\t1\u0001\u0002\u000e\u0006!\u0011M]4t!\u0015a\u0011qRA\u0010\u0013\r\t\t*\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\n\u0003\u000b\u000bY\u0005\"\u0001\u0005\u0003+#R!]AL\u00033C\u0001\"a#\u0002\u0014\u0002\u0007\u0011Q\u0012\u0005\t\u00037\u000b\u0019\n1\u0001\u0002\u001e\u0006\tb.Z<TQV4g\r\\3TKJ4\u0018nY3\u0011\r1\tyJ\u0007\u0011'\u0013\r\t\t+\u0004\u0002\n\rVt7\r^5p]J\u0002")
public class ExternalShuffleService
implements Logging {
    private final SecurityManager securityManager;
    private final MetricsSystem masterMetricsSystem;
    private final boolean enabled;
    private final int port;
    private final TransportConf transportConf;
    private final ExternalShuffleBlockHandler blockHandler;
    private final TransportContext transportContext;
    private TransportServer server;
    private final ExternalShuffleServiceSource shuffleServiceSource;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        ExternalShuffleService$.MODULE$.main(stringArray);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public MetricsSystem masterMetricsSystem() {
        return this.masterMetricsSystem;
    }

    private boolean enabled() {
        return this.enabled;
    }

    private int port() {
        return this.port;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    private ExternalShuffleBlockHandler blockHandler() {
        return this.blockHandler;
    }

    private TransportContext transportContext() {
        return this.transportContext;
    }

    private TransportServer server() {
        return this.server;
    }

    private void server_$eq(TransportServer x$1) {
        this.server = x$1;
    }

    private ExternalShuffleServiceSource shuffleServiceSource() {
        return this.shuffleServiceSource;
    }

    public ExternalShuffleBlockHandler newShuffleBlockHandler(TransportConf conf) {
        return new ExternalShuffleBlockHandler(conf, null);
    }

    public void startIfEnabled() {
        block0: {
            if (!this.enabled()) break block0;
            this.start();
        }
    }

    public void start() {
        Predef$.MODULE$.require(this.server() == null, (Function0 & Serializable & scala.Serializable)() -> "Shuffle server already started");
        boolean authEnabled = this.securityManager.isAuthenticationEnabled();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Starting shuffle service on port ").append(this.port()).append(" (auth enabled = ").append(authEnabled).append(")").toString());
        Nil$ bootstraps = authEnabled ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AuthServerBootstrap[]{new AuthServerBootstrap(this.transportConf(), (SecretKeyHolder)this.securityManager)})) : Nil$.MODULE$;
        this.server_$eq(this.transportContext().createServer(this.port(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bootstraps).asJava()));
        this.shuffleServiceSource().registerMetricSet(this.server().getAllMetrics());
        this.shuffleServiceSource().registerMetricSet(this.blockHandler().getAllMetrics());
        this.masterMetricsSystem().registerSource(this.shuffleServiceSource());
        this.masterMetricsSystem().start();
    }

    public void applicationRemoved(String appId) {
        this.blockHandler().applicationRemoved(appId, true);
    }

    public void executorRemoved(String executorId, String appId) {
        this.blockHandler().executorRemoved(executorId, appId);
    }

    public void stop() {
        block0: {
            if (this.server() == null) break block0;
            this.server().close();
            this.server_$eq(null);
        }
    }

    public ExternalShuffleService(SparkConf sparkConf, SecurityManager securityManager) {
        this.securityManager = securityManager;
        Logging.$init$(this);
        this.masterMetricsSystem = MetricsSystem$.MODULE$.createMetricsSystem("shuffleService", sparkConf, securityManager);
        this.enabled = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_ENABLED()));
        this.port = BoxesRunTime.unboxToInt((Object)sparkConf.get(package$.MODULE$.SHUFFLE_SERVICE_PORT()));
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(sparkConf, "shuffle", 0);
        this.blockHandler = this.newShuffleBlockHandler(this.transportConf());
        this.transportContext = new TransportContext(this.transportConf(), (RpcHandler)this.blockHandler(), true);
        this.shuffleServiceSource = new ExternalShuffleServiceSource();
    }
}

