package util.notifiers;

import com.google.gson.Gson;

import models.contacts.Person;
import play.Logger;
import play.Play;
import play.libs.WS;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 * Created by Leonidas on 30/04/2015.
 */
public class MailgunMailer {
    private static final WS.WSRequest mailgunAPImessages = WS.url("https://api.mailgun.net/v3/syndromi.gr/messages").authenticate("api", "key-64aa4df92b7c407efdf076116a5f51e3");

    private static WS.WSRequest getApiRequest(Long id) {
        if (Play.mode.isProd()) {
            return WS.url("https://api.mailgun.net/v3/u" + id + ".userlists.syndromi.gr/messages").authenticate("api", "key-64aa4df92b7c407efdf076116a5f51e3");

        } else {
            return WS.url("https://api.mailgun.net/v3/i" + id + ".userlists.syndromi.gr/messages").authenticate("api", "key-64aa4df92b7c407efdf076116a5f51e3");
        }
    }

    private static String getApiRequestEndpoint(Long id) {
        if (Play.mode.isProd()) {
            return "https://api.mailgun.net/v3/u" + id + ".userlists.syndromi.gr/messages";
        } else {
            return "https://api.mailgun.net/v3/i" + id + ".userlists.syndromi.gr/messages";
        }
    }

    public static WS.HttpResponse simpleText(String from, String to, String text, String subject) {
        return simpleTextInner(from, to, text, subject, null, 0L, "leonidas@dimicro.gr", null);
    }

    public static WS.HttpResponse simpleText(String from, Set<Person> receipients, String text, String subject, Long messageId, String replyTo, Long userId) {
        List<String> to;
        if(receipients.size() == 0)
        {
            return simpleTextInner(from, replyTo, text, subject, getReceipientVariables(receipients), messageId, replyTo, userId);
        }
        else {
          to = receipients.stream().filter(receipient -> receipient.contactInfo.email != null && !receipient.contactInfo.email.isEmpty()).map(receipient -> receipient.contactInfo.email).collect(Collectors.toList());
        }
        return simpleTextInner(from, to, text, subject, getReceipientVariables(receipients), messageId, replyTo, userId);
    }

    private static WS.HttpResponse simpleTextInner(String from, Object to, String text, String subject, String receipientVariables, Long messageId, String replyTo, Long userId) {
        Map<String, Object> params = new HashMap<>();
        params.put("from", from);
        params.put("to", to);
        params.put("message", text);
        params.put("text", text);
        params.put("html", text);
        params.put("subject", subject);

        Map<String, Object> idMap = new HashMap<>();
        idMap.put("id", messageId);
        params.put("v:my-custom-data", new Gson().toJson(idMap));
        params.put("h:Reply-To", replyTo);
        params.put("h:Content-Transfer-Encoding", "quoted-printable");
        if (receipientVariables != null) {
            params.put("recipient-variables", receipientVariables);
        }
        if (userId == null) {
            return mailgunAPImessages.params(params).post();
        }

        try {
            Logger.info("Api request url " + getApiRequest(userId).url);
            return getApiRequest(userId)
                    .timeout("5s")
                    .params(params).post();

        } catch (Exception e) {
            Logger.error(e, e.getMessage());
            return null;
        }

    }

    public static WS.HttpResponse notifyMe(String text, String subject) {
        if (Play.mode.equals(Play.Mode.DEV)) {
            Logger.info(text + " has registered in Dev Mode");
            return null;
        } else {
            return simpleText("Syndromi <test@testteam.syndromi.gr>", "leonidas@dimicro.gr", text, subject);
        }
    }


    public static String getReceipientVariables(Iterable<Person> persons) {
        Map<String, Object> result = new HashMap<>();
        for (Person person : persons) {
            Map<String, String> innerParams = new HashMap<>();
            innerParams.put("id", person.id.toString());
            result.put(person.contactInfo.email, innerParams);
        }
        return new Gson().toJson(result);
    }

}
