package util.notifiers;

import com.amazonaws.util.json.JSONException;
import com.amazonaws.util.json.JSONObject;
import play.Logger;
import play.Play;
import play.libs.WS;

import java.util.HashMap;
import java.util.Map;

public class MailgunDomainRegistration {

    private static final WS.WSRequest MAILGUN_DOMAIN_API = WS.url("https://api.mailgun.net/v3/domains").authenticate("api", "key-64aa4df92b7c407efdf076116a5f51e3");
    private static final String WEBHOOK_URL_DEV = "http://www.wildkeyboard.com:9000/Unsecure/webhook";
    private static final String WEBHOOK_URL_PROD = "https://www.syndromi.gr/Unsecure/webhook";
    private static final String[] WEBHOOKEVENTS = {"bounce", "click", "deliver", "drop", "spam", "unsubscribe", "open"};


    public static WS.HttpResponse addDomain(String subdomain) {

        Map<String, Object> params = new HashMap<>();
        params.put("name", subdomain + ".userlists.syndromi.gr");

        WS.HttpResponse post = MAILGUN_DOMAIN_API.params(params).post();
        if (!post.success()) {
            Logger.error(post.getString());
            Logger.error(post.getStatusText());
//            throw new RuntimeException("Mailgun domain creation failed");
        }
        return post;
    }

    public static void setAllWebhooks(String subdomain) {
        for (String webhookevent : WEBHOOKEVENTS) {
            setWebhook(subdomain, webhookevent);
        }
    }

    public static WS.HttpResponse setWebhook(String subdomain, String event) {
        Map<String, Object> params = new HashMap<>();
        params.put("id", event);
        if (Play.mode.isProd()) {
            params.put("url", WEBHOOK_URL_PROD);
        }else{
            params.put("url", WEBHOOK_URL_DEV);

        }

        return WS.url("https://api.mailgun.net/v3/domains/" + subdomain + ".userlists.syndromi.gr/webhooks")
                .authenticate("api", "key-64aa4df92b7c407efdf076116a5f51e3")
                .params(params)
                .post();
    }

    public static WS.HttpResponse verifyDomain(String subdomain) {
        return WS.url("https://api.mailgun.net/v3/domains/" + subdomain + ".userlists.syndromi.gr/verify")
                .authenticate("api", "key-64aa4df92b7c407efdf076116a5f51e3")
                .put();
    }


    public static boolean checkDomain(String subdomain) {
        verifyDomain(subdomain);

        String url = "https://api.mailgun.net/v3/domains/" + subdomain + ".userlists.syndromi.gr";
        Logger.info(url);
        WS.HttpResponse httpResponse = WS.url(url)
                .authenticate("api", "key-64aa4df92b7c407efdf076116a5f51e3")
                .get();
        String responseString = httpResponse.getString();
        Logger.info("response: \n"+ responseString);
        if (!httpResponse.success()) {
            Logger.error("Domain check request failed " + httpResponse.getStatusText());
            return false;
        }

        try {
            JSONObject jsonObject = new JSONObject(responseString);
            JSONObject domain = (JSONObject) jsonObject.get("domain");
            Logger.info(domain.toString());
        String state = (String) domain.get("state");
        return "active".equals(state);
        } catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }


}
