package util.notifiers;

import models.AppUser;
import models.EmailMessage;
import org.joda.time.DateTime;

import java.util.List;


public class MailAccounting {
    private AppUser user;

    public MailAccounting(AppUser user) {
        this.user = user;
    }

    public Integer sentEmails(DateTime from, DateTime to){
        Integer result =0;
        List<EmailMessage> emailMessages = EmailMessage.find("select em from EmailMessage em where em.appUser=:appUser and em.dateSent is not null and em.dateSent>:from and em.dateSent<:to")
                .setParameter("from", from)
                .setParameter("to", to)
                .setParameter("appUser", user)
                .fetch();
        for (EmailMessage emailMessage : emailMessages) {
            result+=emailMessage.receipients.size();
        }
        return result;
    }

    public Integer sentEmails(){
        DateTime startOfMonth = new DateTime().withDayOfMonth(1).withHourOfDay(0).withMinuteOfHour(0).withSecondOfMinute(0);
        return sentEmails(startOfMonth,new DateTime());
    }
}
