package util;

import controllers.Security;
import models.AppUser;
import models.Document;
import models.Event;
import models.chat.Message;
import org.joda.time.DateTime;
import play.Logger;
import play.db.jpa.JPA;

import javax.persistence.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created with IntelliJ IDEA.
 * User: dom
 * Date: 26/8/2013
 * Time: 1:59 μμ
 * To change this template use File | Settings | File Templates.
 */
public class Utils {

    public static final Pattern VALID_EMAIL_ADDRESS_REGEX =
            Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", Pattern.CASE_INSENSITIVE);

    private Utils() {

    }

    public static boolean validate(String emailStr) {
        Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(emailStr);
        return matcher.find();
    }

    public static boolean validateUnique(String email) {
        return AppUser.find("byUserName", email).fetch().isEmpty();
    }



    public static String convertStreamToString(java.io.InputStream is) {
        java.util.Scanner s = new java.util.Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static List<Message> getLatest(Integer seconds){
        Logger.info("Getting messages from last : "+seconds);
        List<Message> result = null;
        return result;

/*
        AppUser usr = AppUser.find("byUsername", Security.connected()).first();
        //TODO get messages ALSO that are not in messageRead for the user!!!!!!!!!!!!!!!!!!!!!!!!!
        Logger.info("after user : ");

       // result = Message.find("select m from Message m where m.id NOT IN (select x.message.id from MessageRead x where  x.contact !=:user) and m.msgSender !=:user")
         //       .setParameter("user", usr).fetch(20);

        Query query = JPA.em().createQuery("select  m from Message m where m.id NOT IN (select x.id from MessageRead x where x.contact !=:user)");
        query.setParameter("user", usr);
        result = query.getResultList();

      //  result = Message.find("select m from Message m where (m.sendDate >=:start and m.sendDate <=:end ) and m.msgSender !=:user")
        //        .setParameter("start", new DateTime().minusSeconds(seconds))
        //        .setParameter("end",new DateTime())
        //        .setParameter("user", usr).fetch(20);


        //result = Message.find("select m from Message m where  m.msgSender !=:user").setParameter("user", usr).fetch(20);
        Logger.info("afterrr : "+seconds);
        return result;
        */
    }

    public static List<Event.JSONEvent> getJSONMessageEvents(List<Message> messageList){
        List<Event.JSONEvent> JSONEventList = new ArrayList<Event.JSONEvent>();
        if(messageList != null) {
            for (Message msg : messageList) {
                JSONEventList.add(msg.getEvent());
            }
        }

        Logger.info("JSONEventList : "+JSONEventList.size());
        return JSONEventList;
    }



}
