package models.contacts;

import com.google.gson.annotations.Expose;
import models.*;
import models.projects.Deliverable;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import play.db.jpa.Model;

import javax.persistence.*;
import java.util.List;

/**
 * Created by dom on 4/12/2018.
 */
@Entity
public class Contact extends Model implements Comparable {

    @Column(insertable = false, updatable = false)
    private String dtype;

    @Searchable
    public String name;

    @Expose
    @Embedded
    public ContactInfo contactInfo = new ContactInfo();

    @OneToMany(mappedBy = "contact", cascade = CascadeType.ALL)
    public List<Document> documents;

    public Document photo;

    @ManyToOne
    public Company company;

    @Expose
    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime createDate;

    @ManyToOne
    public AppUser uploader;


    public Contact() {

    }

    public int compareTo(Object o) {
        if (this.name == null) {
            return 0;
        }
        return this.name.compareTo(((Contact) o).name);
    }


    public boolean isUser()
    {
       return this.getClass().getSimpleName().equals("AppUser");
    }



}
