package models;

import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

import javax.persistence.Embeddable;
import java.io.Serializable;


/**
 * Created by dom on 20/3/2019.
 * There gonna be four distinct roles for this system
 * 1)SYSTEM ADMIN (US)
 * 2)CUSTOMER ADMIN (FULL ACCESS TO THE FUNCTIONS OF THE SYSTEM. EXCEPT GLOBAL SETTINGS)
 * 3)CUSTOMER PLAIN USER (EVERYTHING EXCEPT MAYBE DELETE STUFF)
 * 4)CONTRIBUTOR USERS THAT WILL BE ABLE MAINLY JUST TO VIEW TINGS AND COMMENT
 */
@Embeddable
public class RoleInfo implements Serializable {

    public String roleName;

    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime addToRoleDate;

    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime removeFromRoleDate;


    public RoleInfo() {

    }

    public RoleInfo(String roleName) {
        this.roleName = roleName;
        this.addToRoleDate = new DateTime();
    }
}
