package models;

import org.joda.time.DateTime;

import java.util.Date;

/**
 * Created by dom on 19/3/2019.
 */
public interface Event {
    public DateTime getStartDate();
    public String getTitle();
    public String getCalendarContent();
    public String getUrl();
    public String getUploadedBy();

    public abstract Long getId();


    public class JSONEvent{
        public String className;
        public Date start;
        public String title;
        public String content;
        public String color;
        public String url;
        public String uploadedBy;
        public Boolean allDay=Boolean.FALSE;
        public Long id;

        public JSONEvent(Date start, String title, String content, String color, String url,String uploadedBy, Class parentClass) {
            this.start = start;
            this.title =  title.substring(0,title.length()>80?80:title.length());
            this.content = content;
            this.color = color;
            this.url=url;
            this.uploadedBy = uploadedBy;
            this.className = parentClass.getName().replaceAll("\\.","");
        }

//        public JSONEvent(Date start, String title, String content, String color, String url, Class parentClass, Long id) {
//            this.start = start;
//            this.title =  title.substring(0,title.length()>80?80:title.length());
//            this.content = content;
//            this.color = color;
//            this.url=url;
//            this.className = parentClass.getName().replaceAll("\\.","");
//            this.id=id;
//        }


    }

    public JSONEvent getEvent();
}

