package models;

import com.google.gson.annotations.Expose;
import models.chat.Message;
import models.contacts.Contact;
import models.contacts.Person;
import models.projects.Deliverable;
import models.projects.Lead;
import models.projects.Project;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.db.jpa.Model;
import play.mvc.Router;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by dom on 4/12/2018.
 */
@Entity
public class Document extends Model implements Event {
    public static final String DD_MM_YYYY = "dd-MM-yyyy";
    @Expose
    @Searchable
    public String title;
    @Expose
    @Searchable
    public String description;

    @Embedded
    public CFile cfile;  //not used

    public boolean isCoverPhoto; //The user will be able to choose one image from the project to be the cover photo

    @OneToOne
    public DBFile dbfile;

    @ManyToOne
    public Contact contact; //if its a photo for a a customer

    @ManyToOne
    public Project project; //document of a project

    @ManyToOne
    public Deliverable deliverable; //document of a deliverable

    @ManyToOne
    public Lead lead;

    @ManyToOne
    public Message message;


    @ManyToMany(mappedBy = "sharedDocuments")
    public List<Person> share = new ArrayList<>();


    @Column
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime uploadDate;

    @Expose
    @ManyToOne
    public AppUser uploader;

    public Boolean graphic=Boolean.FALSE;

    public Document() {

    }

    public boolean isSharedWith(Long personId) {
        try {
            Person per = Person.findById(personId);
            return this.share.contains(per);
        } catch (Exception ex) {
            return false;
        }
    }

    public boolean isShared() {
        List<Share> shares = Share.find("select s from Share s where s.document =:doc")
                .setParameter("doc", this).fetch();
        if (shares.size() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public String getDocumentUploadDateString() {
        if (this.uploadDate == null) {
            return "";
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern(DD_MM_YYYY);
        return fmt.print(uploadDate);
    }

    public String getImageDescription()
    {
        if(this.description == null)
        {
            return "";
        }
        else if(this.description.length() > 105) {
            return this.description.substring(0, 105)+" ...";
        }else {
            return this.description;
        }
    }

    public Integer getDocumentsTotalMessages()
    {
        return Message.find("select m from Message m where m.document =:doc").setParameter("doc", this).fetch().size();
    }

    @Override
    public DateTime getStartDate() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getCalendarContent() {
        return null;
    }

    @Override
    public String getUrl() {
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("documentId", this.id);
        return Router.getFullUrl(this.dbfile.fileUrl.toString(), map);
    }

    @Override
    public String getUploadedBy() {
        return this.uploader.getFullName();
    }

    @Override
    public JSONEvent getEvent() {
        return null;
    }

    @Override
    public String toString() {
        return title;
    }
}
