/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import org.hibernate.SessionFactory;
import org.jadira.usertype.spi.shared.AbstractParameterizedUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.ConfigurationHelper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;

public abstract class AbstractParameterizedTemporalUserType<T, J, C extends ColumnMapper<T, J>>
extends AbstractParameterizedUserType<T, J, C> {
    private static final long serialVersionUID = -8038898451426631564L;

    @Override
    public void applyConfiguration(SessionFactory sessionFactory) {
        super.applyConfiguration(sessionFactory);
        this.doApplyConfiguration();
    }

    private <Z> void doApplyConfiguration() {
        Object next;
        if (DatabaseZoneConfigured.class.isAssignableFrom(this.getClass())) {
            next = (DatabaseZoneConfigured)((Object)this);
            this.performDatabaseZoneConfiguration((DatabaseZoneConfigured)next);
        }
        if (JavaZoneConfigured.class.isAssignableFrom(this.getClass())) {
            next = (JavaZoneConfigured)((Object)this);
            this.performJavaZoneConfiguration((JavaZoneConfigured<Z>)next);
        }
        if (DatabaseZoneConfigured.class.isAssignableFrom(this.getColumnMapper().getClass())) {
            next = (DatabaseZoneConfigured)this.getColumnMapper();
            this.performDatabaseZoneConfiguration((DatabaseZoneConfigured)next);
        }
        if (JavaZoneConfigured.class.isAssignableFrom(this.getColumnMapper().getClass())) {
            next = (JavaZoneConfigured)this.getColumnMapper();
            this.performJavaZoneConfiguration((JavaZoneConfigured<Z>)next);
        }
    }

    private <Z> void performDatabaseZoneConfiguration(DatabaseZoneConfigured next) {
        String databaseZone = null;
        if (this.getParameterValues() != null) {
            databaseZone = this.getParameterValues().getProperty("databaseZone");
        }
        if (databaseZone == null) {
            databaseZone = ConfigurationHelper.getProperty("databaseZone");
        }
        if (databaseZone != null) {
            if ("jvm".equals(databaseZone)) {
                next.setDatabaseZone(null);
            } else {
                next.setDatabaseZone(next.parseZone(databaseZone));
            }
        }
    }

    private <Z> void performJavaZoneConfiguration(JavaZoneConfigured<Z> next) {
        String javaZone = null;
        if (this.getParameterValues() != null) {
            javaZone = this.getParameterValues().getProperty("javaZone");
        }
        if (javaZone == null) {
            javaZone = ConfigurationHelper.getProperty("javaZone");
        }
        if (javaZone != null) {
            if ("jvm".equals(javaZone)) {
                next.setJavaZone(null);
            } else {
                next.setJavaZone(next.parseJavaZone(javaZone));
            }
        }
    }
}

