/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.jadira.usertype.spi.shared.ConfigurationHelper;

public abstract class AbstractUserTypeHibernateIntegrator
implements Integrator {
    private static final String REGISTER_USERTYPES_KEY = "jadira.usertype.autoRegisterUserTypes";
    private static final String DEFAULT_JAVAZONE_KEY = "jadira.usertype.javaZone";
    private static final String DEFAULT_DATABASEZONE_KEY = "jadira.usertype.databaseZone";
    private static final String DEFAULT_SEED_KEY = "jadira.usertype.seed";
    private static final String DEFAULT_CURRENCYCODE_KEY = "jadira.usertype.currencyCode";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        try {
            ConfigurationHelper.setCurrentSessionFactory((SessionFactory)sessionFactory);
            String isEnabled = configuration.getProperty(REGISTER_USERTYPES_KEY);
            String javaZone = configuration.getProperty(DEFAULT_JAVAZONE_KEY);
            String databaseZone = configuration.getProperty(DEFAULT_DATABASEZONE_KEY);
            String seed = configuration.getProperty(DEFAULT_SEED_KEY);
            String currencyCode = configuration.getProperty(DEFAULT_CURRENCYCODE_KEY);
            this.configureDefaultProperties(sessionFactory, javaZone, databaseZone, seed, currencyCode);
            if (isEnabled != null && Boolean.valueOf(isEnabled).booleanValue()) {
                this.autoRegisterUsertypes(configuration);
            }
            this.doIntegrate(configuration, sessionFactory, serviceRegistry);
        }
        finally {
            ConfigurationHelper.setCurrentSessionFactory(null);
        }
    }

    private void autoRegisterUsertypes(Configuration configuration) {
        for (UserType userType : this.getUserTypes()) {
            this.registerType(configuration, userType);
        }
        for (UserType userType : this.getCompositeUserTypes()) {
            this.registerType(configuration, (CompositeUserType)userType);
        }
    }

    private void configureDefaultProperties(SessionFactoryImplementor sessionFactory, String javaZone, String databaseZone, String seed, String currencyCode) {
        Properties properties = new Properties();
        if (databaseZone != null) {
            properties.put("databaseZone", databaseZone);
        }
        if (javaZone != null) {
            properties.put("javaZone", javaZone);
        }
        if (seed != null) {
            properties.put("seed", seed);
        }
        if (currencyCode != null) {
            properties.put("currencyCode", currencyCode);
        }
        ConfigurationHelper.configureDefaultProperties((SessionFactory)sessionFactory, properties);
    }

    private void registerType(Configuration configuration, CompositeUserType type) {
        String className = type.returnedClass().getName();
        configuration.registerTypeOverride(type, new String[]{className});
    }

    private void registerType(Configuration configuration, UserType type) {
        String className = type.returnedClass().getName();
        configuration.registerTypeOverride(type, new String[]{className});
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        ConfigurationHelper.configureDefaultProperties((SessionFactory)sessionFactory, null);
    }

    protected abstract CompositeUserType[] getCompositeUserTypes();

    protected abstract UserType[] getUserTypes();

    protected void doIntegrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

