/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.pricing.v1.messaging;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.pricing.v1.messaging.Country;

public class CountryReader
extends Reader<Country> {
    @Override
    public ResourceSet<Country> read(TwilioRestClient client) {
        return new ResourceSet<Country>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Country> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PRICING.toString(), "/v1/Messaging/Countries", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Country> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Country> nextPage(Page<Country> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PRICING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Country> previousPage(Page<Country> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PRICING.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Country> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Country read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("countries", response.getContent(), Country.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

