/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.wireless.Command;

public class CommandReader
extends Reader<Command> {
    private String device;
    private String sim;
    private String status;
    private String direction;

    public CommandReader setDevice(String device) {
        this.device = device;
        return this;
    }

    public CommandReader setSim(String sim) {
        this.sim = sim;
        return this;
    }

    public CommandReader setStatus(String status) {
        this.status = status;
        return this;
    }

    public CommandReader setDirection(String direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public ResourceSet<Command> read(TwilioRestClient client) {
        return new ResourceSet<Command>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Command> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/wireless/Commands", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Command> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Command> nextPage(Page<Command> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Command> previousPage(Page<Command> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Command> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Command read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("commands", response.getContent(), Command.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.device != null) {
            request.addQueryParam("Device", this.device);
        }
        if (this.sim != null) {
            request.addQueryParam("Sim", this.sim);
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.direction != null) {
            request.addQueryParam("Direction", this.direction);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

