/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.StyleSheet;

public class StyleSheetFetcher
extends Fetcher<StyleSheet> {
    private final String pathAssistantSid;

    public StyleSheetFetcher(String pathAssistantSid) {
        this.pathAssistantSid = pathAssistantSid;
    }

    @Override
    public StyleSheet fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/StyleSheet", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("StyleSheet fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return StyleSheet.fromJson(response.getStream(), client.getObjectMapper());
    }
}

