/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.Fleet;

public class FleetReader
extends Reader<Fleet> {
    @Override
    public ResourceSet<Fleet> read(TwilioRestClient client) {
        return new ResourceSet<Fleet>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Fleet> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/DeployedDevices/Fleets", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Fleet> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Fleet> nextPage(Page<Fleet> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Fleet> previousPage(Page<Fleet> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Fleet> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fleet read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("fleets", response.getContent(), Fleet.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

