/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.notify.v1.service;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.notify.v1.service.Binding;
import java.util.List;

public class BindingCreator
extends Creator<Binding> {
    private final String pathServiceSid;
    private final String identity;
    private final Binding.BindingType bindingType;
    private final String address;
    private List<String> tag;
    private String notificationProtocolVersion;
    private String credentialSid;
    private String endpoint;

    public BindingCreator(String pathServiceSid, String identity, Binding.BindingType bindingType, String address) {
        this.pathServiceSid = pathServiceSid;
        this.identity = identity;
        this.bindingType = bindingType;
        this.address = address;
    }

    public BindingCreator setTag(List<String> tag) {
        this.tag = tag;
        return this;
    }

    public BindingCreator setTag(String tag) {
        return this.setTag(Promoter.listOfOne(tag));
    }

    public BindingCreator setNotificationProtocolVersion(String notificationProtocolVersion) {
        this.notificationProtocolVersion = notificationProtocolVersion;
        return this;
    }

    public BindingCreator setCredentialSid(String credentialSid) {
        this.credentialSid = credentialSid;
        return this;
    }

    public BindingCreator setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Override
    public Binding create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.NOTIFY.toString(), "/v1/Services/" + this.pathServiceSid + "/Bindings", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Binding creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Binding.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.bindingType != null) {
            request.addPostParam("BindingType", this.bindingType.toString());
        }
        if (this.address != null) {
            request.addPostParam("Address", this.address);
        }
        if (this.tag != null) {
            for (String prop : this.tag) {
                request.addPostParam("Tag", prop);
            }
        }
        if (this.notificationProtocolVersion != null) {
            request.addPostParam("NotificationProtocolVersion", this.notificationProtocolVersion);
        }
        if (this.credentialSid != null) {
            request.addPostParam("CredentialSid", this.credentialSid);
        }
        if (this.endpoint != null) {
            request.addPostParam("Endpoint", this.endpoint);
        }
    }
}

