/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service.channel;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.service.channel.Member;
import org.joda.time.DateTime;

public class MemberCreator
extends Creator<Member> {
    private final String pathServiceSid;
    private final String pathChannelSid;
    private final String identity;
    private String roleSid;
    private Integer lastConsumedMessageIndex;
    private DateTime lastConsumptionTimestamp;
    private DateTime dateCreated;
    private DateTime dateUpdated;
    private String attributes;

    public MemberCreator(String pathServiceSid, String pathChannelSid, String identity) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.identity = identity;
    }

    public MemberCreator setRoleSid(String roleSid) {
        this.roleSid = roleSid;
        return this;
    }

    public MemberCreator setLastConsumedMessageIndex(Integer lastConsumedMessageIndex) {
        this.lastConsumedMessageIndex = lastConsumedMessageIndex;
        return this;
    }

    public MemberCreator setLastConsumptionTimestamp(DateTime lastConsumptionTimestamp) {
        this.lastConsumptionTimestamp = lastConsumptionTimestamp;
        return this;
    }

    public MemberCreator setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public MemberCreator setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public MemberCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    @Override
    public Member create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CHAT.toString(), "/v2/Services/" + this.pathServiceSid + "/Channels/" + this.pathChannelSid + "/Members", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Member.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
        if (this.roleSid != null) {
            request.addPostParam("RoleSid", this.roleSid);
        }
        if (this.lastConsumedMessageIndex != null) {
            request.addPostParam("LastConsumedMessageIndex", this.lastConsumedMessageIndex.toString());
        }
        if (this.lastConsumptionTimestamp != null) {
            request.addPostParam("LastConsumptionTimestamp", this.lastConsumptionTimestamp.toString());
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
    }
}

