/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.StyleSheet;
import java.util.Map;

public class StyleSheetUpdater
extends Updater<StyleSheet> {
    private final String pathAssistantSid;
    private Map<String, Object> styleSheet;

    public StyleSheetUpdater(String pathAssistantSid) {
        this.pathAssistantSid = pathAssistantSid;
    }

    public StyleSheetUpdater setStyleSheet(Map<String, Object> styleSheet) {
        this.styleSheet = styleSheet;
        return this;
    }

    @Override
    public StyleSheet update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/StyleSheet", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("StyleSheet update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return StyleSheet.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.styleSheet != null) {
            request.addPostParam("StyleSheet", Converter.mapToJson(this.styleSheet));
        }
    }
}

