/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.autopilot.v1.AssistantCreator;
import com.twilio.rest.autopilot.v1.AssistantDeleter;
import com.twilio.rest.autopilot.v1.AssistantFetcher;
import com.twilio.rest.autopilot.v1.AssistantReader;
import com.twilio.rest.autopilot.v1.AssistantUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Assistant
extends Resource {
    private static final long serialVersionUID = 17320483220293L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String latestModelBuildSid;
    private final Map<String, String> links;
    private final Boolean logQueries;
    private final String sid;
    private final String uniqueName;
    private final URI url;
    private final URI callbackUrl;
    private final String callbackEvents;

    public static AssistantFetcher fetcher(String pathSid) {
        return new AssistantFetcher(pathSid);
    }

    public static AssistantReader reader() {
        return new AssistantReader();
    }

    public static AssistantCreator creator() {
        return new AssistantCreator();
    }

    public static AssistantUpdater updater(String pathSid) {
        return new AssistantUpdater(pathSid);
    }

    public static AssistantDeleter deleter(String pathSid) {
        return new AssistantDeleter(pathSid);
    }

    public static Assistant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Assistant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Assistant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Assistant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Assistant(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="latest_model_build_sid") String latestModelBuildSid, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="log_queries") Boolean logQueries, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="url") URI url, @JsonProperty(value="callback_url") URI callbackUrl, @JsonProperty(value="callback_events") String callbackEvents) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.latestModelBuildSid = latestModelBuildSid;
        this.links = links;
        this.logQueries = logQueries;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.url = url;
        this.callbackUrl = callbackUrl;
        this.callbackEvents = callbackEvents;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getLatestModelBuildSid() {
        return this.latestModelBuildSid;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final Boolean getLogQueries() {
        return this.logQueries;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final URI getCallbackUrl() {
        return this.callbackUrl;
    }

    public final String getCallbackEvents() {
        return this.callbackEvents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assistant other = (Assistant)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.latestModelBuildSid, other.latestModelBuildSid) && Objects.equals(this.links, other.links) && Objects.equals(this.logQueries, other.logQueries) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.url, other.url) && Objects.equals(this.callbackUrl, other.callbackUrl) && Objects.equals(this.callbackEvents, other.callbackEvents);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.latestModelBuildSid, this.links, this.logQueries, this.sid, this.uniqueName, this.url, this.callbackUrl, this.callbackEvents);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("friendlyName", this.friendlyName).add("latestModelBuildSid", this.latestModelBuildSid).add("links", this.links).add("logQueries", this.logQueries).add("sid", this.sid).add("uniqueName", this.uniqueName).add("url", this.url).add("callbackUrl", this.callbackUrl).add("callbackEvents", this.callbackEvents).toString();
    }
}

