/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.accounts.v1.credential;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.accounts.v1.credential.Aws;

public class AwsCreator
extends Creator<Aws> {
    private final String credentials;
    private String friendlyName;
    private String accountSid;

    public AwsCreator(String credentials) {
        this.credentials = credentials;
    }

    public AwsCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public AwsCreator setAccountSid(String accountSid) {
        this.accountSid = accountSid;
        return this;
    }

    @Override
    public Aws create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.ACCOUNTS.toString(), "/v1/Credentials/AWS", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Aws creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Aws.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.credentials != null) {
            request.addPostParam("Credentials", this.credentials.toString());
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.accountSid != null) {
            request.addPostParam("AccountSid", this.accountSid);
        }
    }
}

