/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.exception;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import java.io.IOException;
import java.io.InputStream;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RestException {
    private final Integer code;
    private final String message;
    private final String moreInfo;
    private final Integer status;

    @JsonCreator
    private RestException(@JsonProperty(value="status") int status, @JsonProperty(value="message") String message, @JsonProperty(value="code") Integer code, @JsonProperty(value="more_info") String moreInfo) {
        this.status = status;
        this.message = message;
        this.code = code;
        this.moreInfo = moreInfo;
    }

    public static RestException fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, RestException.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }

    public Integer getStatus() {
        return this.status;
    }
}

