/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import org.jadira.usertype.dateandtime.threeten.utils.ZoneHelper;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;

public class TimestampColumnZonedDateTimeMapper
extends AbstractVersionableTimestampColumnMapper<ZonedDateTime>
implements JavaZoneConfigured<ZoneId> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).toFormatter();
    private static final int MILLIS_IN_SECOND = 1000;
    private ZoneId javaZone = null;

    public TimestampColumnZonedDateTimeMapper() {
    }

    public TimestampColumnZonedDateTimeMapper(ZoneId javaZone) {
        this.javaZone = javaZone;
    }

    public ZonedDateTime fromNonNullString(String s) {
        return ZonedDateTime.parse(s);
    }

    public ZonedDateTime fromNonNullValue(Timestamp value) {
        ZoneId currentJavaZone = this.javaZone == null ? ZoneHelper.getDefaultZoneId() : this.javaZone;
        ZonedDateTime zonedDateTime = value.toInstant().with(ChronoField.NANO_OF_SECOND, value.getNanos()).atZone(currentJavaZone);
        return zonedDateTime;
    }

    public String toNonNullString(ZonedDateTime value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(ZonedDateTime value) {
        Timestamp timestamp = new Timestamp(value.toEpochSecond() * 1000L);
        timestamp.setNanos(value.getNano());
        return timestamp;
    }

    public void setJavaZone(ZoneId javaZone) {
        this.javaZone = javaZone;
    }

    public ZoneId parseJavaZone(String zoneString) {
        return ZoneId.of(zoneString);
    }
}

