/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.corejava.enumerated;

import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.jadira.usertype.corejava.enumerated.PersistentEnum;
import org.postgresql.util.PGobject;

public class PersistentEnumAsPostgreSQLEnum
extends PersistentEnum {
    private static final long serialVersionUID = 6811103311933769966L;
    private static final int POSTGRES_ENUM_TYPE = 1111;
    private static boolean HAS_POSTGRES_DRIVER;

    public Object doNullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!HAS_POSTGRES_DRIVER) {
            return super.doNullSafeGet(rs, names, session, owner);
        }
        Object identifier = rs.getObject(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        if (identifier instanceof PGobject) {
            PGobject pg = (PGobject)identifier;
            return this.getValueOfMethod().invoke((Object)this.getMappedClass(), pg.getValue());
        }
        if (identifier instanceof String) {
            return this.getValueOfMethod().invoke((Object)this.getMappedClass(), (String)identifier);
        }
        throw new IllegalArgumentException("PersistentEnum type expected PGobject, received " + identifier.getClass().getName() + " with value of '" + identifier + "'");
    }

    public void doNullSafeSet(PreparedStatement preparedStatement, Object value, int index, SharedSessionContractImplementor session) throws SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!HAS_POSTGRES_DRIVER) {
            super.doNullSafeSet(preparedStatement, value, index, session);
            return;
        }
        if (value == null) {
            preparedStatement.setNull(index, 1111);
        } else {
            Object identifier = this.getIdentifierMethod().invoke(value, new Object[0]);
            preparedStatement.setObject(index, identifier, 1111);
        }
    }

    @Override
    public void setParameterValues(Properties parameters) {
        super.setParameterValues(parameters);
        if (!this.getIdentifierType().equals(String.class)) {
            throw new HibernateException("PostgreSQL Enum must be mapped using String form");
        }
    }

    static {
        try {
            Class.forName("org.postgresql.util.PGobject");
            HAS_POSTGRES_DRIVER = true;
        }
        catch (ClassNotFoundException e) {
            HAS_POSTGRES_DRIVER = false;
        }
    }
}

