/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.corejava.enumerated;

import java.lang.reflect.Method;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.usertype.ParameterizedType;
import org.jadira.usertype.spi.shared.AbstractReflectionUserType;

public class PersistentEnum
extends AbstractReflectionUserType<Enum<?>>
implements ParameterizedType {
    private static final long serialVersionUID = 3094384329334123541L;
    private static final String DEFAULT_VALUE_OF_METHOD_NAME = "valueOf";
    private static final String DEFAULT_IDENTIFIER_METHOD_NAME = "name";

    public void setParameterValues(Properties parameters) {
        Method identifierMethod;
        if (parameters.containsKey("enumClass")) {
            String enumClassName = parameters.getProperty("enumClass");
            try {
                this.setMappedClass(Class.forName(enumClassName));
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Specified Enum class could not be found", (Throwable)e);
            }
        }
        String identifierMethodName = parameters.getProperty("identifierMethod", DEFAULT_IDENTIFIER_METHOD_NAME);
        try {
            identifierMethod = this.getMappedClass().getMethod(identifierMethodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Specified identifier method could not be found", (Throwable)e);
        }
        this.setIdentifierMethod(identifierMethod);
        String valueOfMethodName = parameters.getProperty("valueOfMethod", DEFAULT_VALUE_OF_METHOD_NAME);
        try {
            this.setValueOfMethod(this.getMappedClass().getMethod(valueOfMethodName, identifierMethod.getReturnType()));
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException("Specified valueOf method could not be found", (Throwable)e);
        }
        super.setParameterValues(parameters);
    }

    public Class<Enum<?>> returnedClass() {
        Class mappedClass = this.getMappedClass();
        if (mappedClass == null) {
            throw new IllegalStateException("enumClass was not defined for " + ((Object)((Object)this)).getClass().getName());
        }
        return mappedClass;
    }
}

