/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.jobs;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.AccumulableInfo;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ExecutorStageSummary;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.ui.ToolTips$;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.ui.jobs.JobsTab;
import org.apache.spark.ui.jobs.StageTableBase;
import org.apache.spark.ui.scope.RDDOperationGraph;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;
import scala.xml.Utility$;

@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0001\t1\u0011qAS8c!\u0006<WM\u0003\u0002\u0004\t\u0005!!n\u001c2t\u0015\t)a!\u0001\u0002vS*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0002\u0001\u001bA\u0011abD\u0007\u0002\t%\u0011\u0001\u0003\u0002\u0002\n/\u0016\u0014W+\u0013)bO\u0016D\u0001B\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0007a\u0006\u0014XM\u001c;\u0004\u0001A\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\b\u0015>\u00147\u000fV1c\u0011!I\u0002A!A!\u0002\u0013Q\u0012!B:u_J,\u0007CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0007\u0003\u0019\u0019H/\u0019;vg&\u0011q\u0004\b\u0002\u000f\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00191\u0005J\u0013\u0011\u0005U\u0001\u0001\"\u0002\n!\u0001\u0004!\u0002\"B\r!\u0001\u0004Q\u0002bB\u0014\u0001\u0005\u0004%I\u0001K\u0001\u000e'R\u000bu)R*`\u0019\u0016;UI\u0014#\u0016\u0003%\u0002\"AK\u001a\u000f\u0005-\n\u0004C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0014\u0003\u0019a$o\\8u})\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u0011t\u0006\u0003\u00048\u0001\u0001\u0006I!K\u0001\u000f'R\u000bu)R*`\u0019\u0016;UI\u0014#!\u0011\u001dI\u0004A1A\u0005\n!\n\u0001#\u0012-F\u0007V#vJU*`\u0019\u0016;UI\u0014#\t\rm\u0002\u0001\u0015!\u0003*\u0003E)\u0005,R\"V)>\u00136k\u0018'F\u000f\u0016sE\t\t\u0005\u0006{\u0001!IAP\u0001\u000f[\u0006\\Wm\u0015;bO\u0016,e/\u001a8u)\ty\u0004\nE\u0002A\u000b&r!!Q\"\u000f\u00051\u0012\u0015\"\u0001\u0019\n\u0005\u0011{\u0013a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u00131aU3r\u0015\t!u\u0006C\u0003Jy\u0001\u0007!*\u0001\u0006ti\u0006<W-\u00138g_N\u00042\u0001Q#L!\ta\u0015+D\u0001N\u0015\tqu*\u0001\u0002wc)\u0011\u0001\u000bH\u0001\u0004CBL\u0017B\u0001*N\u0005%\u0019F/Y4f\t\u0006$\u0018\rC\u0003U\u0001\u0011\u0005Q+A\tnC.,W\t_3dkR|'/\u0012<f]R$\"a\u0010,\t\u000b]\u001b\u0006\u0019\u0001-\u0002\u0013\u0015DXmY;u_J\u001c\bc\u0001!F3B\u0011AJW\u0005\u000376\u0013q\"\u0012=fGV$xN]*v[6\f'/\u001f\u0005\u0006;\u0002!IAX\u0001\r[\u0006\\W\rV5nK2Lg.\u001a\u000b\u0005?\u001aD\u0017\u000eE\u0002A\u000b\u0002\u0004\"!\u00193\u000e\u0003\tT!aY\u0018\u0002\u0007alG.\u0003\u0002fE\n!aj\u001c3f\u0011\u00159G\f1\u0001K\u0003\u0019\u0019H/Y4fg\")q\u000b\u0018a\u00011\")!\u000e\u0018a\u0001W\u0006a\u0011\r\u001d9Ti\u0006\u0014H\u000fV5nKB\u0011A.\\\u0007\u0002_%\u0011an\f\u0002\u0005\u0019>tw\rC\u0003q\u0001\u0011\u0005\u0011/\u0001\u0004sK:$WM\u001d\u000b\u0003?JDQa]8A\u0002Q\fqA]3rk\u0016\u001cH\u000f\u0005\u0002vy6\taO\u0003\u0002xq\u0006!\u0001\u000e\u001e;q\u0015\tI(0A\u0004tKJ4H.\u001a;\u000b\u0003m\fQA[1wCbL!! <\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f\u001e")
public class JobPage
extends WebUIPage {
    private final JobsTab parent;
    private final AppStatusStore store;
    private final String STAGES_LEGEND;
    private final String EXECUTORS_LEGEND;

    private String STAGES_LEGEND() {
        return this.STAGES_LEGEND;
    }

    private String EXECUTORS_LEGEND() {
        return this.EXECUTORS_LEGEND;
    }

    private Seq<String> makeStageEvent(Seq<StageData> stageInfos) {
        return (Seq)stageInfos.map((Function1 & Serializable & scala.Serializable)stage -> {
            int stageId = stage.stageId();
            int attemptId = stage.attemptId();
            String name = stage.name();
            String status = stage.status().toString();
            long submissionTime = ((Date)stage.submissionTime().get()).getTime();
            long completionTime = BoxesRunTime.unboxToLong((Object)stage.completionTime().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis()));
            String escapedName = Utility$.MODULE$.escape(name);
            String jsEscapedName = StringEscapeUtils.escapeEcmaScript((String)escapedName);
            String string = status;
            String string2 = "running";
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(477).append("\n         |{\n         |  'className': 'stage job-timeline-object ").append(status).append("',\n         |  'group': 'stages',\n         |  'start': new Date(").append(submissionTime).append("),\n         |  'end': new Date(").append(completionTime).append("),\n         |  'content': '<div class=\"job-timeline-content\" data-toggle=\"tooltip\"' +\n         |   'data-placement=\"top\" data-html=\"true\"' +\n         |   'data-title=\"").append(jsEscapedName).append(" (Stage ").append(stageId).append(".").append(attemptId).append(")<br>' +\n         |   'Status: ").append(status.toUpperCase(Locale.ROOT)).append("<br>' +\n         |   'Submitted: ").append(UIUtils$.MODULE$.formatDate(submissionTime)).append("' +\n         |   '").append((Object)((string == null ? string2 != null : !string.equals(string2)) ? new StringBuilder(15).append("<br>Completed: ").append(UIUtils$.MODULE$.formatDate(completionTime)).toString() : "")).append("\">' +\n         |    '").append(jsEscapedName).append(" (Stage ").append(stageId).append(".").append(attemptId).append(")</div>',\n         |}\n       ").toString())).stripMargin();
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> makeExecutorEvent(Seq<ExecutorSummary> executors) {
        ListBuffer events = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        executors.foreach((Function1 & Serializable & scala.Serializable)e -> {
            JobPage.$anonfun$makeExecutorEvent$1(events, e);
            return BoxedUnit.UNIT;
        });
        return events.toSeq();
    }

    private Seq<Node> makeTimeline(Seq<StageData> stages, Seq<ExecutorSummary> executors, long appStartTime) {
        Seq<String> stageEventJsonAsStrSeq = this.makeStageEvent(stages);
        Seq<String> executorsJsonAsStrSeq = this.makeExecutorEvent(executors);
        String groupJsonArrayAsStr = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(258).append("\n          |[\n          |  {\n          |    'id': 'executors',\n          |    'content': '<div>Executors</div>").append(this.EXECUTORS_LEGEND()).append("',\n          |  },\n          |  {\n          |    'id': 'stages',\n          |    'content': '<div>Stages</div>").append(this.STAGES_LEGEND()).append("',\n          |  }\n          |]\n        ").toString())).stripMargin();
        String eventArrayAsStr = ((TraversableOnce)stageEventJsonAsStrSeq.$plus$plus(executorsJsonAsStrSeq, Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("expand-job-timeline"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("expand-job-timeline-arrow arrow-closed"), (MetaData)$md2);
        $buf.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("data-placement", (Seq)new Text("right"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("title", ToolTips$.MODULE$.STAGE_TIMELINE(), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        Event Timeline\n      "));
        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("class", (Seq)new Text("collapsed"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("id", (Seq)new Text("job-timeline"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("control-panel"), (MetaData)$md5);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("id", (Seq)new Text("job-timeline-zoom-lock"), (MetaData)$md6);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n          "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("type", (Seq)new Text("checkbox"), (MetaData)$md7);
        $buf5.$amp$plus((Object)new Elem(null, "input", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf5.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("Enable zooming"));
        $buf5.$amp$plus((Object)new Elem(null, "span", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)new Elem(null, "div", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf3.$amp$plus((Object)new Elem(null, "div", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf3.$amp$plus((Object)new Text("\n    "));
        TraversableLike traversableLike = (TraversableLike)elem.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3), NodeSeq$.MODULE$.canBuildFrom());
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("type", (Seq)new Text("text/javascript"), (MetaData)$md8);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf7.$amp$plus((Object)Unparsed$.MODULE$.apply(new StringBuilder(20).append("drawJobTimeline(").append(groupJsonArrayAsStr).append(", ").append(eventArrayAsStr).append(", ").append(new StringBuilder(4).append(appStartTime).append(", ").append(UIUtils$.MODULE$.getTimeZoneOffset()).append(");").toString()).toString()));
        $buf7.$amp$plus((Object)new Text("\n    "));
        return (Seq)traversableLike.$plus$plus((GenTraversableOnce)new Elem(null, "script", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7), NodeSeq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<Node> render(HttpServletRequest request) {
        Seq<Node> seq;
        Object object = new Object();
        try {
            Elem elem;
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            String parameterId = UIUtils$.MODULE$.stripXSS(request.getParameter("id"));
            Predef$.MODULE$.require(parameterId != null && new StringOps(Predef$.MODULE$.augmentString(parameterId)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Missing id parameter");
            int jobId = new StringOps(Predef$.MODULE$.augmentString(parameterId)).toInt();
            JobData jobData = (JobData)this.store.asOption((Function0 & Serializable & scala.Serializable)() -> $this.store.job(jobId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Null$ $md = Null$.MODULE$;
                $md = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md);
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("No information to display for job "));
                $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)jobId));
                $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                $buf.$amp$plus((Object)new Text("\n        "));
                Elem content = new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                throw new NonLocalReturnControl(object, UIUtils$.MODULE$.headerSparkPage(request, new StringBuilder(16).append("Details for Job ").append(jobId).toString(), (Function0<Seq<Node>>)(Function0 & Serializable & scala.Serializable)() -> content, $this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7(), UIUtils$.MODULE$.headerSparkPage$default$8()));
            });
            JobExecutionStatus jobExecutionStatus = jobData.status();
            JobExecutionStatus jobExecutionStatus2 = JobExecutionStatus.RUNNING;
            boolean isComplete = jobExecutionStatus == null ? jobExecutionStatus2 != null : !((Object)((Object)jobExecutionStatus)).equals((Object)jobExecutionStatus2);
            Seq stages = (Seq)jobData.stageIds().map((Function1 & Serializable & scala.Serializable)stageId -> JobPage.$anonfun$render$5(this, BoxesRunTime.unboxToInt((Object)stageId)), Seq$.MODULE$.canBuildFrom());
            Buffer activeStages = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Buffer completedStages = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Buffer pendingOrSkippedStages = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            Buffer failedStages = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            stages.foreach((Function1 & Serializable & scala.Serializable)stage -> {
                Buffer buffer;
                if (stage.submissionTime().isEmpty()) {
                    buffer = pendingOrSkippedStages.$plus$eq(stage);
                } else if (stage.completionTime().isDefined()) {
                    StageStatus stageStatus = stage.status();
                    StageStatus stageStatus2 = StageStatus.FAILED;
                    buffer = !(stageStatus != null ? !((Object)((Object)stageStatus)).equals((Object)stageStatus2) : stageStatus2 != null) ? failedStages.$plus$eq(stage) : completedStages.$plus$eq(stage);
                } else {
                    buffer = activeStages.$plus$eq(stage);
                }
                return buffer;
            });
            String basePath = "jobs/job";
            String pendingOrSkippedTableId = isComplete ? "pending" : "skipped";
            StageTableBase activeStagesTable = new StageTableBase(this.store, request, (Seq<StageData>)activeStages, "active", "activeStage", this.parent.basePath(), basePath, this.parent.isFairScheduler(), this.parent.killEnabled(), false);
            StageTableBase pendingOrSkippedStagesTable = new StageTableBase(this.store, request, (Seq<StageData>)pendingOrSkippedStages, pendingOrSkippedTableId, "pendingStage", this.parent.basePath(), basePath, this.parent.isFairScheduler(), false, false);
            StageTableBase completedStagesTable = new StageTableBase(this.store, request, (Seq<StageData>)completedStages, "completed", "completedStage", this.parent.basePath(), basePath, this.parent.isFairScheduler(), false, false);
            StageTableBase failedStagesTable = new StageTableBase(this.store, request, (Seq<StageData>)failedStages, "failed", "failedStage", this.parent.basePath(), basePath, this.parent.isFairScheduler(), false, true);
            boolean shouldShowActiveStages = activeStages.nonEmpty();
            boolean shouldShowPendingStages = !isComplete && pendingOrSkippedStages.nonEmpty();
            boolean shouldShowCompletedStages = completedStages.nonEmpty();
            boolean shouldShowSkippedStages = isComplete && pendingOrSkippedStages.nonEmpty();
            boolean shouldShowFailedStages = failedStages.nonEmpty();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("class", (Seq)new Text("unstyled"), (MetaData)$md);
            NodeBuffer $buf2 = new NodeBuffer();
            $buf2.$amp$plus((Object)new Text("\n          "));
            NodeBuffer $buf3 = new NodeBuffer();
            $buf3.$amp$plus((Object)new Text("\n            "));
            NodeBuffer $buf4 = new NodeBuffer();
            $buf4.$amp$plus((Object)new Text("Status:"));
            $buf3.$amp$plus((Object)new Elem(null, "Strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
            $buf3.$amp$plus((Object)new Text("\n            "));
            $buf3.$amp$plus((Object)jobData.status());
            $buf3.$amp$plus((Object)new Text("\n          "));
            $buf2.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (jobData.jobGroup().isDefined()) {
                NodeBuffer $buf5 = new NodeBuffer();
                $buf5.$amp$plus((Object)new Text("\n                "));
                NodeBuffer $buf6 = new NodeBuffer();
                $buf6.$amp$plus((Object)new Text("Job Group:"));
                $buf5.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
                $buf5.$amp$plus((Object)new Text("\n                "));
                $buf5.$amp$plus(jobData.jobGroup().get());
                $buf5.$amp$plus((Object)new Text("\n              "));
                Elem elem2 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5);
                boxedUnit6 = elem2;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit6);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowActiveStages) {
                NodeBuffer $buf7 = new NodeBuffer();
                $buf7.$amp$plus((Object)new Text("\n                "));
                Null$ $md2 = Null$.MODULE$;
                $md2 = new UnprefixedAttribute("href", (Seq)new Text("#active"), (MetaData)$md2);
                NodeBuffer $buf8 = new NodeBuffer();
                NodeBuffer $buf9 = new NodeBuffer();
                $buf9.$amp$plus((Object)new Text("Active Stages:"));
                $buf8.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
                $buf7.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
                $buf7.$amp$plus((Object)new Text("\n                "));
                $buf7.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeStages.size()));
                $buf7.$amp$plus((Object)new Text("\n              "));
                Elem elem3 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7);
                boxedUnit5 = elem3;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit5);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowPendingStages) {
                NodeBuffer $buf10 = new NodeBuffer();
                $buf10.$amp$plus((Object)new Text("\n                "));
                Null$ $md3 = Null$.MODULE$;
                $md3 = new UnprefixedAttribute("href", (Seq)new Text("#pending"), (MetaData)$md3);
                NodeBuffer $buf11 = new NodeBuffer();
                $buf11.$amp$plus((Object)new Text("\n                  "));
                NodeBuffer $buf12 = new NodeBuffer();
                $buf12.$amp$plus((Object)new Text("Pending Stages:"));
                $buf11.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
                $buf11.$amp$plus((Object)new Text("\n                "));
                $buf10.$amp$plus((Object)new Elem(null, "a", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
                $buf10.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                $buf10.$amp$plus((Object)new Text("\n              "));
                Elem elem4 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10);
                boxedUnit4 = elem4;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit4);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowCompletedStages) {
                NodeBuffer $buf13 = new NodeBuffer();
                $buf13.$amp$plus((Object)new Text("\n                "));
                Null$ $md4 = Null$.MODULE$;
                $md4 = new UnprefixedAttribute("href", (Seq)new Text("#completed"), (MetaData)$md4);
                NodeBuffer $buf14 = new NodeBuffer();
                NodeBuffer $buf15 = new NodeBuffer();
                $buf15.$amp$plus((Object)new Text("Completed Stages:"));
                $buf14.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf15));
                $buf13.$amp$plus((Object)new Elem(null, "a", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf14));
                $buf13.$amp$plus((Object)new Text("\n                "));
                $buf13.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completedStages.size()));
                $buf13.$amp$plus((Object)new Text("\n              "));
                Elem elem5 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf13);
                boxedUnit3 = elem5;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit3);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowSkippedStages) {
                NodeBuffer $buf16 = new NodeBuffer();
                $buf16.$amp$plus((Object)new Text("\n              "));
                Null$ $md5 = Null$.MODULE$;
                $md5 = new UnprefixedAttribute("href", (Seq)new Text("#skipped"), (MetaData)$md5);
                NodeBuffer $buf17 = new NodeBuffer();
                NodeBuffer $buf18 = new NodeBuffer();
                $buf18.$amp$plus((Object)new Text("Skipped Stages:"));
                $buf17.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf18));
                $buf16.$amp$plus((Object)new Elem(null, "a", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf17));
                $buf16.$amp$plus((Object)new Text("\n              "));
                $buf16.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                $buf16.$amp$plus((Object)new Text("\n            "));
                Elem elem6 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf16);
                boxedUnit2 = elem6;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit2);
            $buf2.$amp$plus((Object)new Text("\n          "));
            if (shouldShowFailedStages) {
                NodeBuffer $buf19 = new NodeBuffer();
                $buf19.$amp$plus((Object)new Text("\n                "));
                Null$ $md6 = Null$.MODULE$;
                $md6 = new UnprefixedAttribute("href", (Seq)new Text("#failed"), (MetaData)$md6);
                NodeBuffer $buf20 = new NodeBuffer();
                NodeBuffer $buf21 = new NodeBuffer();
                $buf21.$amp$plus((Object)new Text("Failed Stages:"));
                $buf20.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf21));
                $buf19.$amp$plus((Object)new Elem(null, "a", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf20));
                $buf19.$amp$plus((Object)new Text("\n                "));
                $buf19.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedStages.size()));
                $buf19.$amp$plus((Object)new Text("\n              "));
                Elem elem7 = new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf19);
                boxedUnit = elem7;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $buf2.$amp$plus((Object)boxedUnit);
            $buf2.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
            $buf.$amp$plus((Object)new Text("\n      "));
            Elem summary = new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
            ObjectRef content = ObjectRef.create((Object)summary);
            long appStartTime = ((ApplicationAttemptInfo)this.store.applicationInfo().attempts().head()).startTime().getTime();
            content.elem = (NodeSeq)((NodeSeq)content.elem).$plus$plus(this.makeTimeline((Seq<StageData>)activeStages.$plus$plus((GenTraversableOnce)completedStages).$plus$plus((GenTraversableOnce)failedStages), this.store.executorList(false), appStartTime), NodeSeq$.MODULE$.canBuildFrom());
            Option option = this.store.asOption((Function0 & Serializable & scala.Serializable)() -> $this.store.operationGraphForJob(jobId));
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq operationGraph = (Seq)some.value();
                elem = UIUtils$.MODULE$.showDagVizForJob(jobId, (Seq<RDDOperationGraph>)operationGraph);
            } else if (None$.MODULE$.equals(option)) {
                Null$ $md7 = Null$.MODULE$;
                $md7 = new UnprefixedAttribute("id", (Seq)new Text("no-info"), (MetaData)$md7);
                NodeBuffer $buf22 = new NodeBuffer();
                $buf22.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf23 = new NodeBuffer();
                $buf23.$amp$plus((Object)new Text("No DAG visualization information to display for job "));
                $buf23.$amp$plus((Object)BoxesRunTime.boxToInteger((int)jobId));
                $buf22.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf23));
                $buf22.$amp$plus((Object)new Text("\n        "));
                elem = new Elem(null, "div", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf22);
            } else {
                throw new MatchError(option);
            }
            Elem operationGraphContent = elem;
            content.elem = (NodeSeq)((NodeSeq)content.elem).$plus$plus(operationGraphContent, NodeSeq$.MODULE$.canBuildFrom());
            if (shouldShowActiveStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md8 = Null$.MODULE$;
                $md8 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-activeStages','aggregated-activeStages')"), (MetaData)$md8);
                $md8 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-activeStages collapse-table"), (MetaData)$md8);
                $md8 = new UnprefixedAttribute("id", (Seq)new Text("active"), (MetaData)$md8);
                NodeBuffer $buf24 = new NodeBuffer();
                $buf24.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf25 = new NodeBuffer();
                $buf25.$amp$plus((Object)new Text("\n            "));
                Null$ $md9 = Null$.MODULE$;
                $md9 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md9);
                $buf25.$amp$plus((Object)new Elem(null, "span", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf25.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf26 = new NodeBuffer();
                $buf26.$amp$plus((Object)new Text("Active Stages ("));
                $buf26.$amp$plus((Object)BoxesRunTime.boxToInteger((int)activeStages.size()));
                $buf26.$amp$plus((Object)new Text(")"));
                $buf25.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf26));
                $buf25.$amp$plus((Object)new Text("\n          "));
                $buf24.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf25));
                $buf24.$amp$plus((Object)new Text("\n        "));
                Elem elem8 = new Elem(null, "span", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf24);
                Null$ $md10 = Null$.MODULE$;
                $md10 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-activeStages collapsible-table"), (MetaData)$md10);
                NodeBuffer $buf27 = new NodeBuffer();
                $buf27.$amp$plus((Object)new Text("\n          "));
                $buf27.$amp$plus(activeStagesTable.toNodeSeq());
                $buf27.$amp$plus((Object)new Text("\n        "));
                content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem8.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf27), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
            }
            if (shouldShowPendingStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md11 = Null$.MODULE$;
                $md11 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-pendingOrSkippedStages',\n            'aggregated-pendingOrSkippedStages')"), (MetaData)$md11);
                $md11 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-pendingOrSkippedStages collapse-table"), (MetaData)$md11);
                $md11 = new UnprefixedAttribute("id", (Seq)new Text("pending"), (MetaData)$md11);
                NodeBuffer $buf28 = new NodeBuffer();
                $buf28.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf29 = new NodeBuffer();
                $buf29.$amp$plus((Object)new Text("\n            "));
                Null$ $md12 = Null$.MODULE$;
                $md12 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md12);
                $buf29.$amp$plus((Object)new Elem(null, "span", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf29.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf30 = new NodeBuffer();
                $buf30.$amp$plus((Object)new Text("Pending Stages ("));
                $buf30.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                $buf30.$amp$plus((Object)new Text(")"));
                $buf29.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf30));
                $buf29.$amp$plus((Object)new Text("\n          "));
                $buf28.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf29));
                $buf28.$amp$plus((Object)new Text("\n        "));
                Elem elem9 = new Elem(null, "span", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf28);
                Null$ $md13 = Null$.MODULE$;
                $md13 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-pendingOrSkippedStages collapsible-table"), (MetaData)$md13);
                NodeBuffer $buf31 = new NodeBuffer();
                $buf31.$amp$plus((Object)new Text("\n          "));
                $buf31.$amp$plus(pendingOrSkippedStagesTable.toNodeSeq());
                $buf31.$amp$plus((Object)new Text("\n        "));
                content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem9.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf31), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
            }
            if (shouldShowCompletedStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md14 = Null$.MODULE$;
                $md14 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-completedStages',\n            'aggregated-completedStages')"), (MetaData)$md14);
                $md14 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-completedStages collapse-table"), (MetaData)$md14);
                $md14 = new UnprefixedAttribute("id", (Seq)new Text("completed"), (MetaData)$md14);
                NodeBuffer $buf32 = new NodeBuffer();
                $buf32.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf33 = new NodeBuffer();
                $buf33.$amp$plus((Object)new Text("\n            "));
                Null$ $md15 = Null$.MODULE$;
                $md15 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md15);
                $buf33.$amp$plus((Object)new Elem(null, "span", (MetaData)$md15, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf33.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf34 = new NodeBuffer();
                $buf34.$amp$plus((Object)new Text("Completed Stages ("));
                $buf34.$amp$plus((Object)BoxesRunTime.boxToInteger((int)completedStages.size()));
                $buf34.$amp$plus((Object)new Text(")"));
                $buf33.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf34));
                $buf33.$amp$plus((Object)new Text("\n          "));
                $buf32.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf33));
                $buf32.$amp$plus((Object)new Text("\n        "));
                Elem elem10 = new Elem(null, "span", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf32);
                Null$ $md16 = Null$.MODULE$;
                $md16 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-completedStages collapsible-table"), (MetaData)$md16);
                NodeBuffer $buf35 = new NodeBuffer();
                $buf35.$amp$plus((Object)new Text("\n          "));
                $buf35.$amp$plus(completedStagesTable.toNodeSeq());
                $buf35.$amp$plus((Object)new Text("\n        "));
                content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem10.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md16, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf35), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
            }
            if (shouldShowSkippedStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md17 = Null$.MODULE$;
                $md17 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-pendingOrSkippedStages',\n            'aggregated-pendingOrSkippedStages')"), (MetaData)$md17);
                $md17 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-pendingOrSkippedStages collapse-table"), (MetaData)$md17);
                $md17 = new UnprefixedAttribute("id", (Seq)new Text("skipped"), (MetaData)$md17);
                NodeBuffer $buf36 = new NodeBuffer();
                $buf36.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf37 = new NodeBuffer();
                $buf37.$amp$plus((Object)new Text("\n            "));
                Null$ $md18 = Null$.MODULE$;
                $md18 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md18);
                $buf37.$amp$plus((Object)new Elem(null, "span", (MetaData)$md18, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf37.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf38 = new NodeBuffer();
                $buf38.$amp$plus((Object)new Text("Skipped Stages ("));
                $buf38.$amp$plus((Object)BoxesRunTime.boxToInteger((int)pendingOrSkippedStages.size()));
                $buf38.$amp$plus((Object)new Text(")"));
                $buf37.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf38));
                $buf37.$amp$plus((Object)new Text("\n          "));
                $buf36.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf37));
                $buf36.$amp$plus((Object)new Text("\n        "));
                Elem elem11 = new Elem(null, "span", (MetaData)$md17, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf36);
                Null$ $md19 = Null$.MODULE$;
                $md19 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-pendingOrSkippedStages collapsible-table"), (MetaData)$md19);
                NodeBuffer $buf39 = new NodeBuffer();
                $buf39.$amp$plus((Object)new Text("\n          "));
                $buf39.$amp$plus(pendingOrSkippedStagesTable.toNodeSeq());
                $buf39.$amp$plus((Object)new Text("\n        "));
                content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem11.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md19, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf39), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
            }
            if (shouldShowFailedStages) {
                NodeSeq nodeSeq = (NodeSeq)content.elem;
                Null$ $md20 = Null$.MODULE$;
                $md20 = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-failedStages','aggregated-failedStages')"), (MetaData)$md20);
                $md20 = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-failedStages collapse-table"), (MetaData)$md20);
                $md20 = new UnprefixedAttribute("id", (Seq)new Text("failed"), (MetaData)$md20);
                NodeBuffer $buf40 = new NodeBuffer();
                $buf40.$amp$plus((Object)new Text("\n          "));
                NodeBuffer $buf41 = new NodeBuffer();
                $buf41.$amp$plus((Object)new Text("\n            "));
                Null$ $md21 = Null$.MODULE$;
                $md21 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md21);
                $buf41.$amp$plus((Object)new Elem(null, "span", (MetaData)$md21, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
                $buf41.$amp$plus((Object)new Text("\n            "));
                NodeBuffer $buf42 = new NodeBuffer();
                $buf42.$amp$plus((Object)new Text("Failed Stages ("));
                $buf42.$amp$plus((Object)BoxesRunTime.boxToInteger((int)failedStages.size()));
                $buf42.$amp$plus((Object)new Text(")"));
                $buf41.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf42));
                $buf41.$amp$plus((Object)new Text("\n          "));
                $buf40.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf41));
                $buf40.$amp$plus((Object)new Text("\n        "));
                Elem elem12 = new Elem(null, "span", (MetaData)$md20, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf40);
                Null$ $md22 = Null$.MODULE$;
                $md22 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-failedStages collapsible-table"), (MetaData)$md22);
                NodeBuffer $buf43 = new NodeBuffer();
                $buf43.$amp$plus((Object)new Text("\n          "));
                $buf43.$amp$plus(failedStagesTable.toNodeSeq());
                $buf43.$amp$plus((Object)new Text("\n        "));
                content.elem = (NodeSeq)nodeSeq.$plus$plus((GenTraversableOnce)elem12.$plus$plus((GenTraversableOnce)new Elem(null, "div", (MetaData)$md22, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf43), NodeSeq$.MODULE$.canBuildFrom()), NodeSeq$.MODULE$.canBuildFrom());
            }
            HttpServletRequest x$4 = request;
            String x$5 = new StringBuilder(16).append("Details for Job ").append(jobId).toString();
            Function0 & Serializable & scala.Serializable x$6 = (Function0 & Serializable & scala.Serializable)() -> (NodeSeq)content$1.elem;
            JobsTab x$7 = this.parent;
            boolean x$8 = true;
            Option<Object> x$9 = UIUtils$.MODULE$.headerSparkPage$default$5();
            Option<String> x$10 = UIUtils$.MODULE$.headerSparkPage$default$6();
            boolean x$11 = UIUtils$.MODULE$.headerSparkPage$default$8();
            seq = UIUtils$.MODULE$.headerSparkPage(x$4, x$5, (Function0<Seq<Node>>)x$6, x$7, x$9, x$10, x$8, x$11);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                seq = (Seq<Node>)ex.value();
            }
            throw ex;
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$STAGES_LEGEND$1(char x$1) {
        return x$1 != '\n';
    }

    public static final /* synthetic */ boolean $anonfun$EXECUTORS_LEGEND$1(char x$2) {
        return x$2 != '\n';
    }

    public static final /* synthetic */ void $anonfun$makeExecutorEvent$1(ListBuffer events$1, ExecutorSummary e) {
        String addedEvent = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(419).append("\n           |{\n           |  'className': 'executor added',\n           |  'group': 'executors',\n           |  'start': new Date(").append(e.addTime().getTime()).append("),\n           |  'content': '<div class=\"executor-event-content\"' +\n           |    'data-toggle=\"tooltip\" data-placement=\"bottom\"' +\n           |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n           |    'Added at ").append(UIUtils$.MODULE$.formatDate(e.addTime())).append("\"' +\n           |    'data-html=\"true\">Executor ").append(e.id()).append(" added</div>'\n           |}\n         ").toString())).stripMargin();
        events$1.$plus$eq((Object)addedEvent);
        e.removeTime().foreach((Function1 & Serializable & scala.Serializable)removeTime -> {
            String removedEvent = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(470).append("\n             |{\n             |  'className': 'executor removed',\n             |  'group': 'executors',\n             |  'start': new Date(").append(removeTime.getTime()).append("),\n             |  'content': '<div class=\"executor-event-content\"' +\n             |    'data-toggle=\"tooltip\" data-placement=\"bottom\"' +\n             |    'data-title=\"Executor ").append(e.id()).append("<br>' +\n             |    'Removed at ").append(UIUtils$.MODULE$.formatDate((Date)removeTime)).append("' +\n             |    '").append(e.removeReason().map((Function1 & Serializable & scala.Serializable)reason -> new StringBuilder(12).append("<br>Reason: ").append(reason.replace("\n", " ")).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("\"' +\n             |    'data-html=\"true\">Executor ").append(e.id()).append(" removed</div>'\n             |}\n           ").toString())).stripMargin();
            return events$1.$plus$eq((Object)removedEvent);
        });
    }

    public static final /* synthetic */ StageData $anonfun$render$5(JobPage $this, int stageId) {
        return (StageData)$this.store.asOption((Function0 & Serializable & scala.Serializable)() -> $this.store.lastStageAttempt(stageId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StageData(StageStatus.PENDING, stageId, 0, 0, 0, 0, 0, 0, 0, 0L, 0L, (Option<Date>)None$.MODULE$, (Option<Date>)None$.MODULE$, (Option<Date>)None$.MODULE$, (Option<String>)None$.MODULE$, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, "Unknown", (Option<String>)None$.MODULE$, "Unknown", null, (Seq<Object>)Nil$.MODULE$, (Seq<AccumulableInfo>)Nil$.MODULE$, (Option<Map<Object, TaskData>>)None$.MODULE$, (Option<Map<String, ExecutorStageSummary>>)None$.MODULE$, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))));
    }

    public JobPage(JobsTab parent, AppStatusStore store) {
        this.parent = parent;
        this.store = store;
        super("job");
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("height", (Seq)new Text("85px"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md2);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md3);
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("completed-stage-legend"), (MetaData)$md3);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md4);
        $md4 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md4);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Completed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md5);
        $md5 = new UnprefixedAttribute("class", (Seq)new Text("failed-stage-legend"), (MetaData)$md5);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md6 = Null$.MODULE$;
        $md6 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md6);
        $md6 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md6);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Failed"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md6, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md7 = Null$.MODULE$;
        $md7 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("y", (Seq)new Text("55px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md7);
        $md7 = new UnprefixedAttribute("class", (Seq)new Text("active-stage-legend"), (MetaData)$md7);
        $buf2.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md7, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md8 = Null$.MODULE$;
        $md8 = new UnprefixedAttribute("y", (Seq)new Text("67px"), (MetaData)$md8);
        $md8 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md8);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Active"));
        $buf2.$amp$plus((Object)new Elem(null, "text", (MetaData)$md8, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        this.STAGES_LEGEND = (String)new StringOps(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf).toString())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JobPage.$anonfun$STAGES_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$1))));
        Null$ $md9 = Null$.MODULE$;
        $md9 = new UnprefixedAttribute("class", (Seq)new Text("legend-area"), (MetaData)$md9);
        NodeBuffer $buf6 = new NodeBuffer();
        Null$ $md10 = Null$.MODULE$;
        $md10 = new UnprefixedAttribute("height", (Seq)new Text("55px"), (MetaData)$md10);
        $md10 = new UnprefixedAttribute("width", (Seq)new Text("150px"), (MetaData)$md10);
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md11 = Null$.MODULE$;
        $md11 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("y", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md11);
        $md11 = new UnprefixedAttribute("class", (Seq)new Text("executor-added-legend"), (MetaData)$md11);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md11, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md12 = Null$.MODULE$;
        $md12 = new UnprefixedAttribute("y", (Seq)new Text("17px"), (MetaData)$md12);
        $md12 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md12);
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("Added"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md12, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md13 = Null$.MODULE$;
        $md13 = new UnprefixedAttribute("ry", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("rx", (Seq)new Text("2px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("height", (Seq)new Text("15px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("width", (Seq)new Text("20px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("y", (Seq)new Text("30px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("x", (Seq)new Text("5px"), (MetaData)$md13);
        $md13 = new UnprefixedAttribute("class", (Seq)new Text("executor-removed-legend"), (MetaData)$md13);
        $buf7.$amp$plus((Object)new Elem(null, "rect", (MetaData)$md13, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0])));
        $buf7.$amp$plus((Object)new Text("\n      "));
        Null$ $md14 = Null$.MODULE$;
        $md14 = new UnprefixedAttribute("y", (Seq)new Text("42px"), (MetaData)$md14);
        $md14 = new UnprefixedAttribute("x", (Seq)new Text("35px"), (MetaData)$md14);
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("Removed"));
        $buf7.$amp$plus((Object)new Elem(null, "text", (MetaData)$md14, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf7.$amp$plus((Object)new Text("\n    "));
        $buf6.$amp$plus((Object)new Elem(null, "svg", (MetaData)$md10, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        this.EXECUTORS_LEGEND = (String)new StringOps(Predef$.MODULE$.augmentString(new Elem(null, "div", (MetaData)$md9, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6).toString())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JobPage.$anonfun$EXECUTORS_LEGEND$1(BoxesRunTime.unboxToChar((Object)x$2))));
    }
}

