/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u0001\u0003\u0001-\u0011Ab\u0015;pe\u0006<W\rT3wK2T!a\u0001\u0003\u0002\u000fM$xN]1hK*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\t9\u0002#\u0001\u0002j_&\u0011\u0011D\u0006\u0002\u000f\u000bb$XM\u001d8bY&T\u0018M\u00197f\u0011!Y\u0002A!a\u0001\n\u0013a\u0012\u0001C0vg\u0016$\u0015n]6\u0016\u0003u\u0001\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005%\u0001\t\u0005\r\u0011\"\u0003&\u00031yVo]3ESN\\w\fJ3r)\t1\u0013\u0006\u0005\u0002\u001fO%\u0011\u0001f\b\u0002\u0005+:LG\u000fC\u0004+G\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013\u0007\u0003\u0005-\u0001\t\u0005\t\u0015)\u0003\u001e\u0003%yVo]3ESN\\\u0007\u0005\u0003\u0005/\u0001\t\u0005\r\u0011\"\u0003\u001d\u0003)yVo]3NK6|'/\u001f\u0005\ta\u0001\u0011\t\u0019!C\u0005c\u0005qq,^:f\u001b\u0016lwN]=`I\u0015\fHC\u0001\u00143\u0011\u001dQs&!AA\u0002uA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006K!H\u0001\f?V\u001cX-T3n_JL\b\u0005\u0003\u00057\u0001\t\u0005\r\u0011\"\u0003\u001d\u0003-yVo]3PM\u001aDU-\u00199\t\u0011a\u0002!\u00111A\u0005\ne\nqbX;tK>3g\rS3ba~#S-\u001d\u000b\u0003MiBqAK\u001c\u0002\u0002\u0003\u0007Q\u0004\u0003\u0005=\u0001\t\u0005\t\u0015)\u0003\u001e\u00031yVo]3PM\u001aDU-\u00199!\u0011!q\u0004A!a\u0001\n\u0013a\u0012!D0eKN,'/[1mSj,G\r\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0003B\u0003EyF-Z:fe&\fG.\u001b>fI~#S-\u001d\u000b\u0003M\tCqAK \u0002\u0002\u0003\u0007Q\u0004\u0003\u0005E\u0001\t\u0005\t\u0015)\u0003\u001e\u00039yF-Z:fe&\fG.\u001b>fI\u0002B\u0001B\u0012\u0001\u0003\u0002\u0004%IaR\u0001\r?J,\u0007\u000f\\5dCRLwN\\\u000b\u0002\u0011B\u0011a$S\u0005\u0003\u0015~\u00111!\u00138u\u0011!a\u0005A!a\u0001\n\u0013i\u0015\u0001E0sKBd\u0017nY1uS>tw\fJ3r)\t1c\nC\u0004+\u0017\u0006\u0005\t\u0019\u0001%\t\u0011A\u0003!\u0011!Q!\n!\u000bQb\u0018:fa2L7-\u0019;j_:\u0004\u0003\"\u0002*\u0001\t\u0013\u0019\u0016A\u0002\u001fj]&$h\b\u0006\u0004U-^C\u0016L\u0017\t\u0003+\u0002i\u0011A\u0001\u0005\u00067E\u0003\r!\b\u0005\u0006]E\u0003\r!\b\u0005\u0006mE\u0003\r!\b\u0005\u0006}E\u0003\r!\b\u0005\b\rF\u0003\n\u00111\u0001I\u0011\u0015\u0011\u0006\u0001\"\u0003])\r!Vl\u0018\u0005\u0006=n\u0003\r\u0001S\u0001\u0006M2\fwm\u001d\u0005\u0006An\u0003\r\u0001S\u0001\fe\u0016\u0004H.[2bi&|g\u000eC\u0003S\u0001\u0011\u0005!\rF\u0001U\u0011\u0015!\u0007\u0001\"\u0001\u001d\u0003\u001d)8/\u001a#jg.DQA\u001a\u0001\u0005\u0002q\t\u0011\"^:f\u001b\u0016lwN]=\t\u000b!\u0004A\u0011\u0001\u000f\u0002\u0015U\u001cXm\u00144g\u0011\u0016\f\u0007\u000fC\u0003k\u0001\u0011\u0005A$\u0001\u0007eKN,'/[1mSj,G\rC\u0003a\u0001\u0011\u0005q\t\u0003\u0004n\u0001\u0011\u0005AA\\\u0001\u000b[\u0016lwN]=N_\u0012,W#A8\u0011\u0005A\u001cX\"A9\u000b\u0005I$\u0011AB7f[>\u0014\u00180\u0003\u0002uc\nQQ*Z7peflu\u000eZ3\t\u000bY\u0004A\u0011\t2\u0002\u000b\rdwN\\3\t\u000ba\u0004A\u0011I=\u0002\r\u0015\fX/\u00197t)\ti\"\u0010C\u0003|o\u0002\u0007A0A\u0003pi\",'\u000f\u0005\u0002\u001f{&\u0011ap\b\u0002\u0004\u0003:L\bBBA\u0001\u0001\u0011\u0005A$A\u0004jgZ\u000bG.\u001b3\t\r\u0005\u0015\u0001\u0001\"\u0001H\u0003\u0015!x.\u00138u\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\tQb\u001e:ji\u0016,\u0005\u0010^3s]\u0006dGc\u0001\u0014\u0002\u000e!A\u0011qBA\u0004\u0001\u0004\t\t\"A\u0002pkR\u00042!FA\n\u0013\r\t)B\u0006\u0002\r\u001f\nTWm\u0019;PkR\u0004X\u000f\u001e\u0005\b\u00033\u0001A\u0011IA\u000e\u00031\u0011X-\u00193FqR,'O\\1m)\r1\u0013Q\u0004\u0005\t\u0003?\t9\u00021\u0001\u0002\"\u0005\u0011\u0011N\u001c\t\u0004+\u0005\r\u0012bAA\u0013-\tYqJ\u00196fGRLe\u000e];u\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\t1B]3bIJ+7o\u001c7wKR\tA\u0002\u000b\u0004\u0002(\u0005=\u00121\b\t\u0006=\u0005E\u0012QG\u0005\u0004\u0003gy\"A\u0002;ie><8\u000fE\u0002\u0016\u0003oI1!!\u000f\u0017\u0005-Iu*\u0012=dKB$\u0018n\u001c8$\u0005\u0005U\u0002bBA \u0001\u0011\u0005\u0013\u0011I\u0001\ti>\u001cFO]5oOR\u0011\u00111\t\t\u0005\u0003\u000b\n\u0019F\u0004\u0003\u0002H\u0005=\u0003cAA%?5\u0011\u00111\n\u0006\u0004\u0003\u001bR\u0011A\u0002\u001fs_>$h(C\u0002\u0002R}\ta\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)?!9\u00111\f\u0001\u0005B\u0005u\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003!Cq!!\u0019\u0001\t\u0003\t\u0019'A\u0006eKN\u001c'/\u001b9uS>tWCAA\"Q\r\u0001\u0011q\r\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011Q\u000e\u0003\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002r\u0005-$\u0001\u0004#fm\u0016dw\u000e]3s\u0003BLwaBA;\u0005!\u0005\u0011qO\u0001\r'R|'/Y4f\u0019\u00164X\r\u001c\t\u0004+\u0006edAB\u0001\u0003\u0011\u0003\tYh\u0005\u0004\u0002z\u0005u\u00141\u0011\t\u0004=\u0005}\u0014bAAA?\t1\u0011I\\=SK\u001a\u00042AHAC\u0013\r\t9i\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b%\u0006eD\u0011AAF)\t\t9\b\u0003\u0006\u0002\u0010\u0006e$\u0019!C\u0001\u0003#\u000bAAT(O\u000bV\tA\u000b\u0003\u0005\u0002\u0016\u0006e\u0004\u0015!\u0003U\u0003\u0015quJT#!\u0011)\tI*!\u001fC\u0002\u0013\u0005\u0011\u0011S\u0001\n\t&\u001b6jX(O\u0019fC\u0001\"!(\u0002z\u0001\u0006I\u0001V\u0001\u000b\t&\u001b6jX(O\u0019f\u0003\u0003BCAQ\u0003s\u0012\r\u0011\"\u0001\u0002\u0012\u0006YA)S*L?>sE*W03\u0011!\t)+!\u001f!\u0002\u0013!\u0016\u0001\u0004#J'.{vJ\u0014'Z?J\u0002\u0003BCAU\u0003s\u0012\r\u0011\"\u0001\u0002\u0012\u0006YQ*R'P%f{vJ\u0014'Z\u0011!\ti+!\u001f!\u0002\u0013!\u0016\u0001D'F\u001b>\u0013\u0016lX(O\u0019f\u0003\u0003BCAY\u0003s\u0012\r\u0011\"\u0001\u0002\u0012\u0006iQ*R'P%f{vJ\u0014'Z?JB\u0001\"!.\u0002z\u0001\u0006I\u0001V\u0001\u000f\u001b\u0016kuJU-`\u001f:c\u0015l\u0018\u001a!\u0011)\tI,!\u001fC\u0002\u0013\u0005\u0011\u0011S\u0001\u0010\u001b\u0016kuJU-`\u001f:c\u0015lX*F%\"A\u0011QXA=A\u0003%A+\u0001\tN\u000b6{%+W0P\u001d2KvlU#SA!Q\u0011\u0011YA=\u0005\u0004%\t!!%\u0002#5+Uj\u0014*Z?>sE*W0T\u000bJ{&\u0007\u0003\u0005\u0002F\u0006e\u0004\u0015!\u0003U\u0003IiU)T(S3~{e\nT-`'\u0016\u0013vL\r\u0011\t\u0015\u0005%\u0017\u0011\u0010b\u0001\n\u0003\t\t*A\bN\u000b6{%+W0B\u001d\u0012{F)S*L\u0011!\ti-!\u001f!\u0002\u0013!\u0016\u0001E'F\u001b>\u0013\u0016lX!O\t~#\u0015jU&!\u0011)\t\t.!\u001fC\u0002\u0013\u0005\u0011\u0011S\u0001\u0012\u001b\u0016kuJU-`\u0003:#u\fR%T\u0017~\u0013\u0004\u0002CAk\u0003s\u0002\u000b\u0011\u0002+\u0002%5+Uj\u0014*Z?\u0006sEi\u0018#J'.{&\u0007\t\u0005\u000b\u00033\fIH1A\u0005\u0002\u0005E\u0015aE'F\u001b>\u0013\u0016lX!O\t~#\u0015jU&`'\u0016\u0013\u0006\u0002CAo\u0003s\u0002\u000b\u0011\u0002+\u0002)5+Uj\u0014*Z?\u0006sEi\u0018#J'.{6+\u0012*!\u0011)\t\t/!\u001fC\u0002\u0013\u0005\u0011\u0011S\u0001\u0016\u001b\u0016kuJU-`\u0003:#u\fR%T\u0017~\u001bVIU03\u0011!\t)/!\u001f!\u0002\u0013!\u0016AF'F\u001b>\u0013\u0016lX!O\t~#\u0015jU&`'\u0016\u0013vL\r\u0011\t\u0015\u0005%\u0018\u0011\u0010b\u0001\n\u0003\t\t*\u0001\u0005P\r\u001a{\u0006*R!Q\u0011!\ti/!\u001f!\u0002\u0013!\u0016!C(G\r~CU)\u0011)!\u0011!\t\t0!\u001f\u0005\u0002\u0005M\u0018A\u00034s_6\u001cFO]5oOR\u0019A+!>\t\u0011\u0005]\u0018q\u001ea\u0001\u0003\u0007\n\u0011a\u001d\u0015\u0005\u0003_\f9\u0007\u0003\u0005\u0002~\u0006eD\u0011AA\u0000\u0003\u0015\t\u0007\u000f\u001d7z)-!&\u0011\u0001B\u0002\u0005\u000b\u00119A!\u0003\t\r\u0011\fY\u00101\u0001\u001e\u0011\u00191\u00171 a\u0001;!1\u0001.a?A\u0002uAaA[A~\u0001\u0004i\u0002B\u00021\u0002|\u0002\u0007\u0001\n\u000b\u0003\u0002|\u0006\u001d\u0004\u0002CA\u007f\u0003s\"\tAa\u0004\u0015\u0013Q\u0013\tBa\u0005\u0003\u0016\t]\u0001B\u00023\u0003\u000e\u0001\u0007Q\u0004\u0003\u0004g\u0005\u001b\u0001\r!\b\u0005\u0007U\n5\u0001\u0019A\u000f\t\u0011\u0001\u0014i\u0001%AA\u0002!CCA!\u0004\u0002h!A\u0011Q`A=\t\u0003\u0011i\u0002F\u0003U\u0005?\u0011\t\u0003\u0003\u0004_\u00057\u0001\r\u0001\u0013\u0005\u0007A\nm\u0001\u0019\u0001%)\t\tm\u0011q\r\u0005\t\u0003{\fI\b\"\u0001\u0003(Q\u0019AK!\u000b\t\u0011\u0005}!Q\u0005a\u0001\u0003CACA!\n\u0002h!Y!qFA=\u0005\u0004%\t\u0001\u0002B\u0019\u0003E\u0019Ho\u001c:bO\u0016dUM^3m\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0005g\u0001bA!\u000e\u0003@Q#VB\u0001B\u001c\u0015\u0011\u0011IDa\u000f\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0003>A\tA!\u001e;jY&!!\u0011\tB\u001c\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\u0005\n\u0005\u000b\nI\b)A\u0005\u0005g\t!c\u001d;pe\u0006<W\rT3wK2\u001c\u0015m\u00195fA!I!\u0011JA=\t\u0003!!1J\u0001\u0016O\u0016$8)Y2iK\u0012\u001cFo\u001c:bO\u0016dUM^3m)\r!&Q\n\u0005\b\u0005\u001f\u00129\u00051\u0001U\u0003\u0015aWM^3m\u0011)\u0011\u0019&!\u001f\u0012\u0002\u0013%!QK\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t]#f\u0001%\u0003Z-\u0012!1\f\t\u0005\u0005;\u0012)'\u0004\u0002\u0003`)!!\u0011\rB2\u0003%)hn\u00195fG.,GMC\u0002\u0002n}IAAa\u001a\u0003`\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\t-\u0014\u0011PI\u0001\n\u0003\u0011)&A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\tI#!\u001f\u0002\u0002\u0013%\u00111\u0006")
public class StorageLevel
implements Externalizable {
    private boolean _useDisk;
    private boolean _useMemory;
    private boolean _useOffHeap;
    private boolean _deserialized;
    private int _replication;

    public static int apply$default$4() {
        return StorageLevel$.MODULE$.apply$default$4();
    }

    @DeveloperApi
    public static StorageLevel apply(ObjectInput objectInput) {
        return StorageLevel$.MODULE$.apply(objectInput);
    }

    @DeveloperApi
    public static StorageLevel apply(int n, int n2) {
        return StorageLevel$.MODULE$.apply(n, n2);
    }

    @DeveloperApi
    public static StorageLevel apply(boolean bl, boolean bl2, boolean bl3, int n) {
        return StorageLevel$.MODULE$.apply(bl, bl2, bl3, n);
    }

    @DeveloperApi
    public static StorageLevel apply(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n) {
        return StorageLevel$.MODULE$.apply(bl, bl2, bl3, bl4, n);
    }

    @DeveloperApi
    public static StorageLevel fromString(String string) {
        return StorageLevel$.MODULE$.fromString(string);
    }

    public static StorageLevel OFF_HEAP() {
        return StorageLevel$.MODULE$.OFF_HEAP();
    }

    public static StorageLevel MEMORY_AND_DISK_SER_2() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2();
    }

    public static StorageLevel MEMORY_AND_DISK_SER() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER();
    }

    public static StorageLevel MEMORY_AND_DISK_2() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_2();
    }

    public static StorageLevel MEMORY_AND_DISK() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public static StorageLevel MEMORY_ONLY_SER_2() {
        return StorageLevel$.MODULE$.MEMORY_ONLY_SER_2();
    }

    public static StorageLevel MEMORY_ONLY_SER() {
        return StorageLevel$.MODULE$.MEMORY_ONLY_SER();
    }

    public static StorageLevel MEMORY_ONLY_2() {
        return StorageLevel$.MODULE$.MEMORY_ONLY_2();
    }

    public static StorageLevel MEMORY_ONLY() {
        return StorageLevel$.MODULE$.MEMORY_ONLY();
    }

    public static StorageLevel DISK_ONLY_2() {
        return StorageLevel$.MODULE$.DISK_ONLY_2();
    }

    public static StorageLevel DISK_ONLY() {
        return StorageLevel$.MODULE$.DISK_ONLY();
    }

    public static StorageLevel NONE() {
        return StorageLevel$.MODULE$.NONE();
    }

    private boolean _useDisk() {
        return this._useDisk;
    }

    private void _useDisk_$eq(boolean x$1) {
        this._useDisk = x$1;
    }

    private boolean _useMemory() {
        return this._useMemory;
    }

    private void _useMemory_$eq(boolean x$1) {
        this._useMemory = x$1;
    }

    private boolean _useOffHeap() {
        return this._useOffHeap;
    }

    private void _useOffHeap_$eq(boolean x$1) {
        this._useOffHeap = x$1;
    }

    private boolean _deserialized() {
        return this._deserialized;
    }

    private void _deserialized_$eq(boolean x$1) {
        this._deserialized = x$1;
    }

    private int _replication() {
        return this._replication;
    }

    private void _replication_$eq(int x$1) {
        this._replication = x$1;
    }

    public boolean useDisk() {
        return this._useDisk();
    }

    public boolean useMemory() {
        return this._useMemory();
    }

    public boolean useOffHeap() {
        return this._useOffHeap();
    }

    public boolean deserialized() {
        return this._deserialized();
    }

    public int replication() {
        return this._replication();
    }

    public MemoryMode memoryMode() {
        return this.useOffHeap() ? MemoryMode.OFF_HEAP : MemoryMode.ON_HEAP;
    }

    public StorageLevel clone() {
        return new StorageLevel(this.useDisk(), this.useMemory(), this.useOffHeap(), this.deserialized(), this.replication());
    }

    public boolean equals(Object other) {
        StorageLevel storageLevel;
        Object object = other;
        boolean bl = object instanceof StorageLevel ? (storageLevel = (StorageLevel)object).useDisk() == this.useDisk() && storageLevel.useMemory() == this.useMemory() && storageLevel.useOffHeap() == this.useOffHeap() && storageLevel.deserialized() == this.deserialized() && storageLevel.replication() == this.replication() : false;
        return bl;
    }

    public boolean isValid() {
        return (this.useMemory() || this.useDisk()) && this.replication() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public int toInt() {
        void var1_1;
        block3: {
            int ret = 0;
            if (this._useDisk()) {
                ret |= 8;
            }
            if (this._useMemory()) {
                ret |= 4;
            }
            if (this._useOffHeap()) {
                ret |= 2;
            }
            if (!this._deserialized()) break block3;
            ret |= 1;
        }
        return (int)var1_1;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            out.writeByte(this.toInt());
            out.writeByte(this._replication());
        });
    }

    @Override
    public void readExternal(ObjectInput in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            byte flags = in.readByte();
            this._useDisk_$eq((flags & 8) != 0);
            this._useMemory_$eq((flags & 4) != 0);
            this._useOffHeap_$eq((flags & 2) != 0);
            this._deserialized_$eq((flags & 1) != 0);
            this._replication_$eq(in.readByte());
        });
    }

    private Object readResolve() throws IOException {
        return StorageLevel$.MODULE$.getCachedStorageLevel(this);
    }

    public String toString() {
        String disk = this.useDisk() ? "disk" : "";
        String memory = this.useMemory() ? "memory" : "";
        String heap = this.useOffHeap() ? "offheap" : "";
        String deserialize = this.deserialized() ? "deserialized" : "";
        Seq output = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{disk, memory, heap, deserialize, new StringBuilder(9).append(this.replication()).append(" replicas").toString()}))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StorageLevel.$anonfun$toString$1(x$1)));
        return new StringBuilder(14).append("StorageLevel(").append(output.mkString(", ")).append(")").toString();
    }

    public int hashCode() {
        return this.toInt() * 41 + this.replication();
    }

    /*
     * WARNING - void declaration
     */
    public String description() {
        void var1_1;
        String result = "";
        result = new StringBuilder(0).append(result).append((Object)(this.useDisk() ? "Disk " : "")).toString();
        if (this.useMemory()) {
            result = new StringBuilder(0).append(result).append((Object)(this.useOffHeap() ? "Memory (off heap) " : "Memory ")).toString();
        }
        result = new StringBuilder(0).append(result).append((Object)(this.deserialized() ? "Deserialized " : "Serialized ")).toString();
        result = new StringBuilder(0).append(result).append(new StringBuilder(12).append(this.replication()).append("x Replicated").toString()).toString();
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$toString$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public StorageLevel(boolean _useDisk, boolean _useMemory, boolean _useOffHeap, boolean _deserialized, int _replication) {
        block0: {
            this._useDisk = _useDisk;
            this._useMemory = _useMemory;
            this._useOffHeap = _useOffHeap;
            this._deserialized = _deserialized;
            this._replication = _replication;
            Predef$.MODULE$.assert(this.replication() < 40, (Function0 & Serializable & scala.Serializable)() -> "Replication restricted to be less than 40 for calculating hash codes");
            if (!this.useOffHeap()) break block0;
            Predef$.MODULE$.require(!this.deserialized(), (Function0 & Serializable & scala.Serializable)() -> "Off-heap storage level does not support deserialized storage");
        }
    }

    public StorageLevel(int flags, int replication) {
        this((flags & 8) != 0, (flags & 4) != 0, (flags & 2) != 0, (flags & 1) != 0, replication);
    }

    public StorageLevel() {
        this(false, true, false, false, StorageLevel$.MODULE$.org$apache$spark$storage$StorageLevel$$$lessinit$greater$default$5());
    }
}

